/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller;

import java.io.File;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.as.controller.persistence.ConfigurationFile;
import org.jboss.as.controller.persistence.ExtensibleConfigurationPersister;
import org.jboss.as.controller.registry.ModelNodeRegistration;
import org.jboss.as.domain.controller.DomainModelImpl;
import org.jboss.as.host.controller.ConfigurationPersisterFactory;
import org.jboss.as.host.controller.DomainModelProxy;
import org.jboss.as.host.controller.HostController;
import org.jboss.as.host.controller.HostControllerEnvironment;
import org.jboss.as.host.controller.HostControllerService;
import org.jboss.as.host.controller.HostModelUtil;
import org.jboss.as.host.controller.ManagedServerLifecycleCallback;
import org.jboss.as.host.controller.ProcessControllerConnectionService;
import org.jboss.as.host.controller.ServerInventory;
import org.jboss.as.host.controller.ServerInventoryService;
import org.jboss.as.host.controller.mgmt.ManagementCommunicationService;
import org.jboss.as.host.controller.mgmt.ManagementCommunicationServiceInjector;
import org.jboss.as.host.controller.mgmt.ServerToHostOperationHandler;
import org.jboss.as.protocol.mgmt.ManagementOperationHandler;
import org.jboss.as.server.services.net.NetworkInterfaceBinding;
import org.jboss.as.server.services.net.NetworkInterfaceService;
import org.jboss.as.threads.ThreadFactoryService;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;

public class HostControllerBootstrap {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.host.controller");
    static final ServiceName SERVICE_NAME_BASE = ServiceName.JBOSS.append(new String[]{"host", "controller"});
    static final int DEFAULT_POOL_SIZE = 20;
    private final ServiceContainer serviceContainer = ServiceContainer.Factory.create();
    private final HostControllerEnvironment environment;
    private final byte[] authCode;

    public HostControllerBootstrap(HostControllerEnvironment environment, byte[] authCode) {
        this.environment = environment;
        this.authCode = authCode;
    }

    public void start() throws Exception {
        File configDir = this.environment.getDomainConfigurationDir();
        ConfigurationFile configurationFile = this.environment.getHostConfigurationFile();
        ExtensibleConfigurationPersister configurationPersister = HostControllerBootstrap.createHostConfigurationPersister(configDir, configurationFile);
        List operations = configurationPersister.load();
        ServiceContainer serviceTarget = this.serviceContainer;
        serviceTarget.addListener((ServiceListener)new AbstractServiceListener<Object>(){

            public void serviceFailed(ServiceController<?> serviceController, StartException reason) {
                log.errorf((Throwable)reason, "Service [%s] failed.", (Object)serviceController.getName());
            }
        });
        this.registerBaseServices((ServiceTarget)serviceTarget);
        DomainModelProxyImpl domainModelProxy = new DomainModelProxyImpl();
        ModelNodeRegistration hostRegistry = HostModelUtil.createHostRegistry(configurationPersister, this.environment, domainModelProxy);
        ModelNodeRegistration rootRegistration = HostModelUtil.createBootstrapHostRegistry(hostRegistry, domainModelProxy);
        DomainModelImpl domainModel = new DomainModelImpl(rootRegistration, this.serviceContainer, configurationPersister);
        domainModelProxy.setDomainModel(domainModel);
        final AtomicInteger count = new AtomicInteger(1);
        ResultHandler resultHandler = new ResultHandler(){

            public void handleResultFragment(String[] location, ModelNode result) {
            }

            public void handleResultComplete() {
                if (count.decrementAndGet() == 0) {
                    // empty if block
                }
            }

            public void handleFailed(ModelNode failureDescription) {
                if (count.decrementAndGet() == 0) {
                    // empty if block
                }
            }

            public void handleCancellation() {
                if (count.decrementAndGet() == 0) {
                    // empty if block
                }
            }
        };
        for (ModelNode operation : operations) {
            count.incrementAndGet();
            operation.get(new String[]{"operation-headers", "rollback-on-runtime-failure"}).set(false);
            domainModel.execute(OperationBuilder.Factory.create((ModelNode)operation).build(), resultHandler);
        }
        if (count.decrementAndGet() == 0) {
            // empty if block
        }
        String hostName = domainModel.getLocalHostName();
        ModelNode hostModelNode = domainModel.getHostModel();
        String mgmtNetwork = hostModelNode.get(new String[]{"management-interfaces", "native-interface", "interface"}).asString();
        int mgmtPort = hostModelNode.get(new String[]{"management-interfaces", "native-interface", "port"}).asInt();
        ServerInventoryService inventory = new ServerInventoryService(this.environment, mgmtPort);
        serviceTarget.addService(ServerInventoryService.SERVICE_NAME, (Service)inventory).addDependency(ProcessControllerConnectionService.SERVICE_NAME, ProcessControllerConnectionService.class, inventory.getClient()).addDependency(NetworkInterfaceService.JBOSS_NETWORK_INTERFACE.append(new String[]{mgmtNetwork}), NetworkInterfaceBinding.class, inventory.getInterface()).install();
        HostControllerService hc = new HostControllerService(hostName, hostModelNode, configurationPersister, hostRegistry);
        serviceTarget.addService(HostController.SERVICE_NAME, (Service)hc).addDependency(ServerInventoryService.SERVICE_NAME, ServerInventory.class, hc.getServerInventory()).addDependency(ServerToHostOperationHandler.SERVICE_NAME).setInitialMode(ServiceController.Mode.ACTIVE).install();
        ServerToHostOperationHandler serverToHost = new ServerToHostOperationHandler();
        serviceTarget.addService(ServerToHostOperationHandler.SERVICE_NAME, (Service)serverToHost).addDependency(ServerInventoryService.SERVICE_NAME, ManagedServerLifecycleCallback.class, serverToHost.getCallback()).addDependency(ManagementCommunicationService.SERVICE_NAME, ManagementCommunicationService.class, (Injector)new ManagementCommunicationServiceInjector((Value<? extends ManagementOperationHandler>)serverToHost)).install();
    }

    private void registerBaseServices(ServiceTarget serviceTarget) {
        ProcessControllerConnectionService processControllerClient = new ProcessControllerConnectionService(this.environment, this.authCode);
        serviceTarget.addService(ProcessControllerConnectionService.SERVICE_NAME, (Service)processControllerClient).install();
        ServiceName threadFactoryServiceName = SERVICE_NAME_BASE.append(new String[]{"thread-factory"});
        ServiceName executorServiceName = SERVICE_NAME_BASE.append(new String[]{"executor"});
        serviceTarget.addService(threadFactoryServiceName, (Service)new ThreadFactoryService()).install();
        HostControllerExecutorService executorService = new HostControllerExecutorService();
        serviceTarget.addService(executorServiceName, (Service)executorService).addDependency(threadFactoryServiceName, ThreadFactory.class, executorService.threadFactoryValue).install();
    }

    static ExtensibleConfigurationPersister createHostConfigurationPersister(File configDir, ConfigurationFile configurationFile) {
        return ConfigurationPersisterFactory.createHostXmlConfigurationPersister(configDir, configurationFile);
    }

    static final class DomainModelProxyImpl
    implements DomainModelProxy {
        private DomainModelImpl domainModel;

        DomainModelProxyImpl() {
        }

        public void setDomainModel(DomainModelImpl domainModel) {
            this.domainModel = domainModel;
        }

        @Override
        public DomainModelImpl getDomainModel() {
            if (this.domainModel == null) {
                throw new IllegalStateException("DomainModel has not been set.");
            }
            return this.domainModel;
        }
    }

    static final class HostControllerExecutorService
    implements Service<Executor> {
        final InjectedValue<ThreadFactory> threadFactoryValue = new InjectedValue();
        private ScheduledExecutorService executorService;

        HostControllerExecutorService() {
        }

        public synchronized void start(StartContext context) throws StartException {
            this.executorService = Executors.newScheduledThreadPool(20, (ThreadFactory)this.threadFactoryValue.getValue());
        }

        public synchronized void stop(StopContext context) {
            this.executorService.shutdown();
        }

        public synchronized ScheduledExecutorService getValue() throws IllegalStateException {
            return this.executorService;
        }
    }
}

