/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.operations;

import java.util.Locale;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelUpdateOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.RuntimeTask;
import org.jboss.as.controller.RuntimeTaskContext;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.domain.controller.DomainModelImpl;
import org.jboss.as.host.controller.DomainModelProxy;
import org.jboss.as.host.controller.HostControllerEnvironment;
import org.jboss.as.host.controller.LocalFileRepository;
import org.jboss.as.host.controller.operations.DomainControllerAddUtil;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceTarget;

public class LocalDomainControllerAddHandler
implements ModelUpdateOperationHandler,
DescriptionProvider {
    public static final String OPERATION_NAME = "write-local-domain-controller";
    private final DomainModelProxy domainModelProxy;
    private final HostControllerEnvironment environment;

    public static ModelNode getAddDomainControllerOperation(ModelNode address) {
        ModelNode op = Util.getEmptyOperation((String)"add", (ModelNode)address);
        return op;
    }

    public static LocalDomainControllerAddHandler getInstance(DomainModelProxy domainModelProxy, HostControllerEnvironment environment) {
        return new LocalDomainControllerAddHandler(domainModelProxy, environment);
    }

    LocalDomainControllerAddHandler(DomainModelProxy domainModelProxy, HostControllerEnvironment environment) {
        this.domainModelProxy = domainModelProxy;
        this.environment = environment;
    }

    public OperationResult execute(OperationContext context, ModelNode operation, ResultHandler resultHandler) throws OperationFailedException {
        try {
            ModelNode model = context.getSubModel();
            model.get("domain-controller").get("local").setEmptyObject();
            if (context.getRuntimeContext() != null) {
                final DomainModelImpl domainModel = this.domainModelProxy.getDomainModel();
                context.getRuntimeContext().setRuntimeTask(new RuntimeTask(){

                    public void execute(RuntimeTaskContext context) throws OperationFailedException {
                        ServiceTarget serviceTarget = context.getServiceTarget();
                        LocalFileRepository fileRepository = new LocalFileRepository(LocalDomainControllerAddHandler.this.environment);
                        DomainControllerAddUtil.installLocalDomainController(LocalDomainControllerAddHandler.this.environment, domainModel.getHostModel(), serviceTarget, false, fileRepository, LocalDomainControllerAddHandler.this.domainModelProxy.getDomainModel());
                    }
                });
            }
            ModelNode compensating = Util.getResourceRemoveOperation((ModelNode)operation.get("address"));
            resultHandler.handleResultComplete();
            return new BasicOperationResult(compensating);
        }
        catch (Exception e) {
            throw new OperationFailedException(new ModelNode().set(e.getLocalizedMessage()));
        }
    }

    public ModelNode getModelDescription(Locale locale) {
        return new ModelNode();
    }
}

