/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.metadata.deployment;

import org.jboss.as.connector.ConnectorServices;
import org.jboss.as.connector.metadata.deployment.ResourceAdapterDeployment;
import org.jboss.as.connector.registry.ResourceAdapterDeploymentRegistry;
import org.jboss.jca.core.api.management.ManagementRepository;
import org.jboss.jca.core.spi.mdr.MetadataRepository;
import org.jboss.jca.core.spi.mdr.NotFoundException;
import org.jboss.jca.core.spi.rar.ResourceAdapterRepository;
import org.jboss.logging.Logger;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public abstract class AbstractResourceAdapterDeploymentService {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.deployment.connector");
    protected ResourceAdapterDeployment value;
    protected final InjectedValue<MetadataRepository> mdr = new InjectedValue();
    protected final InjectedValue<ResourceAdapterRepository> raRepository = new InjectedValue();
    protected final InjectedValue<ResourceAdapterDeploymentRegistry> registry = new InjectedValue();
    protected final InjectedValue<ManagementRepository> managementRepository = new InjectedValue();

    public ResourceAdapterDeployment getValue() throws IllegalStateException {
        return ConnectorServices.notNull(this.value);
    }

    public void stop(StopContext context) {
        if (this.value != null) {
            String jndi;
            log.debugf("Undeploying: %s", (Object)(this.value.getDeployment() != null ? this.value.getDeployment().getDeploymentName() : ""));
            if (this.registry != null && this.registry.getValue() != null) {
                ((ResourceAdapterDeploymentRegistry)this.registry.getValue()).unregisterResourceAdapterDeployment(this.value);
            }
            if (this.mdr != null && this.mdr.getValue() != null) {
                try {
                    ((MetadataRepository)this.mdr.getValue()).unregisterResourceAdapter(this.value.getDeployment().getDeploymentName());
                }
                catch (Throwable t) {
                    log.warn((Object)"Exception during unregistering deployment", t);
                }
            }
            if (this.mdr != null && this.mdr.getValue() != null && this.value.getDeployment() != null && this.value.getDeployment().getCfs() != null && this.value.getDeployment().getCfJndiNames() != null) {
                for (int i = 0; i < this.value.getDeployment().getCfs().length; ++i) {
                    try {
                        String cf = this.value.getDeployment().getCfs()[i].getClass().getName();
                        jndi = this.value.getDeployment().getCfJndiNames()[i];
                        ((MetadataRepository)this.mdr.getValue()).unregisterJndiMapping(this.value.getDeployment().getURL().toExternalForm(), cf, jndi);
                        continue;
                    }
                    catch (NotFoundException nfe) {
                        log.warn((Object)"Exception during JNDI unbinding", (Throwable)nfe);
                    }
                }
            }
            if (this.mdr != null && this.mdr.getValue() != null && this.value.getDeployment().getAos() != null && this.value.getDeployment().getAoJndiNames() != null) {
                for (int i = 0; i < this.value.getDeployment().getAos().length; ++i) {
                    try {
                        String ao = this.value.getDeployment().getAos()[i].getClass().getName();
                        jndi = this.value.getDeployment().getAoJndiNames()[i];
                        ((MetadataRepository)this.mdr.getValue()).unregisterJndiMapping(this.value.getDeployment().getURL().toExternalForm(), ao, jndi);
                        continue;
                    }
                    catch (NotFoundException nfe) {
                        log.warn((Object)"Exception during JNDI unbinding", (Throwable)nfe);
                    }
                }
            }
            if (this.value.getDeployment() != null && this.value.getDeployment().getResourceAdapter() != null) {
                this.value.getDeployment().getResourceAdapter().stop();
            }
        }
    }

    public Injector<MetadataRepository> getMdrInjector() {
        return this.mdr;
    }

    public Injector<ResourceAdapterRepository> getRaRepositoryInjector() {
        return this.raRepository;
    }

    public Injector<ManagementRepository> getManagementRepositoryInjector() {
        return this.managementRepository;
    }

    public Injector<ResourceAdapterDeploymentRegistry> getRegistryInjector() {
        return this.registry;
    }
}

