/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.datasources;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.connector.subsystems.datasources.AbstractDataSourceAdd;
import org.jboss.as.connector.subsystems.datasources.Attribute;
import org.jboss.as.connector.subsystems.datasources.DataSourceAdd;
import org.jboss.as.connector.subsystems.datasources.DataSourceDisable;
import org.jboss.as.connector.subsystems.datasources.DataSourceEnable;
import org.jboss.as.connector.subsystems.datasources.DataSourceModelNodeUtil;
import org.jboss.as.connector.subsystems.datasources.DataSourcePoolConfigurationRWHandler;
import org.jboss.as.connector.subsystems.datasources.DataSourceRemove;
import org.jboss.as.connector.subsystems.datasources.DataSourcesMetrics;
import org.jboss.as.connector.subsystems.datasources.DataSourcesSubsystemAdd;
import org.jboss.as.connector.subsystems.datasources.DataSourcesSubsystemProviders;
import org.jboss.as.connector.subsystems.datasources.Element;
import org.jboss.as.connector.subsystems.datasources.JdbcDriverAdd;
import org.jboss.as.connector.subsystems.datasources.JdbcDriverRemove;
import org.jboss.as.connector.subsystems.datasources.Namespace;
import org.jboss.as.connector.subsystems.datasources.XaDataSourceAdd;
import org.jboss.as.connector.subsystems.datasources.XaDataSourcePoolConfigurationRWHandler;
import org.jboss.as.connector.subsystems.datasources.XaDataSourceRemove;
import org.jboss.as.connector.subsystems.datasources.XaDataSourcesMetrics;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.ModelQueryOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationHandler;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.CommonDescriptions;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ModelNodeRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.jca.common.api.metadata.common.CommonPool;
import org.jboss.jca.common.api.metadata.common.CommonXaPool;
import org.jboss.jca.common.api.metadata.ds.DataSource;
import org.jboss.jca.common.api.metadata.ds.DataSources;
import org.jboss.jca.common.api.metadata.ds.DsSecurity;
import org.jboss.jca.common.api.metadata.ds.Statement;
import org.jboss.jca.common.api.metadata.ds.TimeOut;
import org.jboss.jca.common.api.metadata.ds.Validation;
import org.jboss.jca.common.api.metadata.ds.XaDataSource;
import org.jboss.jca.common.metadata.ds.DsParser;
import org.jboss.logging.Logger;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class DataSourcesExtension
implements Extension {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.datasources");

    public void initialize(ExtensionContext context) {
        log.debugf("Initializing Datasources Extension", new Object[0]);
        SubsystemRegistration registration = context.registerSubsystem("datasources");
        registration.registerXMLElementWriter((XMLElementWriter)NewDataSourceSubsystemParser.INSTANCE);
        ModelNodeRegistration subsystem = registration.registerSubsystemModel(DataSourcesSubsystemProviders.SUBSYSTEM);
        subsystem.registerOperationHandler("add", (OperationHandler)DataSourcesSubsystemAdd.INSTANCE, DataSourcesSubsystemProviders.SUBSYSTEM_ADD_DESC, false);
        subsystem.registerOperationHandler("describe", (OperationHandler)DataSourcesSubsystemDescribeHandler.INSTANCE, (DescriptionProvider)DataSourcesSubsystemDescribeHandler.INSTANCE, false, OperationEntry.EntryType.PRIVATE);
        ModelNodeRegistration jdbcDrivers = subsystem.registerSubModel(PathElement.pathElement((String)"jdbc-driver"), DataSourcesSubsystemProviders.JDBC_DRIVER_DESC);
        jdbcDrivers.registerOperationHandler("add", (OperationHandler)JdbcDriverAdd.INSTANCE, DataSourcesSubsystemProviders.ADD_JDBC_DRIVER_DESC, false);
        jdbcDrivers.registerOperationHandler("remove", (OperationHandler)JdbcDriverRemove.INSTANCE, DataSourcesSubsystemProviders.REMOVE_JDBC_DRIVER_DESC, false);
        ModelNodeRegistration dataSources = subsystem.registerSubModel(PathElement.pathElement((String)"data-source"), DataSourcesSubsystemProviders.DATA_SOURCE_DESC);
        dataSources.registerOperationHandler("add", (OperationHandler)DataSourceAdd.INSTANCE, DataSourcesSubsystemProviders.ADD_DATA_SOURCE_DESC, false);
        dataSources.registerOperationHandler("remove", (OperationHandler)DataSourceRemove.INSTANCE, DataSourcesSubsystemProviders.REMOVE_DATA_SOURCE_DESC, false);
        dataSources.registerOperationHandler("enable", (OperationHandler)DataSourceEnable.INSTANCE, DataSourcesSubsystemProviders.ENABLE_DATA_SOURCE_DESC, false);
        dataSources.registerOperationHandler("disable", (OperationHandler)DataSourceDisable.INSTANCE, DataSourcesSubsystemProviders.DISABLE_DATA_SOURCE_DESC, false);
        for (String attributeName : DataSourcesMetrics.ATTRIBUTES) {
            dataSources.registerMetric(attributeName, (OperationHandler)DataSourcesMetrics.INSTANCE);
        }
        for (String attributeName : DataSourcePoolConfigurationRWHandler.ATTRIBUTES) {
            dataSources.registerReadWriteAttribute(attributeName, (OperationHandler)DataSourcePoolConfigurationRWHandler.DataSourcePoolConfigurationReadHandler.INSTANCE, (OperationHandler)DataSourcePoolConfigurationRWHandler.DataSourcePoolConfigurationWriteHandler.INSTANCE, AttributeAccess.Storage.CONFIGURATION);
        }
        ModelNodeRegistration xaDataSources = subsystem.registerSubModel(PathElement.pathElement((String)"xa-data-source"), DataSourcesSubsystemProviders.XA_DATA_SOURCE_DESC);
        xaDataSources.registerOperationHandler("add", (OperationHandler)XaDataSourceAdd.INSTANCE, DataSourcesSubsystemProviders.ADD_XA_DATA_SOURCE_DESC, false);
        xaDataSources.registerOperationHandler("remove", (OperationHandler)XaDataSourceRemove.INSTANCE, DataSourcesSubsystemProviders.REMOVE_XA_DATA_SOURCE_DESC, false);
        xaDataSources.registerOperationHandler("enable", (OperationHandler)DataSourceEnable.INSTANCE, DataSourcesSubsystemProviders.ENABLE_XA_DATA_SOURCE_DESC, false);
        xaDataSources.registerOperationHandler("disable", (OperationHandler)DataSourceDisable.INSTANCE, DataSourcesSubsystemProviders.DISABLE_XA_DATA_SOURCE_DESC, false);
        for (String attributeName : XaDataSourcesMetrics.ATTRIBUTES) {
            xaDataSources.registerMetric(attributeName, (OperationHandler)XaDataSourcesMetrics.INSTANCE);
        }
        for (String attributeName : XaDataSourcePoolConfigurationRWHandler.ATTRIBUTES) {
            xaDataSources.registerReadWriteAttribute(attributeName, (OperationHandler)XaDataSourcePoolConfigurationRWHandler.XaDataSourcePoolConfigurationReadHandler.INSTANCE, (OperationHandler)XaDataSourcePoolConfigurationRWHandler.XaDataSourcePoolConfigurationWriteHandler.INSTANCE, AttributeAccess.Storage.CONFIGURATION);
        }
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(Namespace.CURRENT.getUriString(), (XMLElementReader)NewDataSourceSubsystemParser.INSTANCE);
    }

    private static class DataSourcesSubsystemDescribeHandler
    implements ModelQueryOperationHandler,
    DescriptionProvider {
        static final DataSourcesSubsystemDescribeHandler INSTANCE = new DataSourcesSubsystemDescribeHandler();

        private DataSourcesSubsystemDescribeHandler() {
        }

        public OperationResult execute(OperationContext context, ModelNode operation, ResultHandler resultHandler) {
            ModelNode dataSource;
            ModelNode addOperation;
            ModelNode address;
            ModelNode result = new ModelNode();
            PathAddress rootAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement()});
            ModelNode subModel = context.getSubModel();
            ModelNode subsystemAdd = new ModelNode();
            subsystemAdd.get("operation").set("add");
            subsystemAdd.get("address").set(rootAddress.toModelNode());
            result.add(subsystemAdd);
            if (subModel.hasDefined("jdbc-driver")) {
                for (Property jdbcDriver : subModel.get("jdbc-driver").asPropertyList()) {
                    address = rootAddress.toModelNode();
                    address.add("jdbc-driver", jdbcDriver.getName());
                    addOperation = Util.getEmptyOperation((String)"add", (ModelNode)address);
                    addOperation.get("driver").set(jdbcDriver.getValue().get("driver"));
                    result.add(addOperation);
                }
            }
            if (subModel.hasDefined("data-source")) {
                for (Property dataSourceProp : subModel.get("data-source").asPropertyList()) {
                    address = rootAddress.toModelNode();
                    address.add("data-source", dataSourceProp.getName());
                    addOperation = Util.getEmptyOperation((String)"add", (ModelNode)address);
                    dataSource = dataSourceProp.getValue();
                    AbstractDataSourceAdd.populateAddModel(dataSource, addOperation, "connection-properties", DataSourcesSubsystemProviders.DATASOURCE_ATTRIBUTE);
                    addOperation.get("driver").set(dataSourceProp.getValue().get("driver"));
                    result.add(addOperation);
                }
            }
            if (subModel.hasDefined("xa-data-source")) {
                for (Property dataSourceProp : subModel.get("xa-data-source").asPropertyList()) {
                    address = rootAddress.toModelNode();
                    address.add("xa-data-source", dataSourceProp.getName());
                    addOperation = Util.getEmptyOperation((String)"add", (ModelNode)address);
                    dataSource = dataSourceProp.getValue();
                    AbstractDataSourceAdd.populateAddModel(dataSource, addOperation, "xa-data-source-properties", DataSourcesSubsystemProviders.XA_DATASOURCE_ATTRIBUTE);
                    addOperation.get("driver").set(dataSourceProp.getValue().get("driver"));
                    result.add(addOperation);
                }
            }
            resultHandler.handleResultFragment(Util.NO_LOCATION, result);
            resultHandler.handleResultComplete();
            return new BasicOperationResult();
        }

        public ModelNode getModelDescription(Locale locale) {
            return CommonDescriptions.getSubsystemDescribeOperation((Locale)locale);
        }
    }

    static final class NewDataSourceSubsystemParser
    implements XMLStreamConstants,
    XMLElementReader<List<ModelNode>>,
    XMLElementWriter<SubsystemMarshallingContext> {
        static final NewDataSourceSubsystemParser INSTANCE = new NewDataSourceSubsystemParser();

        NewDataSourceSubsystemParser() {
        }

        public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
            context.startSubsystemElement(Namespace.CURRENT.getUriString(), false);
            ModelNode node = context.getModelNode();
            writer.writeStartElement("datasources");
            if (node.hasDefined("data-source")) {
                for (Property property : node.get("data-source").asPropertyList()) {
                    boolean statementRequired;
                    boolean timeoutRequired;
                    boolean validationRequired;
                    boolean securityRequired;
                    ModelNode dataSourceNode = property.getValue();
                    boolean isXADataSource = this.hasAnyOf(dataSourceNode, "xa-resource-timeout", "xa-data-source-class", "xa-data-source-properties");
                    writer.writeStartElement(isXADataSource ? DataSources.Tag.XA_DATASOURCE.getLocalName() : DataSources.Tag.DATASOURCE.getLocalName());
                    if (dataSourceNode.hasDefined("connection-properties")) {
                        for (Property prop : dataSourceNode.get("connection-properties").asPropertyList()) {
                            writer.writeStartElement(DataSource.Tag.CONNECTIONPROPERTY.getLocalName());
                            writer.writeAttribute("name", prop.getName());
                            writer.writeCharacters(prop.getValue().asString());
                            writer.writeEndElement();
                        }
                    }
                    this.writeAttributeIfHas(writer, dataSourceNode, DataSource.Attribute.JNDINAME, "jndi-name");
                    this.writeAttributeIfHas(writer, dataSourceNode, DataSource.Attribute.POOL_NAME, "pool-name");
                    this.writeAttributeIfHas(writer, dataSourceNode, DataSource.Attribute.ENABLED, "enabled");
                    this.writeAttributeIfHas(writer, dataSourceNode, DataSource.Attribute.USEJAVACONTEXT, "use-java-context");
                    this.writeAttributeIfHas(writer, dataSourceNode, DataSource.Attribute.SPY, "spy");
                    if (!isXADataSource) {
                        this.writeElementIfHas(writer, dataSourceNode, DataSource.Tag.CONNECTIONURL, "connection-url");
                        this.writeElementIfHas(writer, dataSourceNode, DataSource.Tag.DRIVERCLASS, "driver-class");
                        if (dataSourceNode.hasDefined("connection-properties")) {
                            for (Property connectionProperty : dataSourceNode.get("connection-properties").asPropertyList()) {
                                this.writeConnectionProperty(writer, dataSourceNode, connectionProperty.getName(), connectionProperty.getValue().asString());
                            }
                        }
                    }
                    if (isXADataSource) {
                        this.writeElementIfHas(writer, dataSourceNode, XaDataSource.Tag.XADATASOURCECLASS, "xa-data-source-class");
                    }
                    this.writeElementIfHas(writer, dataSourceNode, DataSource.Tag.DRIVER, "driver");
                    if (!isXADataSource) {
                        // empty if block
                    }
                    if (isXADataSource) {
                        this.writeElementIfHas(writer, dataSourceNode, XaDataSource.Tag.URLDELIMITER, "url-delimiter");
                        this.writeElementIfHas(writer, dataSourceNode, XaDataSource.Tag.URLSELECTORSTRATEGYCLASSNAME, "url-selector-strategy-class-name");
                    }
                    this.writeElementIfHas(writer, dataSourceNode, DataSource.Tag.NEWCONNECTIONSQL, "new-connection-sql");
                    this.writeElementIfHas(writer, dataSourceNode, DataSource.Tag.TRANSACTIONISOLATION, "transaction-isolation");
                    if (!isXADataSource) {
                        this.writeElementIfHas(writer, dataSourceNode, DataSource.Tag.URLDELIMITER, "url-delimiter");
                        this.writeElementIfHas(writer, dataSourceNode, DataSource.Tag.URLSELECTORSTRATEGYCLASSNAME, "url-selector-strategy-class-name");
                    }
                    boolean poolRequired = this.hasAnyOf(dataSourceNode, "min-pool-size", "max-pool-size", "pool-prefill", "pool-use-strict-min");
                    if (isXADataSource) {
                        boolean bl = poolRequired = poolRequired || this.hasAnyOf(dataSourceNode, "same-rm-override", "interliving", "no-tx-separate-pool", "pad-xid", "wrap-xa-datasource");
                    }
                    if (poolRequired) {
                        writer.writeStartElement(isXADataSource ? XaDataSource.Tag.XA_POOL.getLocalName() : DataSource.Tag.POOL.getLocalName());
                        this.writeElementIfHas(writer, dataSourceNode, CommonPool.Tag.MIN_POOL_SIZE, "min-pool-size");
                        this.writeElementIfHas(writer, dataSourceNode, CommonPool.Tag.MAXPOOLSIZE, "max-pool-size");
                        this.writeElementIfHas(writer, dataSourceNode, CommonPool.Tag.PREFILL, "pool-prefill");
                        this.writeElementIfHas(writer, dataSourceNode, CommonPool.Tag.USE_STRICT_MIN, "pool-use-strict-min");
                        if (isXADataSource) {
                            this.writeElementIfHas(writer, dataSourceNode, CommonXaPool.Tag.ISSAMERMOVERRIDEVALUE, "same-rm-override");
                            this.writeEmptyElementIfHasAndTrue(writer, dataSourceNode, CommonXaPool.Tag.ISSAMERMOVERRIDEVALUE, "same-rm-override");
                            this.writeEmptyElementIfHasAndTrue(writer, dataSourceNode, CommonXaPool.Tag.NO_TX_SEPARATE_POOLS, "no-tx-separate-pool");
                            this.writeElementIfHas(writer, dataSourceNode, CommonXaPool.Tag.PAD_XID, "pad-xid");
                            this.writeElementIfHas(writer, dataSourceNode, CommonXaPool.Tag.WRAP_XA_RESOURCE, "wrap-xa-datasource");
                        }
                        writer.writeEndElement();
                    }
                    if (securityRequired = this.hasAnyOf(dataSourceNode, "user-name", "password")) {
                        writer.writeStartElement(DataSource.Tag.SECURITY.getLocalName());
                        this.writeElementIfHas(writer, dataSourceNode, DsSecurity.Tag.USERNAME, "user-name");
                        this.writeElementIfHas(writer, dataSourceNode, DsSecurity.Tag.PASSWORD, "password");
                        this.writeElementIfHas(writer, dataSourceNode, DsSecurity.Tag.SECURITY_DOMAIN, "security-domain");
                        writer.writeEndElement();
                    }
                    if (validationRequired = this.hasAnyOf(dataSourceNode, "valid-connection-checker-class-name", "check-valid-connection-sql", "validate-on-match", "background-validation", "background-validation-minutes", "use-fast-fail", "stale-connection-checker-class-name", "exception-sorter-class-name")) {
                        writer.writeStartElement(DataSource.Tag.VALIDATION.getLocalName());
                        this.writeElementIfHas(writer, dataSourceNode, Validation.Tag.VALIDCONNECTIONCHECKER, "valid-connection-checker-class-name");
                        this.writeElementIfHas(writer, dataSourceNode, Validation.Tag.CHECKVALIDCONNECTIONSQL, "check-valid-connection-sql");
                        this.writeElementIfHas(writer, dataSourceNode, Validation.Tag.VALIDATEONMATCH, "validate-on-match");
                        this.writeElementIfHas(writer, dataSourceNode, Validation.Tag.BACKGROUNDVALIDATION, "background-validation");
                        this.writeElementIfHas(writer, dataSourceNode, Validation.Tag.BACKGROUNDVALIDATIONMINUTES, "background-validation-minutes");
                        this.writeElementIfHas(writer, dataSourceNode, Validation.Tag.USEFASTFAIL, "use-fast-fail");
                        this.writeElementIfHas(writer, dataSourceNode, Validation.Tag.STALECONNECTIONCHECKER, "stale-connection-checker-class-name");
                        this.writeElementIfHas(writer, dataSourceNode, Validation.Tag.EXCEPTIONSORTER, "exception-sorter-class-name");
                        writer.writeEndElement();
                    }
                    if (timeoutRequired = this.hasAnyOf(dataSourceNode, "blocking-timeout-wait-millis", "idle-timeout-minutes", "set-tx-query-timeout", "query-timeout", "use-try-lock", "allocation-retry", "allocation-retry-wait-millis", "xa-resource-timeout")) {
                        this.writeElementIfHas(writer, dataSourceNode, TimeOut.Tag.BLOCKINGTIMEOUTMILLIS, "blocking-timeout-wait-millis");
                        this.writeElementIfHas(writer, dataSourceNode, TimeOut.Tag.IDLETIMEOUTMINUTES, "idle-timeout-minutes");
                        this.writeEmptyElementIfHasAndTrue(writer, dataSourceNode, TimeOut.Tag.SETTXQUERYTIMEOUT, "set-tx-query-timeout");
                        this.writeElementIfHas(writer, dataSourceNode, TimeOut.Tag.QUERYTIMEOUT, "query-timeout");
                        this.writeElementIfHas(writer, dataSourceNode, TimeOut.Tag.USETRYLOCK, "use-try-lock");
                        this.writeElementIfHas(writer, dataSourceNode, TimeOut.Tag.ALLOCATIONRETRY, "allocation-retry");
                        this.writeElementIfHas(writer, dataSourceNode, TimeOut.Tag.ALLOCATIONRETRYWAITMILLIS, "allocation-retry-wait-millis");
                        this.writeElementIfHas(writer, dataSourceNode, TimeOut.Tag.XARESOURCETIMEOUT, "xa-resource-timeout");
                    }
                    if (statementRequired = this.hasAnyOf(dataSourceNode, "track-statements", "prepared-statements-cacheSize", "share-prepared-statements")) {
                        writer.writeStartElement(DataSource.Tag.STATEMENT.getLocalName());
                        this.writeElementIfHas(writer, dataSourceNode, Statement.Tag.TRACKSTATEMENTS, "track-statements");
                        this.writeElementIfHas(writer, dataSourceNode, Statement.Tag.PREPAREDSTATEMENTCACHESIZE, "prepared-statements-cacheSize");
                        this.writeEmptyElementIfHasAndTrue(writer, dataSourceNode, Statement.Tag.SHAREPREPAREDSTATEMENTS, "share-prepared-statements");
                        writer.writeEndElement();
                    }
                    writer.writeEndElement();
                }
            }
            writer.writeEndElement();
            if (node.hasDefined("jdbc-driver")) {
                writer.writeStartElement(Element.DRIVERS.getLocalName());
                for (Property driverProperty : node.get("jdbc-driver").asPropertyList()) {
                    writer.writeStartElement(Element.DRIVER.getLocalName());
                    writer.writeAttribute(Attribute.MODULE.getLocalName(), driverProperty.getValue().require("driver").asString());
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }

        private void writeAttributeIfHas(XMLExtendedStreamWriter writer, ModelNode node, DataSource.Attribute attr, String identifier) throws XMLStreamException {
            if (this.has(node, identifier)) {
                writer.writeAttribute(attr.getLocalName(), node.get(identifier).asString());
            }
        }

        private void writeConnectionProperty(XMLExtendedStreamWriter writer, ModelNode node, String name, String value) throws XMLStreamException {
            String localName = DataSource.Tag.CONNECTIONPROPERTY.getLocalName();
            writer.writeStartElement(localName);
            writer.writeAttribute("name", name);
            writer.writeCharacters(value);
            writer.writeEndElement();
        }

        private void writeElementIfHas(XMLExtendedStreamWriter writer, ModelNode node, String localName, String identifier) throws XMLStreamException {
            if (this.has(node, identifier)) {
                writer.writeStartElement(localName);
                writer.writeCharacters(node.get(identifier).asString());
                writer.writeEndElement();
            }
        }

        private void writeElementIfHas(XMLExtendedStreamWriter writer, ModelNode node, XaDataSource.Tag element, String identifier) throws XMLStreamException {
            this.writeElementIfHas(writer, node, element.getLocalName(), identifier);
        }

        private void writeElementIfHas(XMLExtendedStreamWriter writer, ModelNode node, DataSource.Tag element, String identifier) throws XMLStreamException {
            this.writeElementIfHas(writer, node, element.getLocalName(), identifier);
        }

        private void writeElementIfHas(XMLExtendedStreamWriter writer, ModelNode node, DsSecurity.Tag element, String identifier) throws XMLStreamException {
            this.writeElementIfHas(writer, node, element.getLocalName(), identifier);
        }

        private void writeElementIfHas(XMLExtendedStreamWriter writer, ModelNode node, CommonPool.Tag element, String identifier) throws XMLStreamException {
            this.writeElementIfHas(writer, node, element.getLocalName(), identifier);
        }

        private void writeElementIfHas(XMLExtendedStreamWriter writer, ModelNode node, CommonXaPool.Tag element, String identifier) throws XMLStreamException {
            this.writeElementIfHas(writer, node, element.getLocalName(), identifier);
        }

        private void writeElementIfHas(XMLExtendedStreamWriter writer, ModelNode node, TimeOut.Tag element, String identifier) throws XMLStreamException {
            this.writeElementIfHas(writer, node, element.getLocalName(), identifier);
        }

        private void writeElementIfHas(XMLExtendedStreamWriter writer, ModelNode node, Validation.Tag element, String identifier) throws XMLStreamException {
            this.writeElementIfHas(writer, node, element.getLocalName(), identifier);
        }

        private void writeElementIfHas(XMLExtendedStreamWriter writer, ModelNode node, Statement.Tag element, String identifier) throws XMLStreamException {
            this.writeElementIfHas(writer, node, element.getLocalName(), identifier);
        }

        private void writeEmptyElementIfHasAndTrue(XMLExtendedStreamWriter writer, ModelNode node, String localName, String identifier) throws XMLStreamException {
            if (node.has(identifier) && node.get(identifier).asBoolean()) {
                writer.writeEmptyElement(localName);
            }
        }

        private void writeEmptyElementIfHasAndTrue(XMLExtendedStreamWriter writer, ModelNode node, Statement.Tag element, String identifier) throws XMLStreamException {
            this.writeEmptyElementIfHasAndTrue(writer, node, element.getLocalName(), identifier);
        }

        private void writeEmptyElementIfHasAndTrue(XMLExtendedStreamWriter writer, ModelNode node, CommonXaPool.Tag element, String identifier) throws XMLStreamException {
            this.writeEmptyElementIfHasAndTrue(writer, node, element.getLocalName(), identifier);
        }

        private void writeEmptyElementIfHasAndTrue(XMLExtendedStreamWriter writer, ModelNode node, TimeOut.Tag element, String identifier) throws XMLStreamException {
            this.writeEmptyElementIfHasAndTrue(writer, node, element.getLocalName(), identifier);
        }

        private boolean hasAnyOf(ModelNode node, String ... names) {
            for (String current : names) {
                if (!this.has(node, current)) continue;
                return true;
            }
            return false;
        }

        private boolean has(ModelNode node, String name) {
            return node.has(name) && node.get(name).isDefined();
        }

        public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
            ModelNode address = new ModelNode();
            address.add("subsystem", "datasources");
            address.protect();
            ModelNode subsystem = new ModelNode();
            subsystem.get("operation").set("add");
            subsystem.get("address").set(address);
            list.add(subsystem);
            DataSources dataSources = null;
            try {
                String localName = null;
                block1 : switch (Namespace.forUri(reader.getNamespaceURI())) {
                    case DATASOURCES_1_0: {
                        localName = reader.getLocalName();
                        Element element = Element.forName(reader.getLocalName());
                        log.tracef("%s -> %s", (Object)localName, (Object)element);
                        switch (element) {
                            case SUBSYSTEM: {
                                DsParser parser = new DsParser();
                                dataSources = parser.parse((XMLStreamReader)reader);
                                this.parseForDrivers(reader, address, list);
                                break block1;
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new XMLStreamException(e);
            }
            if (dataSources != null) {
                ModelNode operation;
                ModelNode dsAddress;
                for (DataSource dataSource : dataSources.getDataSource()) {
                    dsAddress = address.clone();
                    dsAddress.add("data-source", dataSource.getJndiName());
                    dsAddress.protect();
                    operation = new ModelNode();
                    operation.get("address").set(dsAddress);
                    operation.get("operation").set("add");
                    DataSourceModelNodeUtil.fillFrom(operation, dataSource);
                    list.add(operation);
                }
                for (XaDataSource xaDataSource : dataSources.getXaDataSource()) {
                    dsAddress = address.clone();
                    dsAddress.add("xa-data-source", xaDataSource.getJndiName());
                    dsAddress.protect();
                    operation = new ModelNode();
                    operation.get("address").set(dsAddress);
                    operation.get("operation").set("add");
                    DataSourceModelNodeUtil.fillFrom(operation, xaDataSource);
                    list.add(operation);
                }
            }
        }

        private void parseForDrivers(XMLExtendedStreamReader reader, ModelNode parentAddress, List<ModelNode> list) throws XMLStreamException {
            block6: while (reader.hasNext() && reader.nextTag() != 2) {
                switch (Namespace.forUri(reader.getNamespaceURI())) {
                    case DATASOURCES_1_0: {
                        Element element = Element.forName(reader.getLocalName());
                        switch (element) {
                            case DRIVERS: {
                                this.parseDrivers(reader, parentAddress, list);
                                continue block6;
                            }
                        }
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                }
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
        }

        private void parseDrivers(XMLExtendedStreamReader reader, ModelNode parentAddress, List<ModelNode> list) throws XMLStreamException {
            block9: while (reader.hasNext() && reader.nextTag() != 2) {
                switch (Namespace.forUri(reader.getNamespaceURI())) {
                    case DATASOURCES_1_0: {
                        Element element = Element.forName(reader.getLocalName());
                        switch (element) {
                            case DRIVER: {
                                String moduleName = null;
                                block10: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                                    Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                                    switch (attribute) {
                                        case MODULE: {
                                            moduleName = reader.getAttributeValue(i);
                                            continue block10;
                                        }
                                        default: {
                                            throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                                        }
                                    }
                                }
                                if (moduleName == null) {
                                    throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton("module"));
                                }
                                ModelNode address = parentAddress.clone();
                                address.add("jdbc-driver", moduleName);
                                address.protect();
                                ModelNode op = Util.getEmptyOperation((String)"add", (ModelNode)address);
                                op.get("driver").set(moduleName);
                                list.add(op);
                                ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                                continue block9;
                            }
                        }
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                }
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
        }
    }
}

