/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.resourceadapters;

import org.jboss.as.connector.ConnectorServices;
import org.jboss.as.connector.subsystems.resourceadapters.AbstractRaOperation;
import org.jboss.as.connector.subsystems.resourceadapters.ResourceAdaptersService;
import org.jboss.as.connector.subsystems.resourceadapters.ResourceAdaptersSubsystemProviders;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelAddOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.RuntimeTask;
import org.jboss.as.controller.RuntimeTaskContext;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;

public class RaAdd
extends AbstractRaOperation
implements ModelAddOperationHandler {
    static final RaAdd INSTANCE = new RaAdd();

    protected void populateModel(ModelNode operation, ModelNode model) {
        for (String attribute : ResourceAdaptersSubsystemProviders.RESOURCEADAPTER_ATTRIBUTE) {
            if (!operation.get(attribute).isDefined()) continue;
            model.get(attribute).set(operation.get(attribute));
        }
    }

    public OperationResult execute(OperationContext context, final ModelNode operation, final ResultHandler resultHandler) throws OperationFailedException {
        ModelNode subModel = context.getSubModel();
        this.populateModel(operation, subModel);
        ModelNode address = operation.require("address");
        String archive = PathAddress.pathAddress((ModelNode)address).getLastElement().getValue();
        operation.get("archive").set(archive);
        ModelNode compensating = Util.getResourceRemoveOperation((ModelNode)address);
        if (context.getRuntimeContext() != null) {
            context.getRuntimeContext().setRuntimeTask(new RuntimeTask(){

                public void execute(RuntimeTaskContext context) throws OperationFailedException {
                    ServiceTarget serviceTarget = context.getServiceTarget();
                    ResourceAdaptersService.ModifiableResourceAdapeters resourceAdapters = RaAdd.this.buildResourceAdaptersObject(operation);
                    ServiceController raService = context.getServiceRegistry().getService(ConnectorServices.RESOURCEADAPTERS_SERVICE);
                    if (raService == null) {
                        serviceTarget.addService(ConnectorServices.RESOURCEADAPTERS_SERVICE, (Service)new ResourceAdaptersService(resourceAdapters)).setInitialMode(ServiceController.Mode.ACTIVE).install();
                    } else {
                        ((ResourceAdaptersService.ModifiableResourceAdapeters)raService.getValue()).addAllResourceAdapters(resourceAdapters.getResourceAdapters());
                    }
                    resultHandler.handleResultComplete();
                }
            });
        } else {
            resultHandler.handleResultComplete();
        }
        return new BasicOperationResult(compensating);
    }
}

