/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.deployers.common;

import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.TransactionSupport;
import org.jboss.jca.common.api.metadata.common.CommonPool;
import org.jboss.jca.common.api.metadata.common.CommonTimeOut;
import org.jboss.jca.common.api.metadata.common.CommonValidation;
import org.jboss.jca.common.api.metadata.common.Credential;
import org.jboss.jca.common.api.metadata.common.Recovery;
import org.jboss.jca.common.api.metadata.ds.CommonDataSource;
import org.jboss.jca.common.api.metadata.ds.DataSource;
import org.jboss.jca.common.api.metadata.ds.DataSources;
import org.jboss.jca.common.api.metadata.ds.XaDataSource;
import org.jboss.jca.common.api.metadata.ra.ConfigProperty;
import org.jboss.jca.common.api.metadata.ra.ConnectionDefinition;
import org.jboss.jca.common.api.metadata.ra.Connector;
import org.jboss.jca.common.api.metadata.ra.ResourceAdapter1516;
import org.jboss.jca.common.api.metadata.ra.XsdString;
import org.jboss.jca.common.metadata.merge.Merger;
import org.jboss.jca.common.metadata.ra.common.ConfigPropertyImpl;
import org.jboss.jca.core.api.connectionmanager.pool.PoolConfiguration;
import org.jboss.jca.core.api.management.ManagementRepository;
import org.jboss.jca.core.connectionmanager.ConnectionManagerFactory;
import org.jboss.jca.core.connectionmanager.TxConnectionManager;
import org.jboss.jca.core.connectionmanager.pool.api.Pool;
import org.jboss.jca.core.connectionmanager.pool.api.PoolFactory;
import org.jboss.jca.core.connectionmanager.pool.api.PoolStrategy;
import org.jboss.jca.core.recovery.DefaultRecoveryPlugin;
import org.jboss.jca.core.spi.mdr.MetadataRepository;
import org.jboss.jca.core.spi.recovery.RecoveryPlugin;
import org.jboss.jca.core.spi.transaction.TransactionIntegration;
import org.jboss.jca.core.spi.transaction.recovery.XAResourceRecovery;
import org.jboss.jca.core.spi.transaction.recovery.XAResourceRecoveryRegistry;
import org.jboss.jca.deployers.common.CommonDeployment;
import org.jboss.jca.deployers.common.DeployException;
import org.jboss.logging.Logger;
import org.jboss.security.SubjectFactory;

public abstract class AbstractDsDeployer {
    protected Logger log;
    protected TransactionIntegration transactionIntegration;
    protected MetadataRepository mdr;
    protected XAResourceRecoveryRegistry xaResourceRecoveryRegistry;
    private ManagementRepository managementRepository = null;

    public AbstractDsDeployer(Logger log) {
        this.log = log;
        this.transactionIntegration = null;
        this.mdr = null;
    }

    public void setTransactionIntegration(TransactionIntegration value) {
        this.transactionIntegration = value;
    }

    public TransactionIntegration getTransactionIntegration() {
        return this.transactionIntegration;
    }

    public void setMetadataRepository(MetadataRepository value) {
        this.mdr = value;
    }

    public MetadataRepository getMetadataRepository() {
        return this.mdr;
    }

    public ManagementRepository getManagementRepository() {
        return this.managementRepository;
    }

    public void setManagementRepository(ManagementRepository managementRepository) {
        this.managementRepository = managementRepository;
    }

    protected CommonDeployment createObjectsAndInjectValue(URL url, String deploymentName, String uniqueJdbcLocalId, String uniqueJdbcXAId, DataSources dataSources, ClassLoader parentClassLoader) throws DeployException {
        try {
            org.jboss.jca.core.api.management.DataSource mgtDataSource;
            String jndiName;
            ArrayList<Object> cfs = new ArrayList<Object>(1);
            ArrayList<String> jndis = new ArrayList<String>(1);
            ArrayList recoveryModules = new ArrayList(1);
            ArrayList<org.jboss.jca.core.api.management.DataSource> mgts = new ArrayList<org.jboss.jca.core.api.management.DataSource>(1);
            if (uniqueJdbcLocalId != null) {
                List ds = dataSources.getDataSource();
                if (ds != null) {
                    ClassLoader jdbcLocalDeploymentCl = this.getDeploymentClassLoader(uniqueJdbcLocalId);
                    for (DataSource dataSource : ds) {
                        if (!dataSource.isEnabled().booleanValue()) continue;
                        try {
                            jndiName = dataSource.getJndiName();
                            if (dataSource.isUseJavaContext() != null && dataSource.isUseJavaContext().booleanValue() && !jndiName.startsWith("java:/")) {
                                jndiName = "java:/" + jndiName;
                            }
                            mgtDataSource = new org.jboss.jca.core.api.management.DataSource(false);
                            Object cf = this.deployDataSource(dataSource, jndiName, uniqueJdbcLocalId, mgtDataSource, jdbcLocalDeploymentCl);
                            this.bindConnectionFactory(deploymentName, jndiName, cf);
                            cfs.add(cf);
                            jndis.add(jndiName);
                            mgts.add(mgtDataSource);
                        }
                        catch (Throwable t) {
                            this.log.error((Object)("Error during the deployment of " + dataSource.getJndiName()), t);
                        }
                    }
                }
            } else if (dataSources.getDataSource() != null && dataSources.getDataSource().size() > 0) {
                this.log.error((Object)"Deployment of datasources disabled since jdbc-local.rar couldn't be found");
            }
            if (uniqueJdbcXAId != null) {
                List xads = dataSources.getXaDataSource();
                if (xads != null) {
                    ClassLoader jdbcXADeploymentCl = this.getDeploymentClassLoader(uniqueJdbcXAId);
                    for (XaDataSource xaDataSource : xads) {
                        if (!xaDataSource.isEnabled().booleanValue()) continue;
                        try {
                            jndiName = xaDataSource.getJndiName();
                            if (xaDataSource.isUseJavaContext() != null && xaDataSource.isUseJavaContext().booleanValue() && !jndiName.startsWith("java:/")) {
                                jndiName = "java:/" + jndiName;
                            }
                            mgtDataSource = new org.jboss.jca.core.api.management.DataSource(true);
                            Object recovery = null;
                            Object cf = this.deployXADataSource(xaDataSource, jndiName, uniqueJdbcXAId, (XAResourceRecovery)recovery, mgtDataSource, jdbcXADeploymentCl);
                            recoveryModules.add(recovery);
                            this.bindConnectionFactory(deploymentName, jndiName, cf);
                            cfs.add(cf);
                            jndis.add(jndiName);
                            mgts.add(mgtDataSource);
                        }
                        catch (Throwable t) {
                            this.log.error((Object)("Error during the deployment of " + xaDataSource.getJndiName()), t);
                        }
                    }
                }
            } else if (dataSources.getXaDataSource() != null && dataSources.getXaDataSource().size() > 0) {
                this.log.error((Object)"Deployment of XA datasources disabled since jdbc-xa.rar couldn't be found");
            }
            return new CommonDeployment(url, deploymentName, true, null, null, cfs.toArray(new Object[cfs.size()]), jndis.toArray(new String[jndis.size()]), null, null, recoveryModules.toArray(new XAResourceRecovery[recoveryModules.size()]), null, mgts.toArray(new org.jboss.jca.core.api.management.DataSource[mgts.size()]), parentClassLoader, this.log);
        }
        catch (Throwable t) {
            throw new DeployException("Deployment " + url.toExternalForm() + " failed", t);
        }
    }

    private Object deployDataSource(DataSource ds, String jndiName, String uniqueId, org.jboss.jca.core.api.management.DataSource mgtDs, ClassLoader cl) throws Throwable {
        this.log.debug((Object)("DataSource=" + ds));
        Merger merger = new Merger();
        Connector md = this.mdr.getResourceAdapter(uniqueId);
        md = merger.mergeConnectorAndDs((CommonDataSource)ds, md);
        ResourceAdapter1516 ra1516 = (ResourceAdapter1516)md.getResourceadapter();
        List cds = ra1516.getOutboundResourceadapter().getConnectionDefinitions();
        ConnectionDefinition cd = (ConnectionDefinition)cds.get(0);
        ManagedConnectionFactory mcf = (ManagedConnectionFactory)this.initAndInject(cd.getManagedConnectionFactoryClass().getValue(), cd.getConfigProperties(), cl);
        this.initAndInjectClassLoaderPlugin(mcf, (CommonDataSource)ds);
        PoolConfiguration pc = this.createPoolConfiguration(ds.getPool(), (CommonTimeOut)ds.getTimeOut(), (CommonValidation)ds.getValidation());
        PoolFactory pf = new PoolFactory();
        PoolStrategy strategy = PoolStrategy.ONE_POOL;
        String securityDomain = null;
        if (ds.getSecurity() != null) {
            if (ds.getSecurity().getReauthPlugin() != null) {
                strategy = PoolStrategy.REAUTH;
                securityDomain = ds.getSecurity().getSecurityDomain();
            } else if (ds.getSecurity().getSecurityDomain() != null) {
                strategy = PoolStrategy.POOL_BY_SUBJECT;
                securityDomain = ds.getSecurity().getSecurityDomain();
            }
        }
        Pool pool = pf.create(strategy, mcf, pc, false);
        Integer allocationRetry = null;
        Long allocationRetryWaitMillis = null;
        if (ds.getTimeOut() != null) {
            allocationRetry = ds.getTimeOut().getAllocationRetry();
            allocationRetryWaitMillis = ds.getTimeOut().getAllocationRetryWaitMillis();
        }
        mgtDs.setJndiName(jndiName);
        mgtDs.setPoolConfiguration(pc);
        mgtDs.setPool((org.jboss.jca.core.api.connectionmanager.pool.Pool)pool);
        this.log.debugf("Adding management datasource: %s", (Object)mgtDs);
        this.getManagementRepository().getDataSources().add(mgtDs);
        TransactionSupport.TransactionSupportLevel tsl = TransactionSupport.TransactionSupportLevel.LocalTransaction;
        ConnectionManagerFactory cmf = new ConnectionManagerFactory();
        TxConnectionManager cm = cmf.createTransactional(tsl, pool, this.getSubjectFactory(securityDomain), securityDomain, allocationRetry, allocationRetryWaitMillis, this.getTransactionIntegration(), null, null, null, null, null);
        cm.setJndiName(jndiName);
        String poolName = null;
        if (ds.getPoolName() != null) {
            poolName = ds.getPoolName();
        }
        if (poolName == null) {
            poolName = jndiName;
        }
        pool.setName(poolName);
        if (ds.isSpy()) {
            this.injectValue(mcf, "setSpy", Boolean.TRUE);
            this.injectValue(mcf, "setJndiName", jndiName);
        }
        if (strategy == PoolStrategy.REAUTH) {
            this.injectValue(mcf, "setReauthEnabled", Boolean.TRUE);
            this.injectValue(mcf, "setReauthPluginClassName", ds.getSecurity().getReauthPlugin().getClassName());
            Map mps = ds.getSecurity().getReauthPlugin().getConfigPropertiesMap();
            if (mps != null && mps.size() > 0) {
                StringBuilder reauthPluginProperties = new StringBuilder();
                Iterator entryIterator = mps.entrySet().iterator();
                while (entryIterator.hasNext()) {
                    Map.Entry entry = entryIterator.next();
                    reauthPluginProperties.append((String)entry.getKey());
                    reauthPluginProperties.append("|");
                    reauthPluginProperties.append((String)entry.getValue());
                    if (!entryIterator.hasNext()) continue;
                    reauthPluginProperties.append(",");
                }
                this.injectValue(mcf, "setReauthPluginProperties", reauthPluginProperties.toString());
            }
        }
        return mcf.createConnectionFactory((ConnectionManager)cm);
    }

    private Object deployXADataSource(XaDataSource ds, String jndiName, String uniqueId, XAResourceRecovery recovery, org.jboss.jca.core.api.management.DataSource mgtDs, ClassLoader cl) throws Throwable {
        this.log.debug((Object)("XaDataSource=" + ds));
        Merger merger = new Merger();
        Connector md = this.mdr.getResourceAdapter(uniqueId);
        md = merger.mergeConnectorAndDs((CommonDataSource)ds, md);
        ResourceAdapter1516 ra1516 = (ResourceAdapter1516)md.getResourceadapter();
        List cds = ra1516.getOutboundResourceadapter().getConnectionDefinitions();
        ConnectionDefinition cd = (ConnectionDefinition)cds.get(0);
        ManagedConnectionFactory mcf = (ManagedConnectionFactory)this.initAndInject(cd.getManagedConnectionFactoryClass().getValue(), cd.getConfigProperties(), cl);
        this.initAndInjectClassLoaderPlugin(mcf, (CommonDataSource)ds);
        PoolConfiguration pc = this.createPoolConfiguration((CommonPool)ds.getXaPool(), (CommonTimeOut)ds.getTimeOut(), (CommonValidation)ds.getValidation());
        Boolean noTxSeparatePool = Boolean.FALSE;
        if (ds.getXaPool() != null && ds.getXaPool().isNoTxSeparatePool() != null) {
            noTxSeparatePool = ds.getXaPool().isNoTxSeparatePool();
        }
        PoolFactory pf = new PoolFactory();
        PoolStrategy strategy = PoolStrategy.ONE_POOL;
        String securityDomain = null;
        if (ds.getSecurity() != null) {
            if (ds.getSecurity().getReauthPlugin() != null) {
                strategy = PoolStrategy.REAUTH;
                securityDomain = ds.getSecurity().getSecurityDomain();
            } else if (ds.getSecurity().getSecurityDomain() != null) {
                strategy = PoolStrategy.POOL_BY_SUBJECT;
                securityDomain = ds.getSecurity().getSecurityDomain();
            }
        }
        Pool pool = pf.create(strategy, mcf, pc, noTxSeparatePool.booleanValue());
        Integer allocationRetry = null;
        Long allocationRetryWaitMillis = null;
        Boolean interleaving = null;
        Integer xaResourceTimeout = null;
        Boolean isSameRMOverride = null;
        Boolean wrapXAResource = null;
        Boolean padXid = null;
        if (ds.getTimeOut() != null) {
            allocationRetry = ds.getTimeOut().getAllocationRetry();
            allocationRetryWaitMillis = ds.getTimeOut().getAllocationRetryWaitMillis();
            xaResourceTimeout = ds.getTimeOut().getXaResourceTimeout();
        }
        if (ds.getXaPool() != null) {
            interleaving = ds.getXaPool().isInterleaving();
            isSameRMOverride = ds.getXaPool().isSameRmOverride();
            wrapXAResource = ds.getXaPool().isWrapXaDataSource();
            padXid = ds.getXaPool().isPadXid();
        }
        mgtDs.setJndiName(jndiName);
        mgtDs.setPoolConfiguration(pc);
        mgtDs.setPool((org.jboss.jca.core.api.connectionmanager.pool.Pool)pool);
        this.log.debugf("Adding management datasource: %s", (Object)mgtDs);
        this.getManagementRepository().getDataSources().add(mgtDs);
        TransactionSupport.TransactionSupportLevel tsl = TransactionSupport.TransactionSupportLevel.XATransaction;
        ConnectionManagerFactory cmf = new ConnectionManagerFactory();
        TxConnectionManager cm = cmf.createTransactional(tsl, pool, this.getSubjectFactory(securityDomain), securityDomain, allocationRetry, allocationRetryWaitMillis, this.getTransactionIntegration(), interleaving, xaResourceTimeout, isSameRMOverride, wrapXAResource, padXid);
        cm.setJndiName(jndiName);
        String poolName = null;
        if (ds.getPoolName() != null) {
            poolName = ds.getPoolName();
        }
        if (poolName == null) {
            poolName = jndiName;
        }
        pool.setName(poolName);
        if (ds.isSpy()) {
            this.injectValue(mcf, "setSpy", Boolean.TRUE);
            this.injectValue(mcf, "setJndiName", jndiName);
        }
        if (strategy == PoolStrategy.REAUTH) {
            this.injectValue(mcf, "setReauthEnabled", Boolean.TRUE);
            this.injectValue(mcf, "setReauthPluginClassName", ds.getSecurity().getReauthPlugin().getClassName());
            Map mps = ds.getSecurity().getReauthPlugin().getConfigPropertiesMap();
            if (mps != null && mps.size() > 0) {
                StringBuilder reauthPluginProperties = new StringBuilder();
                Iterator entryIterator = mps.entrySet().iterator();
                while (entryIterator.hasNext()) {
                    Map.Entry entry = entryIterator.next();
                    reauthPluginProperties.append((String)entry.getKey());
                    reauthPluginProperties.append("|");
                    reauthPluginProperties.append((String)entry.getValue());
                    if (!entryIterator.hasNext()) continue;
                    reauthPluginProperties.append(",");
                }
                this.injectValue(mcf, "setReauthPluginProperties", reauthPluginProperties.toString());
            }
        }
        Recovery recoveryMD = ds.getRecovery();
        String defaultSecurityDomain = null;
        String defaultUserName = null;
        String defaultPassword = null;
        if (ds.getSecurity() != null) {
            defaultSecurityDomain = ds.getSecurity().getSecurityDomain();
            defaultUserName = ds.getSecurity().getUserName();
            defaultPassword = ds.getSecurity().getPassword();
        }
        String recoverSecurityDomain = defaultSecurityDomain;
        String recoverUser = defaultUserName;
        String recoverPassword = defaultPassword;
        XAResourceRecovery recoveryImpl = null;
        if (recoveryMD == null || !recoveryMD.getNoRecovery().booleanValue()) {
            Credential credential;
            Credential credential2 = credential = recoveryMD != null ? recoveryMD.getCredential() : null;
            if (credential != null) {
                recoverSecurityDomain = credential.getSecurityDomain();
                recoverUser = credential.getUserName();
                recoverPassword = credential.getPassword();
            }
            if (this.log.isDebugEnabled()) {
                if (recoverUser != null) {
                    this.log.debug((Object)("RecoverUser=" + recoverUser));
                } else if (recoverSecurityDomain != null) {
                    this.log.debug((Object)("RecoverSecurityDomain=" + recoverSecurityDomain));
                }
            }
            DefaultRecoveryPlugin plugin = null;
            if (recoveryMD != null && recoveryMD.getRecoverPlugin() != null) {
                ArrayList<ConfigPropertyImpl> configProperties = null;
                if (recoveryMD.getRecoverPlugin().getConfigPropertiesMap() != null) {
                    configProperties = new ArrayList<ConfigPropertyImpl>(recoveryMD.getRecoverPlugin().getConfigPropertiesMap().size());
                    for (Map.Entry property : recoveryMD.getRecoverPlugin().getConfigPropertiesMap().entrySet()) {
                        ConfigPropertyImpl c = new ConfigPropertyImpl(null, new XsdString((String)property.getKey(), null), new XsdString("String", null), new XsdString((String)property.getValue(), null), null);
                        configProperties.add(c);
                    }
                    plugin = (RecoveryPlugin)this.initAndInject(recoveryMD.getRecoverPlugin().getClassName(), configProperties, cl);
                }
            } else {
                plugin = new DefaultRecoveryPlugin();
            }
            recoveryImpl = this.getTransactionIntegration().createXAResourceRecovery(mcf, padXid, isSameRMOverride, wrapXAResource, recoverUser, recoverPassword, recoverSecurityDomain, this.getSubjectFactory(recoverSecurityDomain), (RecoveryPlugin)plugin);
        }
        if (this.getTransactionIntegration().getRecoveryRegistry() != null && recoveryImpl != null) {
            recoveryImpl.setJndiName(cm.getJndiName());
            this.getTransactionIntegration().getRecoveryRegistry().addXAResourceRecovery(recoveryImpl);
            recovery = recoveryImpl;
        }
        return mcf.createConnectionFactory((ConnectionManager)cm);
    }

    private PoolConfiguration createPoolConfiguration(CommonPool pp, CommonTimeOut tp, CommonValidation vp) {
        PoolConfiguration pc = new PoolConfiguration();
        if (pp != null) {
            if (pp.getMinPoolSize() != null) {
                pc.setMinSize(pp.getMinPoolSize().intValue());
            }
            if (pp.getMaxPoolSize() != null) {
                pc.setMaxSize(pp.getMaxPoolSize().intValue());
            }
            if (pp.isPrefill() != null) {
                pc.setPrefill(pp.isPrefill().booleanValue());
            }
            if (pp.isUseStrictMin() != null) {
                pc.setStrictMin(pp.isUseStrictMin().booleanValue());
            }
        }
        if (tp != null) {
            if (tp.getBlockingTimeoutMillis() != null) {
                pc.setBlockingTimeout(tp.getBlockingTimeoutMillis().longValue());
            }
            if (tp.getIdleTimeoutMinutes() != null) {
                pc.setIdleTimeout(tp.getIdleTimeoutMinutes().longValue());
            }
        }
        if (vp != null) {
            if (vp.isBackgroundValidation() != null) {
                pc.setBackgroundValidation(vp.isBackgroundValidation().booleanValue());
            }
            if (vp.getBackgroundValidationMinutes() != null) {
                pc.setBackgroundValidationMinutes(vp.getBackgroundValidationMinutes().intValue());
            }
            if (vp.isUseFastFail() != null) {
                pc.setUseFastFail(vp.isUseFastFail().booleanValue());
            }
        }
        return pc;
    }

    private void injectValue(Object o, String methodName, Object value) throws Exception {
        Method[] methods = o.getClass().getMethods();
        if (methods != null) {
            boolean found = false;
            for (int i = 0; !found && i < methods.length; ++i) {
                Method m = methods[i];
                if (!m.getName().equals(methodName) || m.getParameterTypes().length != 1) continue;
                m.invoke(o, value);
                found = true;
            }
        }
    }

    protected abstract ClassLoader getDeploymentClassLoader(String var1);

    protected abstract String[] bindConnectionFactory(String var1, String var2, Object var3) throws Throwable;

    protected abstract Object initAndInject(String var1, List<? extends ConfigProperty> var2, ClassLoader var3) throws DeployException;

    protected void initAndInjectClassLoaderPlugin(ManagedConnectionFactory mcf, CommonDataSource dsMetadata) throws DeployException {
    }

    protected abstract SubjectFactory getSubjectFactory(String var1) throws DeployException;

    public final XAResourceRecoveryRegistry getXAResourceRecoveryRegistry() {
        return this.xaResourceRecoveryRegistry;
    }

    public final void setXAResourceRecoveryRegistry(XAResourceRecoveryRegistry xAResourceRecoveryRegistry) {
        this.xaResourceRecoveryRegistry = xAResourceRecoveryRegistry;
    }
}

