/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.scanner;

import java.io.File;
import java.security.AccessController;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.jboss.as.server.ServerController;
import org.jboss.as.server.Services;
import org.jboss.as.server.deployment.api.ServerDeploymentRepository;
import org.jboss.as.server.deployment.scanner.FileSystemDeploymentService;
import org.jboss.as.server.deployment.scanner.api.DeploymentScanner;
import org.jboss.as.server.services.path.AbsolutePathService;
import org.jboss.as.server.services.path.RelativePathService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.threads.JBossThreadFactory;

public class DeploymentScannerService
implements Service<DeploymentScanner> {
    private static final int DEFAULT_INTERVAL = 5000;
    private long interval;
    private TimeUnit unit = TimeUnit.MILLISECONDS;
    private boolean enabled;
    private boolean autoDeployZipped;
    private boolean autoDeployExploded;
    private Long deploymentTimeout;
    private DeploymentScanner scanner;
    private final InjectedValue<String> pathValue = new InjectedValue();
    private final InjectedValue<ServerController> serverControllerValue = new InjectedValue();
    private final InjectedValue<ServerDeploymentRepository> deploymentRepositoryValue = new InjectedValue();
    private final InjectedValue<ScheduledExecutorService> scheduledExecutorValue = new InjectedValue();

    public static ServiceName getServiceName(String repositoryName) {
        return DeploymentScanner.BASE_SERVICE_NAME.append(new String[]{repositoryName});
    }

    public static void addService(ServiceTarget serviceTarget, String name, String relativeTo, String path, Integer scanInterval, TimeUnit unit, Boolean autoDeployZip, Boolean autoDeployExploded, Boolean scanEnabled, Long deploymentTimeout) {
        DeploymentScannerService service = new DeploymentScannerService(scanInterval, unit, autoDeployZip, autoDeployExploded, scanEnabled, deploymentTimeout);
        ServiceName serviceName = DeploymentScannerService.getServiceName(name);
        ServiceName pathService = serviceName.append(new String[]{"path"});
        if (relativeTo != null) {
            RelativePathService.addService((ServiceName)pathService, (String)path, (String)relativeTo, (ServiceTarget)serviceTarget);
        } else {
            AbsolutePathService.addService((ServiceName)pathService, (String)path, (ServiceTarget)serviceTarget);
        }
        JBossThreadFactory threadFactory = new JBossThreadFactory(new ThreadGroup("DeploymentScanner-threads"), Boolean.FALSE, null, "%G - %t", null, null, AccessController.getContext());
        ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(2, (ThreadFactory)threadFactory);
        serviceTarget.addService(serviceName, (Service)service).addDependency(pathService, String.class, service.pathValue).addDependency(Services.JBOSS_SERVER_CONTROLLER, ServerController.class, service.serverControllerValue).addDependency(ServerDeploymentRepository.SERVICE_NAME, ServerDeploymentRepository.class, service.deploymentRepositoryValue).addInjection(service.scheduledExecutorValue, (Object)scheduledExecutorService).setInitialMode(ServiceController.Mode.ACTIVE).install();
    }

    DeploymentScannerService(Integer interval, TimeUnit unit, Boolean autoDeployZipped, Boolean autoDeployExploded, Boolean enabled, Long deploymentTimeout) {
        this.interval = interval == null ? 5000L : interval.longValue();
        this.unit = unit;
        this.autoDeployZipped = autoDeployZipped == null ? true : autoDeployZipped;
        this.autoDeployExploded = autoDeployExploded == null ? false : autoDeployExploded;
        this.enabled = enabled == null ? true : enabled;
        this.deploymentTimeout = deploymentTimeout;
    }

    public synchronized void start(StartContext context) throws StartException {
        try {
            String pathName = (String)this.pathValue.getValue();
            FileSystemDeploymentService scanner = new FileSystemDeploymentService(new File(pathName), (ServerController)this.serverControllerValue.getValue(), (ScheduledExecutorService)this.scheduledExecutorValue.getValue(), (ServerDeploymentRepository)this.deploymentRepositoryValue.getValue());
            scanner.setScanInterval(this.unit.toMillis(this.interval));
            scanner.setAutoDeployExplodedContent(this.autoDeployExploded);
            scanner.setAutoDeployZippedContent(this.autoDeployZipped);
            if (this.deploymentTimeout != null) {
                scanner.setDeploymentTimeout(this.deploymentTimeout);
            }
            if (this.enabled) {
                scanner.startScanner();
            }
            this.scanner = scanner;
        }
        catch (Exception e) {
            throw new StartException((Throwable)e);
        }
    }

    public synchronized void stop(StopContext context) {
        DeploymentScanner scanner = this.scanner;
        this.scanner = null;
        scanner.stopScanner();
    }

    public synchronized DeploymentScanner getValue() throws IllegalStateException {
        DeploymentScanner scanner = this.scanner;
        if (scanner == null) {
            throw new IllegalStateException();
        }
        return scanner;
    }
}

