/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli;

import java.util.Collections;
import java.util.List;
import jline.Completor;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandHandler;
import org.jboss.as.cli.CommandLineCompleter;
import org.jboss.as.cli.CommandRegistry;
import org.jboss.as.cli.operation.OperationRequestCompleter;

public class CommandCompleter
implements Completor,
CommandLineCompleter {
    private final CommandContext ctx;
    private final CommandRegistry cmdRegistry;

    public CommandCompleter(CommandRegistry cmdRegistry, CommandContext ctx) {
        if (cmdRegistry == null) {
            throw new IllegalArgumentException("Command registry can't be null.");
        }
        this.cmdRegistry = cmdRegistry;
        this.ctx = ctx;
    }

    public int complete(String buffer, int cursor, List candidates) {
        return this.complete(this.ctx, buffer, cursor, candidates);
    }

    @Override
    public int complete(CommandContext ctx, String buffer, int cursor, List<String> candidates) {
        CommandLineCompleter argsCompleter;
        CommandHandler handler;
        int cmdLastIndex;
        int cmdFirstIndex;
        for (cmdFirstIndex = 0; cmdFirstIndex < buffer.length() && Character.isWhitespace(buffer.charAt(cmdFirstIndex)); ++cmdFirstIndex) {
        }
        if (cmdFirstIndex == buffer.length()) {
            for (String cmd : this.cmdRegistry.getTabCompletionCommands()) {
                CommandHandler handler2 = this.cmdRegistry.getCommandHandler(cmd);
                if (!handler2.isAvailable(ctx)) continue;
                candidates.add(cmd);
            }
            return cmdFirstIndex;
        }
        char firstChar = buffer.charAt(cmdFirstIndex);
        if (firstChar == '.' || firstChar == ':' || firstChar == '/') {
            return OperationRequestCompleter.INSTANCE.complete(ctx, buffer, cursor, candidates);
        }
        for (cmdLastIndex = cmdFirstIndex + 1; cmdLastIndex < buffer.length() && !Character.isWhitespace(buffer.charAt(cmdLastIndex)); ++cmdLastIndex) {
        }
        String cmd = buffer.substring(cmdFirstIndex, cmdLastIndex);
        if (cmdLastIndex < buffer.length() && (handler = this.cmdRegistry.getCommandHandler(cmd)) != null && (argsCompleter = handler.getArgumentCompleter()) != null) {
            int nextCharIndex;
            for (nextCharIndex = cmdLastIndex + 1; nextCharIndex < buffer.length() && Character.isWhitespace(buffer.charAt(nextCharIndex)); ++nextCharIndex) {
            }
            String cmdBuffer = buffer.substring(nextCharIndex);
            int result = argsCompleter.complete(ctx, cmdBuffer, cursor, candidates);
            if (result >= 0) {
                return nextCharIndex + result;
            }
            return result;
        }
        if (cmdLastIndex < buffer.length()) {
            cmd = buffer.substring(cmdFirstIndex);
        }
        for (String command : this.cmdRegistry.getTabCompletionCommands()) {
            CommandHandler handler3;
            if (!command.startsWith(cmd) || !(handler3 = this.cmdRegistry.getCommandHandler(command)).isAvailable(ctx)) continue;
            candidates.add(command);
        }
        Collections.sort(candidates);
        return buffer.length() - cmd.length();
    }
}

