/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.protocol.jmx;

import java.io.Serializable;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;

public class RequestedCommand
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final AtomicLong idCounter = new AtomicLong(0L);
    private final long id = idCounter.incrementAndGet();
    private final String testClassName;
    private final Command command;
    private final String[] arguments;

    public RequestedCommand(String testClassName, Command command, String ... arguments) {
        this.testClassName = testClassName;
        this.command = command;
        this.arguments = arguments;
    }

    public long getId() {
        return this.id;
    }

    public Command getCommand() {
        return this.command;
    }

    public String[] getArguments() {
        return this.arguments;
    }

    public String getTestClassName() {
        return this.testClassName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RequestedCommand)) {
            return false;
        }
        RequestedCommand rq = (RequestedCommand)o;
        return this.id == rq.id;
    }

    public int hashCode() {
        return new Long(this.id).hashCode();
    }

    public String toString() {
        return "(" + this.id + ") " + this.testClassName + ": " + (Object)((Object)this.command) + " " + Arrays.toString(this.arguments);
    }

    public static enum Command {
        RESOURCE;

    }
}

