/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld;

import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.modules.Module;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.resources.spi.ResourceLoadingException;

public class WeldModuleResourceLoader
implements ResourceLoader {
    private final Module module;
    private final Map<String, Class<?>> additionalClasses;

    public WeldModuleResourceLoader(Module module) {
        this.module = module;
        this.additionalClasses = new ConcurrentHashMap();
    }

    public Class<?> classForName(String name) {
        try {
            if (this.additionalClasses.containsKey(name)) {
                return this.additionalClasses.get(name);
            }
            return this.module.getClassLoader().loadClass(name);
        }
        catch (NoClassDefFoundError e) {
            throw new ResourceLoadingException((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new ResourceLoadingException((Throwable)e);
        }
        catch (LinkageError e) {
            throw new ResourceLoadingException((Throwable)e);
        }
    }

    public void addAdditionalClass(Class<?> clazz) {
        this.additionalClasses.put(clazz.getName(), clazz);
    }

    public URL getResource(String name) {
        try {
            return this.module.getClassLoader().getResource(name);
        }
        catch (Exception e) {
            throw new ResourceLoadingException((Throwable)e);
        }
    }

    public Collection<URL> getResources(String name) {
        try {
            HashSet<URL> resources = new HashSet<URL>();
            Enumeration urls = this.module.getClassLoader().getResources(name);
            while (urls.hasMoreElements()) {
                resources.add((URL)urls.nextElement());
            }
            return resources;
        }
        catch (Exception e) {
            throw new ResourceLoadingException((Throwable)e);
        }
    }

    public void cleanup() {
    }
}

