/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.deployment.processors;

import javax.enterprise.inject.spi.BeanManager;
import org.jboss.as.ee.component.AbstractComponentDescription;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentNamingMode;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.naming.ContextNames;
import org.jboss.as.naming.NamingStore;
import org.jboss.as.naming.ValueManagedObject;
import org.jboss.as.naming.service.BinderService;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.weld.WeldContainer;
import org.jboss.as.weld.WeldDeploymentMarker;
import org.jboss.as.weld.arquillian.WeldContextSetup;
import org.jboss.as.weld.deployment.BeanDeploymentArchiveImpl;
import org.jboss.as.weld.deployment.WeldAttachments;
import org.jboss.as.weld.services.BeanManagerService;
import org.jboss.as.weld.services.WeldService;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;

public class WeldBeanManagerServiceProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        DeploymentUnit topLevelDeployment = deploymentUnit.getParent() == null ? deploymentUnit : deploymentUnit.getParent();
        ServiceTarget serviceTarget = phaseContext.getServiceTarget();
        EEModuleDescription moduleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        if (!WeldDeploymentMarker.isPartOfWeldDeployment(topLevelDeployment)) {
            return;
        }
        if (!deploymentUnit.getName().endsWith(".war") && !deploymentUnit.getName().endsWith(".jar")) {
            return;
        }
        if (moduleDescription == null) {
            return;
        }
        BeanDeploymentArchiveImpl rootBda = (BeanDeploymentArchiveImpl)deploymentUnit.getAttachment(WeldAttachments.DEPLOYMENT_ROOT_BEAN_DEPLOYMENT_ARCHIVE);
        if (rootBda == null) {
            rootBda = (BeanDeploymentArchiveImpl)topLevelDeployment.getAttachment(WeldAttachments.DEPLOYMENT_ROOT_BEAN_DEPLOYMENT_ARCHIVE);
        }
        if (rootBda == null) {
            throw new RuntimeException("Could not find BeanManager for deployment " + deploymentUnit.getName());
        }
        ServiceName weldServiceName = topLevelDeployment.getServiceName().append(WeldService.SERVICE_NAME);
        ServiceName beanManagerServiceName = deploymentUnit.getServiceName().append(BeanManagerService.NAME);
        BeanManagerService beanManagerService = new BeanManagerService(rootBda.getId());
        serviceTarget.addService(beanManagerServiceName, (Service)beanManagerService).addDependency(weldServiceName, WeldContainer.class, beanManagerService.getWeldContainer()).install();
        ServiceName moduleContextServiceName = ContextNames.contextServiceNameOfModule((String)moduleDescription.getAppName(), (String)moduleDescription.getModuleName());
        this.bindBeanManager(serviceTarget, beanManagerServiceName, moduleContextServiceName);
        for (AbstractComponentDescription component : moduleDescription.getComponentDescriptions()) {
            if (component.getNamingMode() != ComponentNamingMode.CREATE) continue;
            ServiceName compContextServiceName = ContextNames.contextServiceNameOfComponent((String)moduleDescription.getAppName(), (String)moduleDescription.getModuleName(), (String)component.getComponentName());
            this.bindBeanManager(serviceTarget, beanManagerServiceName, compContextServiceName);
        }
        deploymentUnit.addToAttachmentList(org.jboss.as.server.deployment.Attachments.SETUP_ACTIONS, (Object)new WeldContextSetup());
    }

    private void bindBeanManager(ServiceTarget serviceTarget, ServiceName beanManagerServiceName, ServiceName contextServiceName) {
        ServiceName beanManagerBindingServiceName = contextServiceName.append(new String[]{"BeanManager"});
        InjectedValue injectedBeanManager = new InjectedValue();
        BinderService beanManagerBindingService = new BinderService("BeanManager");
        serviceTarget.addService(beanManagerBindingServiceName, (Service)beanManagerBindingService).addInjection(beanManagerBindingService.getManagedObjectInjector(), (Object)new ValueManagedObject((Value)injectedBeanManager)).addDependency(contextServiceName, NamingStore.class, beanManagerBindingService.getNamingStoreInjector()).addDependency(beanManagerServiceName, BeanManager.class, (Injector)injectedBeanManager).install();
    }

    public void undeploy(DeploymentUnit deploymentUnit) {
    }
}

