/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.deployers;

import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.web.deployment.WarMetaData;
import org.jboss.as.webservices.util.ASHelper;
import org.jboss.as.webservices.util.WSAttachmentKeys;
import org.jboss.jandex.Index;
import org.jboss.wsf.spi.deployment.Deployment;

public final class WSTypeDeploymentProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit unit = phaseContext.getDeploymentUnit();
        if (this.isJaxwsJseDeployment(unit)) {
            unit.putAttachment(WSAttachmentKeys.DEPLOYMENT_TYPE_KEY, (Object)Deployment.DeploymentType.JAXWS_JSE);
        } else if (this.isJaxwsEjbDeployment(unit)) {
            unit.putAttachment(WSAttachmentKeys.DEPLOYMENT_TYPE_KEY, (Object)Deployment.DeploymentType.JAXWS_EJB3);
        } else if (this.isJaxrpcJseDeployment(unit)) {
            unit.putAttachment(WSAttachmentKeys.DEPLOYMENT_TYPE_KEY, (Object)Deployment.DeploymentType.JAXRPC_JSE);
        } else if (this.isJaxrpcEjbDeployment(unit)) {
            unit.putAttachment(WSAttachmentKeys.DEPLOYMENT_TYPE_KEY, (Object)Deployment.DeploymentType.JAXRPC_EJB21);
        } else if (this.isJaxwsJmsDeployment(unit)) {
            unit.putAttachment(WSAttachmentKeys.DEPLOYMENT_TYPE_KEY, (Object)Deployment.DeploymentType.JAXWS_JMS);
        }
    }

    public void undeploy(DeploymentUnit context) {
    }

    private boolean isJaxrpcEjbDeployment(DeploymentUnit unit) {
        return false;
    }

    private boolean isJaxrpcJseDeployment(DeploymentUnit unit) {
        boolean hasJBossWebMD;
        boolean hasWebservicesMD = ASHelper.hasAttachment(unit, WSAttachmentKeys.WEBSERVICES_METADATA_KEY);
        boolean bl = hasJBossWebMD = ASHelper.getJBossWebMetaData(unit) != null;
        if (hasWebservicesMD && hasJBossWebMD) {
            return ASHelper.getJaxrpcServlets(unit).size() > 0;
        }
        return false;
    }

    private boolean isJaxwsEjbDeployment(DeploymentUnit unit) {
        boolean hasWSDeployment = ASHelper.hasAttachment(unit, WSAttachmentKeys.WEBSERVICE_DEPLOYMENT_KEY);
        if (hasWSDeployment) {
            return ASHelper.getJaxwsEjbs(unit).size() > 0;
        }
        return false;
    }

    private boolean isJaxwsJseDeployment(DeploymentUnit unit) {
        if (DeploymentTypeMarker.isType((DeploymentType)DeploymentType.WAR, (DeploymentUnit)unit)) {
            Index index = ASHelper.getRootAnnotationIndex(unit);
            WarMetaData warMetaData = (WarMetaData)ASHelper.getOptionalAttachment(unit, WarMetaData.ATTACHMENT_KEY);
            if (warMetaData != null && warMetaData.getWebMetaData() != null) {
                return ASHelper.selectWebServiceServlets(index, warMetaData.getWebMetaData().getServlets(), true).size() > 0;
            }
        }
        return false;
    }

    private boolean isJaxwsJmsDeployment(DeploymentUnit unit) {
        return ASHelper.hasAttachment(unit, WSAttachmentKeys.JMS_ENDPOINT_METADATA_KEY);
    }
}

