/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.deployers;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.naming.Referenceable;
import javax.xml.ws.WebServiceRef;
import javax.xml.ws.WebServiceRefs;
import org.jboss.as.ee.component.AbstractComponentConfigProcessor;
import org.jboss.as.ee.component.AbstractComponentDescription;
import org.jboss.as.ee.component.BindingDescription;
import org.jboss.as.ee.component.BindingSourceDescription;
import org.jboss.as.ee.component.EEApplicationDescription;
import org.jboss.as.ee.component.InjectionTargetDescription;
import org.jboss.as.ee.component.InterceptorDescription;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.naming.ValueManagedObject;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.webservices.deployers.annotation.AbstractWebServiceRefAnnotation;
import org.jboss.as.webservices.deployers.annotation.WebServiceRefFieldAnnotation;
import org.jboss.as.webservices.deployers.annotation.WebServiceRefMethodAnnotation;
import org.jboss.as.webservices.util.VirtualFileAdaptor;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.modules.Module;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.value.MethodValue;
import org.jboss.msc.value.Value;
import org.jboss.msc.value.Values;
import org.jboss.util.NotImplementedException;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.classloading.ClassLoaderProvider;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedServiceRefMetaData;
import org.jboss.wsf.spi.serviceref.ServiceRefHandler;
import org.jboss.wsf.spi.serviceref.ServiceRefHandlerFactory;
import org.jboss.wsf.stack.cxf.client.serviceref.CXFServiceObjectFactoryJAXWS;

public class WebServiceRefAnnotationParsingProcessor
extends AbstractComponentConfigProcessor {
    private static final DotName WEB_SERVICE_REF_ANNOTATION_NAME = DotName.createSimple((String)WebServiceRef.class.getName());
    private static final DotName WEB_SERVICE_REFS_ANNOTATION_NAME = DotName.createSimple((String)WebServiceRefs.class.getName());

    protected void processComponentConfig(DeploymentUnit deploymentUnit, DeploymentPhaseContext phaseContext, CompositeIndex index, AbstractComponentDescription description) throws DeploymentUnitProcessingException {
        ClassInfo classInfo = index.getClassByName(DotName.createSimple((String)description.getComponentClassName()));
        if (classInfo == null) {
            return;
        }
        description.addAnnotationBindings(this.getWebServiceConfigurations(deploymentUnit, classInfo, description));
        Collection interceptorConfigurations = description.getAllInterceptors().values();
        for (InterceptorDescription interceptorConfiguration : interceptorConfigurations) {
            ClassInfo interceptorClassInfo = index.getClassByName(DotName.createSimple((String)interceptorConfiguration.getInterceptorClassName()));
            if (interceptorClassInfo == null) continue;
            description.addAnnotationBindings(this.getWebServiceConfigurations(deploymentUnit, interceptorClassInfo, description));
        }
    }

    private List<BindingDescription> getWebServiceConfigurations(DeploymentUnit deploymentUnit, ClassInfo classInfo, AbstractComponentDescription componentDescription) {
        List resourceAnnotations;
        ArrayList<BindingDescription> configurations = new ArrayList<BindingDescription>();
        Map classAnnotations = classInfo.annotations();
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        CompositeIndex index = (CompositeIndex)deploymentUnit.getAttachment(Attachments.COMPOSITE_ANNOTATION_INDEX);
        UnifiedVirtualFile vfs = WebServiceRefAnnotationParsingProcessor.getUnifiedVirtualFile(deploymentUnit);
        if (classAnnotations != null && (resourceAnnotations = (List)classAnnotations.get(WEB_SERVICE_REF_ANNOTATION_NAME)) != null) {
            for (AnnotationInstance annotation : resourceAnnotations) {
                configurations.add(this.getWebServiceConfiguration(annotation, vfs, module, index, componentDescription));
            }
        }
        configurations.addAll(this.processClass(classAnnotations, vfs, module, index));
        return configurations;
    }

    private BindingDescription getWebServiceConfiguration(AnnotationInstance annotation, UnifiedVirtualFile vfs, Module module, CompositeIndex index, AbstractComponentDescription componentDescription) {
        AnnotationTarget annotationTarget = annotation.target();
        BindingDescription resourceConfiguration = annotationTarget instanceof FieldInfo ? this.processField(annotation, (FieldInfo)FieldInfo.class.cast(annotationTarget), vfs, module, index, componentDescription) : (annotationTarget instanceof MethodInfo ? this.processMethod(annotation, (MethodInfo)MethodInfo.class.cast(annotationTarget), vfs, module, index, componentDescription) : (annotationTarget instanceof ClassInfo ? this.processClass(annotation, (ClassInfo)ClassInfo.class.cast(annotationTarget), vfs, module, index) : null));
        return resourceConfiguration;
    }

    private BindingDescription processField(AnnotationInstance annotation, FieldInfo fieldInfo, UnifiedVirtualFile vfs, Module duModule, CompositeIndex index, AbstractComponentDescription componentDescription) {
        WebServiceRefFieldAnnotation fieldProcessor = new WebServiceRefFieldAnnotation(index);
        return this.processWebServiceRef(fieldProcessor, annotation, fieldInfo, vfs, duModule, fieldInfo.name(), fieldProcessor.getDeclaringClass(fieldInfo), componentDescription);
    }

    private BindingDescription processMethod(AnnotationInstance annotation, MethodInfo methodInfo, UnifiedVirtualFile vfs, Module duModule, CompositeIndex index, AbstractComponentDescription componentDescription) {
        String methodName = methodInfo.name();
        if (!methodName.startsWith("set") || methodInfo.args().length != 1) {
            throw new IllegalArgumentException("@WebServiceRef injection target is invalid.  Only setter methods are allowed: " + methodInfo);
        }
        WebServiceRefMethodAnnotation methodProcessor = new WebServiceRefMethodAnnotation(index);
        return this.processWebServiceRef(methodProcessor, annotation, methodInfo, vfs, duModule, methodInfo.name(), methodProcessor.getDeclaringClass(methodInfo), componentDescription);
    }

    private BindingDescription processClass(AnnotationInstance annotation, ClassInfo classInfo, UnifiedVirtualFile vfs, Module duModule, CompositeIndex index) {
        throw new NotImplementedException("Only @WebServiceRef annotations targeting fields and methods are supported at this time");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <E extends AnnotationTarget> BindingDescription processWebServiceRef(AbstractWebServiceRefAnnotation<E> processor, AnnotationInstance annotation, E annotated, UnifiedVirtualFile vfs, Module duModule, String name, String className, AbstractComponentDescription componentDescription) {
        Referenceable referenceable;
        UnifiedServiceRefMetaData ref = processor.process(annotation, annotated, vfs);
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(ClassLoaderProvider.getDefaultProvider().getServerIntegrationClassLoader());
            SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
            ServiceRefHandler serviceRefHandler = ((ServiceRefHandlerFactory)spiProvider.getSPI(ServiceRefHandlerFactory.class)).getServiceRefHandler();
            referenceable = serviceRefHandler.createReferenceable(ref);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
        BindingDescription bindingDescription = new BindingDescription(processor.getName(annotated), componentDescription);
        bindingDescription.setDependency(true);
        bindingDescription.setBindingType(ref.getServiceRefType());
        bindingDescription.setReferenceSourceDescription((BindingSourceDescription)new WebServiceRefSourceDescription(referenceable, duModule));
        InjectionTargetDescription targetDescription = new InjectionTargetDescription();
        targetDescription.setName(name);
        targetDescription.setClassName(className);
        targetDescription.setType(processor.getInjectionType());
        targetDescription.setDeclaredValueClassName(ref.getServiceRefType());
        bindingDescription.getInjectionTargetDescriptions().add(targetDescription);
        return bindingDescription;
    }

    private List<BindingDescription> processClass(Map<DotName, List<AnnotationInstance>> classAnnotations, UnifiedVirtualFile vfs, Module duModule, CompositeIndex index) {
        List<AnnotationInstance> annotations = classAnnotations.get(WEB_SERVICE_REFS_ANNOTATION_NAME);
        if (annotations == null || annotations.isEmpty()) {
            return Collections.emptyList();
        }
        AnnotationInstance annotationInstance = annotations.get(0);
        AnnotationInstance[] resourceAnnotations = annotationInstance.value().asNestedArray();
        ClassInfo classInfo = (ClassInfo)ClassInfo.class.cast(annotationInstance.target());
        ArrayList<BindingDescription> resourceConfigurations = new ArrayList<BindingDescription>(resourceAnnotations.length);
        for (AnnotationInstance resource : resourceAnnotations) {
            resourceConfigurations.add(this.processClass(resource, classInfo, vfs, duModule, index));
        }
        return resourceConfigurations;
    }

    private static UnifiedVirtualFile getUnifiedVirtualFile(DeploymentUnit deploymentUnit) {
        ResourceRoot resourceRoot = (ResourceRoot)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT);
        if (resourceRoot == null) {
            throw new IllegalStateException("Resource root not found for deployment " + deploymentUnit);
        }
        return new VirtualFileAdaptor(resourceRoot.getRoot());
    }

    public static class WebServiceRefSourceDescription
    extends BindingSourceDescription {
        private final Referenceable referenceable;
        private final Module duModule;

        private WebServiceRefSourceDescription(Referenceable referenceable, Module duModule) {
            this.referenceable = referenceable;
            this.duModule = duModule;
        }

        public Object getServiceRefValue() {
            ClassLoader tccl = ClassLoaderProvider.getDefaultProvider().getServerIntegrationClassLoader();
            ClassLoader classLoader = new ClassLoader(((Object)((Object)this)).getClass().getClassLoader()){

                @Override
                public Class<?> loadClass(String className) throws ClassNotFoundException {
                    try {
                        return super.loadClass(className);
                    }
                    catch (ClassNotFoundException cnfe) {
                        return WebServiceRefSourceDescription.this.duModule.getClassLoader().loadClass(className);
                    }
                }

                @Override
                public Enumeration<URL> getResources(String name) throws IOException {
                    final Enumeration<URL> superResources = super.getResources(name);
                    final Enumeration duModuleCLResources = WebServiceRefSourceDescription.this.duModule.getClassLoader().getResources(name);
                    if (superResources == null || !superResources.hasMoreElements()) {
                        return duModuleCLResources;
                    }
                    if (duModuleCLResources == null || !duModuleCLResources.hasMoreElements()) {
                        return superResources;
                    }
                    return new Enumeration<URL>(){

                        @Override
                        public boolean hasMoreElements() {
                            return superResources.hasMoreElements() || duModuleCLResources.hasMoreElements();
                        }

                        @Override
                        public URL nextElement() {
                            if (superResources.hasMoreElements()) {
                                return (URL)superResources.nextElement();
                            }
                            return (URL)duModuleCLResources.nextElement();
                        }
                    };
                }
            };
            Thread.currentThread().setContextClassLoader(classLoader);
            try {
                Object object = new CXFServiceObjectFactoryJAXWS().getObjectInstance((Object)this.referenceable.getReference(), null, null, null);
                return object;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(tccl);
            }
        }

        public void getResourceValue(BindingDescription referenceDescription, ServiceBuilder<?> serviceBuilder, DeploymentPhaseContext phaseContext, Injector<ManagedReferenceFactory> injector) {
            MethodValue getObjectInstanceValue;
            DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
            EEApplicationDescription applicationComponentDescription = (EEApplicationDescription)deploymentUnit.getAttachment(org.jboss.as.ee.component.Attachments.EE_APPLICATION_DESCRIPTION);
            if (applicationComponentDescription == null) {
                return;
            }
            try {
                getObjectInstanceValue = new MethodValue(Values.immediateValue((Object)((Object)((Object)this)).getClass().getMethod("getServiceRefValue", new Class[0])), Values.immediateValue((Object)((Object)this)), Values.emptyList());
            }
            catch (SecurityException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            ValueManagedObject factory = new ValueManagedObject((Value)getObjectInstanceValue);
            serviceBuilder.addInjection(injector, (Object)factory);
        }
    }
}

