/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.dmr;

import java.util.EnumSet;
import java.util.List;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.OperationHandler;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.controller.registry.ModelNodeRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.webservices.dmr.Element;
import org.jboss.as.webservices.dmr.Namespace;
import org.jboss.as.webservices.dmr.WSSubsystemAdd;
import org.jboss.as.webservices.dmr.WSSubsystemDescribe;
import org.jboss.as.webservices.dmr.WSSubsystemProviders;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class WSExtension
implements Extension {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.webservices");
    public static final String SUBSYSTEM_NAME = "webservices";
    private static final WebservicesSubsystemParser PARSER = new WebservicesSubsystemParser();

    public void initialize(ExtensionContext context) {
        log.debugf("Initializing WebServices Extension", new Object[0]);
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME);
        ModelNodeRegistration registration = subsystem.registerSubsystemModel(WSSubsystemProviders.SUBSYSTEM);
        registration.registerOperationHandler("add", (OperationHandler)WSSubsystemAdd.INSTANCE, WSSubsystemProviders.SUBSYSTEM_ADD, false);
        registration.registerOperationHandler("describe", (OperationHandler)WSSubsystemDescribe.INSTANCE, WSSubsystemProviders.SUBSYSTEM_DESCRIBE, false, OperationEntry.EntryType.PRIVATE);
        subsystem.registerXMLElementWriter((XMLElementWriter)PARSER);
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(Namespace.CURRENT.getUriString(), (XMLElementReader)PARSER);
    }

    static class WebservicesSubsystemParser
    implements XMLStreamConstants,
    XMLElementReader<List<ModelNode>>,
    XMLElementWriter<SubsystemMarshallingContext> {
        WebservicesSubsystemParser() {
        }

        public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
            context.startSubsystemElement(Namespace.CURRENT.getUriString(), false);
            writer.writeStartElement(Element.CONFIGURATION.getLocalName());
            ModelNode node = context.getModelNode();
            ModelNode configuration = node.require("configuration");
            this.writeElement(writer, Element.WEBSERVICE_HOST, configuration.require("webservice-host"));
            this.writeElement(writer, Element.MODIFY_SOAP_ADDRESS, configuration.require("modify-soap-address"));
            if (this.has(node, "webservice-secure-port")) {
                this.writeElement(writer, Element.WEBSERVICE_SECURE_PORT, configuration.require("webservice-secure-port"));
            }
            if (this.has(node, "webservice-port")) {
                this.writeElement(writer, Element.WEBSERVICE_PORT, configuration.require("webservice-port"));
            }
            writer.writeEndElement();
            writer.writeEndElement();
        }

        private boolean has(ModelNode node, String name) {
            return node.has(name) && node.get(name).isDefined();
        }

        private void writeElement(XMLExtendedStreamWriter writer, Element element, ModelNode value) throws XMLStreamException {
            writer.writeStartElement(element.getLocalName());
            writer.writeCharacters(value.asString());
            writer.writeEndElement();
        }

        public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
            ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
            ModelNode subsystem = new ModelNode();
            subsystem.get("operation").set("add");
            subsystem.get("address").add("subsystem", WSExtension.SUBSYSTEM_NAME);
            EnumSet<Element> required = EnumSet.of(Element.CONFIGURATION);
            EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
            block6: while (reader.hasNext() && reader.nextTag() != 2) {
                switch (Namespace.forUri(reader.getNamespaceURI())) {
                    case WEBSERVICES_1_0: {
                        Element element = Element.forName(reader.getLocalName());
                        required.remove((Object)element);
                        if (!encountered.add(element)) {
                            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                        }
                        switch (element) {
                            case CONFIGURATION: {
                                ModelNode model = this.parseConfigurationElement(reader);
                                subsystem.get("configuration").set(model);
                                continue block6;
                            }
                        }
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                }
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            if (!required.isEmpty()) {
                throw ParseUtils.missingRequiredElement((XMLExtendedStreamReader)reader, required);
            }
            list.add(subsystem);
        }

        private ModelNode parseConfigurationElement(XMLExtendedStreamReader reader) throws XMLStreamException {
            ModelNode configuration = new ModelNode();
            ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
            EnumSet<Element> required = EnumSet.of(Element.MODIFY_SOAP_ADDRESS, Element.WEBSERVICE_HOST);
            EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
            block9: while (reader.hasNext() && reader.nextTag() != 2) {
                switch (Namespace.forUri(reader.getNamespaceURI())) {
                    case WEBSERVICES_1_0: {
                        Element element = Element.forName(reader.getLocalName());
                        required.remove((Object)element);
                        if (!encountered.add(element)) {
                            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                        }
                        switch (element) {
                            case WEBSERVICE_HOST: {
                                configuration.get("webservice-host").set(this.parseElementNoAttributes(reader));
                                continue block9;
                            }
                            case MODIFY_SOAP_ADDRESS: {
                                boolean b = Boolean.parseBoolean(this.parseElementNoAttributes(reader));
                                configuration.get("modify-soap-address").set(b);
                                continue block9;
                            }
                            case WEBSERVICE_SECURE_PORT: {
                                int port = Integer.valueOf(this.parseElementNoAttributes(reader));
                                configuration.get("webservice-secure-port").set(port);
                                continue block9;
                            }
                            case WEBSERVICE_PORT: {
                                int port = Integer.valueOf(this.parseElementNoAttributes(reader));
                                configuration.get("webservice-port").set(port);
                                continue block9;
                            }
                        }
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                }
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            if (!required.isEmpty()) {
                throw ParseUtils.missingRequiredElement((XMLExtendedStreamReader)reader, required);
            }
            return configuration;
        }

        private String parseElementNoAttributes(XMLExtendedStreamReader reader) throws XMLStreamException {
            ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
            return reader.getElementText().trim();
        }
    }
}

