/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.dmr;

import java.net.UnknownHostException;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelAddOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.RuntimeTask;
import org.jboss.as.controller.RuntimeTaskContext;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.server.BootOperationContext;
import org.jboss.as.server.BootOperationHandler;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.webservices.config.ServerConfigImpl;
import org.jboss.as.webservices.deployers.WebServiceRefAnnotationParsingProcessor;
import org.jboss.as.webservices.dmr.WSDeploymentActivator;
import org.jboss.as.webservices.service.EndpointRegistryService;
import org.jboss.as.webservices.service.ServerConfigService;
import org.jboss.as.webservices.util.ModuleClassLoaderProvider;
import org.jboss.as.webservices.util.WSServices;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.logging.Logger;
import org.jboss.msc.service.ServiceTarget;

public class WSSubsystemAdd
implements ModelAddOperationHandler,
BootOperationHandler {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.webservices");
    static final WSSubsystemAdd INSTANCE = new WSSubsystemAdd();
    private final ParametersValidator operationValidator = new ParametersValidator();
    private final ParametersValidator configValidator = new ParametersValidator();

    private WSSubsystemAdd() {
        this.operationValidator.registerValidator("configuration", (ParameterValidator)new ModelTypeValidator(ModelType.OBJECT));
        this.configValidator.registerValidator("webservice-host", (ParameterValidator)new ModelTypeValidator(ModelType.STRING));
        this.configValidator.registerValidator("modify-soap-address", (ParameterValidator)new ModelTypeValidator(ModelType.BOOLEAN));
        this.configValidator.registerValidator("webservice-port", (ParameterValidator)new ModelTypeValidator(ModelType.INT, true, true));
        this.configValidator.registerValidator("webservice-port", (ParameterValidator)new ModelTypeValidator(ModelType.INT, true, true));
    }

    public OperationResult execute(OperationContext context, ModelNode operation, final ResultHandler resultHandler) throws OperationFailedException {
        this.operationValidator.validate(operation);
        final ModelNode config = operation.require("configuration");
        this.configValidator.validate(config);
        ModelNode subModel = context.getSubModel();
        subModel.get("configuration").set(config);
        if (context instanceof BootOperationContext) {
            final BootOperationContext updateContext = (BootOperationContext)context;
            context.getRuntimeContext().setRuntimeTask(new RuntimeTask(){

                public void execute(RuntimeTaskContext context) throws OperationFailedException {
                    log.info((Object)"Activating WebServices Extension");
                    ModuleClassLoaderProvider.register();
                    WSServices.saveContainerRegistry(context.getServiceRegistry());
                    ServiceTarget serviceTarget = context.getServiceTarget();
                    ServerConfigImpl serverConfig = WSSubsystemAdd.createServerConfig(config);
                    ServerConfigService.install(serviceTarget, serverConfig);
                    EndpointRegistryService.install(serviceTarget);
                    WSDeploymentActivator.activate(updateContext);
                    resultHandler.handleResultComplete();
                }
            });
            updateContext.addDeploymentProcessor(Phase.PARSE, 13824, (DeploymentUnitProcessor)new WebServiceRefAnnotationParsingProcessor());
        } else {
            resultHandler.handleResultComplete();
        }
        ModelNode compensatingOperation = Util.getResourceRemoveOperation((ModelNode)operation.require("address"));
        return new BasicOperationResult(compensatingOperation);
    }

    private static ServerConfigImpl createServerConfig(ModelNode configuration) {
        ServerConfigImpl config = ServerConfigImpl.getInstance();
        try {
            config.setWebServiceHost(configuration.require("webservice-host").asString());
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
        config.setModifySOAPAddress(configuration.require("modify-soap-address").asBoolean());
        if (configuration.hasDefined("webservice-port")) {
            config.setWebServicePort(configuration.require("webservice-port").asInt());
        }
        if (configuration.hasDefined("webservice-secure-port")) {
            config.setWebServiceSecurePort(configuration.require("webservice-secure-port").asInt());
        }
        return config;
    }
}

