/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.service;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import org.jboss.as.osgi.parser.SubsystemState;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.ServerEnvironmentService;
import org.jboss.logging.Logger;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.AbstractService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.deployment.deployer.DeploymentFactory;
import org.jboss.osgi.framework.AutoInstallProcessor;
import org.jboss.osgi.framework.BundleManagement;
import org.jboss.osgi.framework.ServiceNames;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.metadata.OSGiMetaDataBuilder;
import org.jboss.osgi.spi.util.BundleInfo;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

final class AutoInstallIntegration
extends AbstractService<AutoInstallProcessor>
implements AutoInstallProcessor {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.osgi");
    private InjectedValue<BundleManagement> injectedBundleManager = new InjectedValue();
    private final InjectedValue<ServerEnvironment> injectedEnvironment = new InjectedValue();
    private InjectedValue<Bundle> injectedSystemBundle = new InjectedValue();
    private SubsystemState subsystemState;

    static void addService(ServiceTarget target, SubsystemState subsystemState) {
        AutoInstallIntegration service = new AutoInstallIntegration(subsystemState);
        ServiceBuilder builder = target.addService(ServiceNames.AUTOINSTALL_BUNDLES, (Service)service);
        builder.addDependency(ServerEnvironmentService.SERVICE_NAME, ServerEnvironment.class, service.injectedEnvironment);
        builder.addDependency(ServiceNames.BUNDLE_MANAGER, BundleManagement.class, service.injectedBundleManager);
        builder.addDependency(ServiceNames.SYSTEM_BUNDLE, Bundle.class, service.injectedSystemBundle);
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
        builder.install();
    }

    private AutoInstallIntegration(SubsystemState subsystemState) {
        this.subsystemState = subsystemState;
    }

    public void start(StartContext context) throws StartException {
        final HashMap<ServiceName, SubsystemState.OSGiModule> pendingServices = new HashMap<ServiceName, SubsystemState.OSGiModule>();
        try {
            BundleManagement bundleManager = (BundleManagement)this.injectedBundleManager.getValue();
            final ServiceContainer serviceContainer = context.getController().getServiceContainer();
            ServiceTarget serviceTarget = context.getChildTarget();
            File modulesDir = ((ServerEnvironment)this.injectedEnvironment.getValue()).getModulesDir();
            File bundlesDir = new File(modulesDir.getPath() + "/../bundles").getCanonicalFile();
            for (SubsystemState.OSGiModule moduleMetaData : this.subsystemState.getModules()) {
                ServiceName serviceName;
                ModuleIdentifier identifier = moduleMetaData.getIdentifier();
                File bundleFile = this.getRepositoryEntry(bundlesDir, identifier);
                if (bundleFile != null) {
                    URL url = bundleFile.toURI().toURL();
                    BundleInfo info = BundleInfo.createBundleInfo((URL)url);
                    Deployment dep = DeploymentFactory.createDeployment((BundleInfo)info);
                    dep.setAutoStart(moduleMetaData.isStart());
                    serviceName = bundleManager.installBundle(serviceTarget, dep);
                } else {
                    ModuleLoader moduleLoader = Module.getBootModuleLoader();
                    Module module = moduleLoader.loadModule(identifier);
                    OSGiMetaData metadata = this.getModuleMetadata(module);
                    serviceName = bundleManager.installBundle(serviceTarget, module, metadata);
                }
                pendingServices.put(serviceName, moduleMetaData);
            }
            ServiceName servicesInstalled = ServiceNames.AUTOINSTALL_BUNDLES.append(new String[]{"INSTALLED"});
            ServiceBuilder builder = serviceTarget.addService(servicesInstalled, (Service)new AbstractService<Void>(){

                public void start(StartContext context) throws StartException {
                    log.debugf("Auto bundles installed", new Object[0]);
                }
            });
            builder.addDependencies(pendingServices.keySet());
            builder.install();
            builder = serviceTarget.addService(ServiceNames.AUTOINSTALL_BUNDLES_COMPLETE, (Service)new AbstractService<Void>(){

                public void start(StartContext context) throws StartException {
                    for (ServiceName serviceName : pendingServices.keySet()) {
                        SubsystemState.OSGiModule moduleMetaData = (SubsystemState.OSGiModule)pendingServices.get(serviceName);
                        if (!moduleMetaData.isStart()) continue;
                        ServiceController controller = serviceContainer.getRequiredService(serviceName);
                        Bundle bundle = (Bundle)controller.getValue();
                        try {
                            bundle.start();
                        }
                        catch (BundleException ex) {
                            log.errorf((Throwable)ex, "Cannot start persistent bundle: %s", (Object)bundle);
                        }
                    }
                    log.debugf("Auto bundles bundles started", new Object[0]);
                }
            });
            builder.addDependencies(new ServiceName[]{servicesInstalled});
            builder.install();
        }
        catch (Exception ex) {
            throw new StartException("Failed to create auto install list", (Throwable)ex);
        }
    }

    public AutoInstallProcessor getValue() throws IllegalStateException {
        return this;
    }

    private File getRepositoryEntry(File rootDir, ModuleIdentifier identifier) throws IOException {
        String identifierPath = identifier.getName().replace('.', '/') + "/" + identifier.getSlot();
        File entryDir = new File(rootDir + "/" + identifierPath);
        if (!entryDir.isDirectory()) {
            log.debugf("Cannot obtain directory: %s", (Object)entryDir);
            return null;
        }
        String[] files = entryDir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        });
        if (files.length == 0) {
            log.debugf("Cannot find jar in: %s", (Object)entryDir);
            return null;
        }
        if (files.length > 1) {
            log.debugf("Multiple jars in: %s", (Object)entryDir);
            return null;
        }
        File entryFile = new File(entryDir + "/" + files[0]);
        if (!entryFile.exists()) {
            log.debugf("File does not exist: %s", (Object)entryFile);
            return null;
        }
        return entryFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OSGiMetaData getModuleMetadata(Module module) throws IOException {
        File modulesDir = ((ServerEnvironment)this.injectedEnvironment.getValue()).getModulesDir();
        ModuleIdentifier identifier = module.getIdentifier();
        String identifierPath = identifier.getName().replace('.', '/') + "/" + identifier.getSlot();
        File entryFile = new File(modulesDir + "/" + identifierPath + "/jbosgi-xservice.properties");
        if (!entryFile.exists()) {
            log.debugf("Cannot obtain OSGi metadata file: %s", (Object)entryFile);
            return null;
        }
        FileInputStream input = new FileInputStream(entryFile);
        try {
            OSGiMetaData oSGiMetaData = OSGiMetaDataBuilder.load((InputStream)input);
            return oSGiMetaData;
        }
        finally {
            input.close();
        }
    }
}

