/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.service;

import java.io.InputStream;
import java.util.concurrent.Future;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.client.helpers.standalone.DeploymentAction;
import org.jboss.as.controller.client.helpers.standalone.DeploymentPlan;
import org.jboss.as.controller.client.helpers.standalone.InitialDeploymentPlanBuilder;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentActionResult;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentManager;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentPlanResult;
import org.jboss.as.osgi.deployment.DeploymentHolderService;
import org.jboss.as.server.ServerController;
import org.jboss.as.server.Services;
import org.jboss.as.server.deployment.client.ModelControllerServerDeploymentManager;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.framework.BundleInstallHandler;
import org.jboss.osgi.framework.BundleManagement;
import org.jboss.osgi.framework.ServiceNames;
import org.osgi.framework.BundleException;

public class InstallHandlerIntegration
implements BundleInstallHandler {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.osgi");
    private final InjectedValue<ServerController> injectedServerController = new InjectedValue();
    private final InjectedValue<BundleManagement> injectedBundleManager = new InjectedValue();
    private ServerDeploymentManager deploymentManager;

    public static void addService(ServiceTarget target) {
        InstallHandlerIntegration service = new InstallHandlerIntegration();
        ServiceBuilder builder = target.addService(ServiceNames.BUNDLE_INSTALL_HANDLER, (Service)service);
        builder.addDependency(Services.JBOSS_SERVER_CONTROLLER, ServerController.class, service.injectedServerController);
        builder.addDependency(ServiceNames.BUNDLE_MANAGER, BundleManagement.class, service.injectedBundleManager);
        builder.addDependency(ServiceNames.FRAMEWORK_CREATE);
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
        builder.install();
    }

    private InstallHandlerIntegration() {
    }

    public void start(StartContext context) throws StartException {
        this.deploymentManager = new ModelControllerServerDeploymentManager((ModelController)this.injectedServerController.getValue());
    }

    public void stop(StopContext context) {
    }

    public BundleInstallHandler getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public void installBundle(ServiceTarget serviceTarget, Deployment dep) throws BundleException {
        log.tracef("Install deployment: %s", (Object)dep);
        try {
            String contextName = DeploymentHolderService.getContextName(dep);
            DeploymentHolderService.addService(serviceTarget, contextName, dep);
            InputStream inputStream = dep.getRoot().openStream();
            InitialDeploymentPlanBuilder builder = this.deploymentManager.newDeploymentPlan();
            builder = builder.add(contextName, inputStream).andDeploy();
            DeploymentPlan plan = builder.build();
            DeploymentAction deployAction = builder.getLastAction();
            this.executeDeploymentPlan(plan, deployAction);
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (BundleException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new BundleException("Cannot deploy bundle: " + dep, (Throwable)ex);
        }
    }

    public void uninstallBundle(Deployment dep) {
        log.tracef("Uninstall deployment: %s", (Object)dep);
        BundleManagement bundleManager = (BundleManagement)this.injectedBundleManager.getValue();
        bundleManager.uninstallBundle(dep);
        try {
            InitialDeploymentPlanBuilder builder = this.deploymentManager.newDeploymentPlan();
            String contextName = DeploymentHolderService.getContextName(dep);
            builder = builder.undeploy(contextName).remove(contextName);
            DeploymentPlan plan = builder.build();
            DeploymentAction removeAction = builder.getLastAction();
            this.executeDeploymentPlan(plan, removeAction);
        }
        catch (Exception ex) {
            log.warn((Object)("Cannot undeploy bundle: " + dep), (Throwable)ex);
        }
    }

    private String executeDeploymentPlan(DeploymentPlan plan, DeploymentAction action) throws Exception {
        Exception deploymentException;
        Future future = this.deploymentManager.execute(plan);
        ServerDeploymentPlanResult planResult = (ServerDeploymentPlanResult)future.get();
        ServerDeploymentActionResult actionResult = planResult.getDeploymentActionResult(action.getId());
        if (actionResult != null && (deploymentException = (Exception)actionResult.getDeploymentException()) != null) {
            throw deploymentException;
        }
        return action.getDeploymentUnitUniqueName();
    }
}

