/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server;

import java.util.List;
import java.util.concurrent.Executor;
import org.jboss.as.controller.persistence.ExtensibleConfigurationPersister;
import org.jboss.as.server.ApplicationServerService;
import org.jboss.as.server.Bootstrap;
import org.jboss.as.server.ServerController;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.Services;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceActivator;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceNotFoundException;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartException;
import org.jboss.threads.AsyncFuture;
import org.jboss.threads.AsyncFutureTask;
import org.jboss.threads.JBossExecutors;

final class BootstrapImpl
implements Bootstrap {
    private final ServiceContainer container = ServiceContainer.Factory.create((String)"jboss-as");

    BootstrapImpl() {
    }

    @Override
    public AsyncFuture<ServiceContainer> bootstrap(Bootstrap.Configuration configuration, List<ServiceActivator> extraServices) {
        if (configuration == null) {
            throw new IllegalArgumentException("configuration is null");
        }
        ModuleLoader moduleLoader = configuration.getModuleLoader();
        ServerEnvironment serverEnvironment = configuration.getServerEnvironment();
        if (serverEnvironment == null) {
            throw new IllegalArgumentException("serverEnvironment is null");
        }
        String name = serverEnvironment.getServerName();
        ExtensibleConfigurationPersister configurationPersister = configuration.getConfigurationPersister();
        if (moduleLoader == null) {
            throw new IllegalArgumentException("moduleLoader is null");
        }
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        if (configurationPersister == null) {
            throw new IllegalArgumentException("configurationPersister is null");
        }
        final FutureServiceContainer future = new FutureServiceContainer(this.container);
        ServiceTarget tracker = this.container.subTarget();
        ApplicationServerService applicationServerService = new ApplicationServerService(extraServices, configuration);
        tracker.addService(Services.JBOSS_AS, (Service)applicationServerService).install();
        ServiceController rootService = this.container.getRequiredService(Services.JBOSS_AS);
        rootService.addListener((ServiceListener)new AbstractServiceListener<Object>(){

            public void serviceStarted(ServiceController<?> controller) {
                controller.removeListener((ServiceListener)this);
                ServiceController controllerServiceController = controller.getServiceContainer().getRequiredService(Services.JBOSS_SERVER_CONTROLLER);
                controllerServiceController.addListener((ServiceListener)new AbstractServiceListener<Object>(){

                    public void serviceStarted(ServiceController<?> controller) {
                        future.done((ServerController)controller.getValue());
                        controller.removeListener((ServiceListener)this);
                    }

                    public void serviceFailed(ServiceController<?> controller, StartException reason) {
                        future.failed((Throwable)reason);
                        controller.removeListener((ServiceListener)this);
                    }

                    public void serviceRemoved(ServiceController<?> controller) {
                        future.failed((Throwable)new ServiceNotFoundException("Server controller service was removed"));
                        controller.removeListener((ServiceListener)this);
                    }
                });
            }

            public void serviceFailed(ServiceController<?> controller, StartException reason) {
                controller.removeListener((ServiceListener)this);
                future.failed((Throwable)reason);
            }

            public void serviceRemoved(ServiceController<?> controller) {
                controller.removeListener((ServiceListener)this);
                future.failed((Throwable)new ServiceNotFoundException("Root service was removed"));
            }
        });
        return future;
    }

    @Override
    public AsyncFuture<ServiceContainer> startup(Bootstrap.Configuration configuration, List<ServiceActivator> extraServices) {
        try {
            ServiceContainer container = (ServiceContainer)this.bootstrap(configuration, extraServices).get();
            ServiceController controller = container.getRequiredService(Services.JBOSS_AS);
            AsyncFuture startupFuture = (AsyncFuture)controller.getValue();
            return startupFuture;
        }
        catch (Exception ex) {
            throw new IllegalStateException("Cannot start server", ex);
        }
    }

    private static class FutureServiceContainer
    extends AsyncFutureTask<ServiceContainer> {
        private final ServiceContainer container;

        public FutureServiceContainer(ServiceContainer container) {
            super((Executor)JBossExecutors.directExecutor());
            this.container = container;
        }

        public void asyncCancel(boolean interruptionDesired) {
            this.container.shutdown();
            this.container.addTerminateListener(new ServiceContainer.TerminateListener(){

                public void handleTermination(ServiceContainer.TerminateListener.Info info) {
                    FutureServiceContainer.this.setCancelled();
                }
            });
        }

        void done(ServerController controller) {
            this.setResult(this.container);
        }

        void failed(Throwable t) {
            this.setFailed(t);
        }
    }
}

