/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.controller.descriptions;

import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.controller.descriptions.common.CommonDescriptions;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class ServerRootDescription {
    private static final String RESOURCE_NAME = ServerRootDescription.class.getPackage().getName() + ".LocalDescriptions";

    public static ModelNode getDescription(Locale locale) {
        ResourceBundle bundle = ServerRootDescription.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("description").set(bundle.getString("server"));
        root.get("head-comment-allowed").set(true);
        root.get("tail-comment-allowed").set(true);
        root.get(new String[]{"attributes", "namespaces"}).set(CommonDescriptions.getNamespacePrefixAttribute((Locale)locale));
        root.get(new String[]{"attributes", "schema-locations"}).set(CommonDescriptions.getSchemaLocationAttribute((Locale)locale));
        root.get(new String[]{"attributes", "name", "description"}).set(bundle.getString("server.name"));
        root.get(new String[]{"attributes", "name", "type"}).set(ModelType.STRING);
        root.get(new String[]{"attributes", "name", "required"}).set(false);
        root.get(new String[]{"attributes", "name", "nillable"}).set(true);
        root.get(new String[]{"attributes", "name", "min-length"}).set(1);
        root.get(new String[]{"attributes", "profile-name", "description"}).set(bundle.getString("server.profile"));
        root.get(new String[]{"attributes", "profile-name", "type"}).set(ModelType.STRING);
        root.get(new String[]{"attributes", "profile-name", "required"}).set(true);
        root.get(new String[]{"attributes", "profile-name", "min-length"}).set(1);
        root.get(new String[]{"attributes", "profile-name", "head-comment-allowed"}).set(true);
        root.get(new String[]{"attributes", "profile-name", "tail-comment-allowed"}).set(true);
        root.get(new String[]{"attributes", "system-properties"}).set(CommonDescriptions.getSystemPropertiesAttribute((Locale)locale));
        root.get(new String[]{"attributes", "server-state", "description"}).set(bundle.getString("server.state"));
        root.get(new String[]{"attributes", "server-state", "type"}).set(ModelType.STRING);
        root.get(new String[]{"attributes", "server-state", "required"}).set(true);
        root.get(new String[]{"attributes", "server-state", "nillable"}).set(false);
        root.get(new String[]{"attributes", "server-state", "min-length"}).set(1);
        root.get("operations");
        root.get(new String[]{"children", "extension", "description"}).set(bundle.getString("server.extension"));
        root.get(new String[]{"children", "extension", "min-occurs"}).set(0);
        root.get(new String[]{"children", "extension", "model-description"});
        root.get(new String[]{"children", "path", "description"}).set(bundle.getString("server.path"));
        root.get(new String[]{"children", "path", "min-occurs"}).set(0);
        root.get(new String[]{"children", "path", "model-description"});
        root.get(new String[]{"children", "management-interfaces", "description"}).set(bundle.getString("server.management"));
        root.get(new String[]{"children", "management-interfaces", "min-occurs"}).set(0);
        root.get(new String[]{"children", "management-interfaces", "model-description"});
        root.get(new String[]{"children", "interface", "description"}).set(bundle.getString("server.interface"));
        root.get(new String[]{"children", "interface", "min-occurs"}).set(0);
        root.get(new String[]{"children", "interface", "model-description"});
        root.get(new String[]{"children", "socket-binding-group", "description"}).set(bundle.getString("server.socket-binding"));
        root.get(new String[]{"children", "socket-binding-group", "min-occurs"}).set(0);
        root.get(new String[]{"children", "socket-binding-group", "model-description"});
        root.get(new String[]{"children", "system-property", "description"}).set(bundle.getString("server.system-property"));
        root.get(new String[]{"children", "system-property", "min-occurs"}).set(0);
        root.get(new String[]{"children", "system-property", "model-description"});
        root.get(new String[]{"children", "deployment", "description"}).set(bundle.getString("server.deployment"));
        root.get(new String[]{"children", "deployment", "min-occurs"}).set(0);
        root.get(new String[]{"children", "deployment", "model-description"});
        return root;
    }

    public static ModelNode getCompositeOperationDescription(Locale locale) {
        ResourceBundle bundle = ServerRootDescription.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("operation-name").set("composite");
        root.get("description").set(bundle.getString("composite"));
        root.get(new String[]{"request-properties", "steps", "type"}).set(ModelType.LIST);
        root.get(new String[]{"request-properties", "steps", "description"}).set(bundle.getString("composite.steps"));
        root.get(new String[]{"request-properties", "steps", "required"}).set(true);
        root.get(new String[]{"reply-properties", "type"}).set(ModelType.LIST);
        root.get(new String[]{"reply-properties", "description"}).set(bundle.getString("composite.result"));
        return root;
    }

    public static ModelNode getShutdownOperationDescription(Locale locale) {
        ResourceBundle bundle = ServerRootDescription.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("shutdown");
        node.get("description").set(bundle.getString("shutdown"));
        node.get("request-properties").setEmptyObject();
        node.get("reply-properties").setEmptyObject();
        return node;
    }

    private static ResourceBundle getResourceBundle(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return ResourceBundle.getBundle(RESOURCE_NAME, locale);
    }

    public static void main(String[] args) {
        ModelNode root = ServerRootDescription.getDescription(null);
        System.out.println(root);
    }
}

