/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.HashUtil;
import org.jboss.as.controller.ModelUpdateOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.DeploymentDescription;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.server.deployment.DeploymentHandlerUtil;
import org.jboss.as.server.deployment.api.DeploymentRepository;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class DeploymentFullReplaceHandler
implements ModelUpdateOperationHandler,
DescriptionProvider {
    public static final String OPERATION_NAME = "full-replace-deployment";
    private static final List<String> VALID_DEPLOYMENT_PARAMETERS = Arrays.asList("input-stream-index", "bytes", "hash", "url");
    private final DeploymentRepository deploymentRepository;
    private final ParametersValidator validator = new ParametersValidator();

    static final ModelNode getOperation(ModelNode address) {
        return Util.getEmptyOperation((String)OPERATION_NAME, (ModelNode)address);
    }

    public DeploymentFullReplaceHandler(DeploymentRepository deploymentRepository) {
        this.deploymentRepository = deploymentRepository;
        this.validator.registerValidator("name", (ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, false, false));
        this.validator.registerValidator("runtime-name", (ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, false));
        this.validator.registerValidator("hash", (ParameterValidator)new ModelTypeValidator(ModelType.BYTES, true));
        this.validator.registerValidator("input-stream-index", (ParameterValidator)new ModelTypeValidator(ModelType.INT, true));
        this.validator.registerValidator("bytes", (ParameterValidator)new ModelTypeValidator(ModelType.BYTES, true));
        this.validator.registerValidator("url", (ParameterValidator)new StringLengthValidator(1, true));
    }

    public ModelNode getModelDescription(Locale locale) {
        return DeploymentDescription.getFullReplaceDeploymentOperation((Locale)locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationResult execute(OperationContext context, ModelNode operation, ResultHandler resultHandler) throws OperationFailedException {
        ModelNode rootModel;
        ModelNode deployments;
        ModelNode replaceNode;
        byte[] hash;
        String runtimeName;
        String name;
        block14: {
            this.validator.validate(operation);
            name = operation.require("name").asString();
            String string = runtimeName = operation.hasDefined("runtime-name") ? operation.get("runtime-name").asString() : name;
            if (this.tooManyDeploymentParametersDefined(operation)) {
                throw this.createFailureException("Only allowed one of the following parameters is allowed %s.", VALID_DEPLOYMENT_PARAMETERS);
            }
            if (operation.hasDefined("hash")) {
                hash = operation.get("hash").asBytes();
                if (!this.deploymentRepository.hasDeploymentContent(hash)) {
                    throw this.createFailureException("No deployment content with hash %s is available in the deployment content repository.", HashUtil.bytesToHexString((byte[])hash));
                }
            } else {
                if (this.hasValidDeploymentParameterDefined(operation)) {
                    InputStream in = this.getContents(context, operation);
                    try {
                        try {
                            hash = this.deploymentRepository.addDeploymentContent(in);
                            break block14;
                        }
                        catch (IOException e) {
                            throw this.createFailureException(e.toString());
                        }
                    }
                    finally {
                        StreamUtils.safeClose((Closeable)in);
                    }
                }
                throw this.createFailureException("None of the following parameters were defined %s.", VALID_DEPLOYMENT_PARAMETERS);
            }
        }
        ModelNode modelNode = replaceNode = (deployments = (rootModel = context.getSubModel()).get("deployment")).hasDefined(name) ? deployments.get(name) : null;
        if (replaceNode == null) {
            throw this.createFailureException("No deployment with name %s found", name);
        }
        boolean start = replaceNode.get("enabled").asBoolean();
        ModelNode deployNode = new ModelNode();
        deployNode.get("name").set(name);
        deployNode.get("runtime-name").set(runtimeName);
        deployNode.get("hash").set(hash);
        deployNode.get("enabled").set(start);
        deployments.get(name).set(deployNode);
        ModelNode compensatingOp = operation.clone();
        compensatingOp.get("runtime-name").set(replaceNode.get("runtime-name").asString());
        compensatingOp.get("hash").set(replaceNode.get("hash").asBytes());
        if (operation.hasDefined("input-stream-index")) {
            operation.remove("input-stream-index");
        }
        if (start) {
            DeploymentHandlerUtil.replace(deployNode, name, context, resultHandler);
        } else {
            resultHandler.handleResultComplete();
        }
        return new BasicOperationResult(compensatingOp);
    }

    private InputStream getContents(OperationContext context, ModelNode operation) throws OperationFailedException {
        InputStream in = null;
        String message = "";
        if (operation.hasDefined("input-stream-index")) {
            int streamIndex = operation.get("input-stream-index").asInt();
            if (streamIndex > context.getInputStreams().size() - 1) {
                IllegalArgumentException e = new IllegalArgumentException("Invalid input-stream-index=" + streamIndex + ", the maximum index is " + (context.getInputStreams().size() - 1));
                throw this.createFailureException(e, e.getMessage());
            }
            message = "Null stream at index " + streamIndex;
            in = (InputStream)context.getInputStreams().get(streamIndex);
        } else if (operation.hasDefined("bytes")) {
            message = "Invalid byte stream.";
            in = new ByteArrayInputStream(operation.get("bytes").asBytes());
        } else if (operation.hasDefined("url")) {
            String urlSpec = operation.get("url").asString();
            try {
                message = "Invalid url stream.";
                in = new URL(urlSpec).openStream();
            }
            catch (MalformedURLException e) {
                throw this.createFailureException(message);
            }
            catch (IOException e) {
                throw this.createFailureException(message);
            }
        }
        if (in == null) {
            throw this.createFailureException(message);
        }
        return in;
    }

    private boolean hasValidDeploymentParameterDefined(ModelNode operation) {
        for (String s : VALID_DEPLOYMENT_PARAMETERS) {
            if (!operation.hasDefined(s)) continue;
            return true;
        }
        return false;
    }

    private boolean tooManyDeploymentParametersDefined(ModelNode operation) {
        int count = 0;
        for (String s : VALID_DEPLOYMENT_PARAMETERS) {
            if (!operation.hasDefined(s)) continue;
            ++count;
        }
        return count > 1;
    }

    private OperationFailedException createFailureException(String format, Object ... params) {
        return this.createFailureException(String.format(format, params));
    }

    private OperationFailedException createFailureException(Throwable cause, String format, Object ... params) {
        return this.createFailureException(cause, String.format(format, params));
    }

    private OperationFailedException createFailureException(String msg) {
        return new OperationFailedException(new ModelNode().set(msg));
    }

    private OperationFailedException createFailureException(Throwable cause, String msg) {
        return new OperationFailedException(cause, new ModelNode().set(msg));
    }
}

