/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.RuntimeTask;
import org.jboss.as.controller.RuntimeTaskContext;
import org.jboss.as.server.deployment.DeployerChains;
import org.jboss.as.server.deployment.RootDeploymentUnitService;
import org.jboss.as.server.deployment.Services;
import org.jboss.as.server.deployment.api.ServerDeploymentRepository;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;

public class DeploymentHandlerUtil {
    private DeploymentHandlerUtil() {
    }

    public static void deploy(final ModelNode deploymentModel, OperationContext context, final ResultHandler resultHandler) throws OperationFailedException {
        if (context.getRuntimeContext() != null) {
            context.getRuntimeContext().setRuntimeTask(new RuntimeTask(){

                public void execute(RuntimeTaskContext runtimeContext) throws OperationFailedException {
                    DeploymentHandlerUtil.deploy(deploymentModel, runtimeContext, resultHandler);
                }
            });
        } else {
            resultHandler.handleResultComplete();
        }
    }

    private static void deploy(ModelNode deploymentModel, RuntimeTaskContext context, ResultHandler resultHandler) {
        String deploymentUnitName = deploymentModel.require("name").asString();
        ServiceName deploymentUnitServiceName = Services.deploymentUnitName(deploymentUnitName);
        ServiceRegistry serviceRegistry = context.getServiceRegistry();
        ServiceController controller = serviceRegistry.getService(deploymentUnitServiceName);
        if (controller != null) {
            controller.setMode(ServiceController.Mode.ACTIVE);
        } else {
            ServiceTarget serviceTarget = context.getServiceTarget();
            String runtimeName = deploymentModel.require("runtime-name").asString();
            byte[] hash = deploymentModel.require("hash").asBytes();
            RootDeploymentUnitService service = new RootDeploymentUnitService(deploymentUnitName, runtimeName, hash, null);
            serviceTarget.addService(deploymentUnitServiceName, (Service)service).addDependency(Services.JBOSS_DEPLOYMENT_CHAINS, DeployerChains.class, service.getDeployerChainsInjector()).addDependency(ServerDeploymentRepository.SERVICE_NAME, ServerDeploymentRepository.class, service.getServerDeploymentRepositoryInjector()).setInitialMode(ServiceController.Mode.ACTIVE).install();
            resultHandler.handleResultComplete();
        }
    }

    public static void redeploy(final ModelNode deploymentModel, OperationContext operationContext, final ResultHandler resultHandler) throws OperationFailedException {
        if (operationContext.getRuntimeContext() != null) {
            operationContext.getRuntimeContext().setRuntimeTask(new RuntimeTask(){

                public void execute(RuntimeTaskContext context) throws OperationFailedException {
                    String deploymentUnitName = deploymentModel.require("name").asString();
                    ServiceController controller = context.getServiceRegistry().getService(Services.deploymentUnitName(deploymentUnitName));
                    if (controller != null) {
                        controller.addListener((ServiceListener)new AbstractServiceListener<Object>(){

                            public void listenerAdded(ServiceController<?> controller) {
                                if (!controller.compareAndSetMode(ServiceController.Mode.ACTIVE, ServiceController.Mode.NEVER)) {
                                    controller.removeListener((ServiceListener)this);
                                }
                            }

                            public void serviceStopping(ServiceController<?> controller) {
                                controller.removeListener((ServiceListener)this);
                                controller.compareAndSetMode(ServiceController.Mode.NEVER, ServiceController.Mode.ACTIVE);
                            }
                        });
                    } else {
                        DeploymentHandlerUtil.deploy(deploymentModel, context, resultHandler);
                    }
                }
            });
        } else {
            resultHandler.handleResultComplete();
        }
    }

    public static void replace(final ModelNode deploymentModel, final String toReplace, OperationContext operationContext, final ResultHandler resultHandler) throws OperationFailedException {
        if (operationContext.getRuntimeContext() != null) {
            operationContext.getRuntimeContext().setRuntimeTask(new RuntimeTask(){

                public void execute(final RuntimeTaskContext runtimeContext) throws OperationFailedException {
                    final ServiceController controller = runtimeContext.getServiceRegistry().getService(Services.deploymentUnitName(toReplace));
                    if (controller != null) {
                        controller.addListener((ServiceListener)new AbstractServiceListener<Object>(){

                            public void listenerAdded(ServiceController<? extends Object> serviceController) {
                                controller.setMode(ServiceController.Mode.REMOVE);
                            }

                            public void serviceRemoved(ServiceController<? extends Object> serviceController) {
                                controller.removeListener((ServiceListener)this);
                                DeploymentHandlerUtil.deploy(deploymentModel, runtimeContext, resultHandler);
                            }
                        });
                    } else {
                        DeploymentHandlerUtil.deploy(deploymentModel, runtimeContext, resultHandler);
                    }
                }
            });
        } else {
            resultHandler.handleResultComplete();
        }
    }
}

