/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.module;

import java.util.ArrayList;
import java.util.List;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.filter.PathFilters;

public class SubDeploymentDependencyProcessor
implements DeploymentUnitProcessor {
    @Override
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        DeploymentUnit parent = deploymentUnit.getParent();
        if (parent == null) {
            return;
        }
        ModuleSpecification parentModuleSpec = parent.getAttachment(Attachments.MODULE_SPECIFICATION);
        ModuleSpecification moduleSpec = deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
        ModuleLoader moduleLoader = deploymentUnit.getAttachment(Attachments.SERVICE_MODULE_LOADER);
        ModuleIdentifier parentModule = parent.getAttachment(Attachments.MODULE_IDENTIFIER);
        ModuleIdentifier moduleIdentifier = deploymentUnit.getAttachment(Attachments.MODULE_IDENTIFIER);
        if (parentModule != null) {
            ModuleDependency moduleDependency = new ModuleDependency(moduleLoader, parentModule, false, false, true);
            moduleDependency.addImportFilter(PathFilters.acceptAll(), true);
            moduleSpec.addDependency(moduleDependency);
        }
        if (parentModuleSpec.isExtendedClassVisibility()) {
            List<DeploymentUnit> subDeployments = parent.getAttachmentList(Attachments.SUB_DEPLOYMENTS);
            ArrayList<ModuleDependency> accessibleModules = new ArrayList<ModuleDependency>();
            for (DeploymentUnit subDeployment : subDeployments) {
                ModuleSpecification subModule = subDeployment.getAttachment(Attachments.MODULE_SPECIFICATION);
                if (subModule.isPrivateModule()) continue;
                ModuleIdentifier identifier = subDeployment.getAttachment(Attachments.MODULE_IDENTIFIER);
                ModuleDependency dependency = new ModuleDependency(moduleLoader, identifier, false, false, true);
                dependency.addImportFilter(PathFilters.acceptAll(), true);
                accessibleModules.add(dependency);
            }
            for (ModuleDependency identifier : accessibleModules) {
                if (identifier.equals(moduleIdentifier)) continue;
                moduleSpec.addDependencies(accessibleModules);
            }
        }
    }

    @Override
    public void undeploy(DeploymentUnit context) {
    }
}

