/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.mgmt;

import java.io.File;
import java.net.InetSocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.jboss.as.controller.ModelController;
import org.jboss.as.domain.http.server.DomainHttpServer;
import org.jboss.as.server.services.net.NetworkInterfaceBinding;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class HttpManagementService
implements Service<HttpManagementService> {
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"server", "controller", "management", "http"});
    private final InjectedValue<ModelController> modelControllerValue = new InjectedValue();
    private final InjectedValue<NetworkInterfaceBinding> interfaceBindingValue = new InjectedValue();
    private final InjectedValue<Integer> portValue = new InjectedValue();
    private final InjectedValue<ExecutorService> executorServiceValue = new InjectedValue();
    private final InjectedValue<String> tempDirValue = new InjectedValue();
    private DomainHttpServer server;

    public synchronized void start(StartContext context) throws StartException {
        ModelController modelController = (ModelController)this.modelControllerValue.getValue();
        ExecutorService executorService = (ExecutorService)this.executorServiceValue.getValue();
        NetworkInterfaceBinding interfaceBinding = (NetworkInterfaceBinding)this.interfaceBindingValue.getValue();
        Integer port = (Integer)this.portValue.getValue();
        InetSocketAddress bindAddress = new InetSocketAddress(interfaceBinding.getAddress(), (int)port);
        File tempDir = new File((String)this.tempDirValue.getValue());
        try {
            this.server = DomainHttpServer.create((InetSocketAddress)bindAddress, (int)50, (ModelController)modelController, (Executor)executorService, (File)tempDir);
            this.server.start();
        }
        catch (Exception e) {
            throw new StartException("Failed to start server socket", (Throwable)e);
        }
    }

    public synchronized void stop(StopContext context) {
        if (this.server != null) {
            this.server.stop();
        }
    }

    public HttpManagementService getValue() throws IllegalStateException {
        return this;
    }

    public Injector<NetworkInterfaceBinding> getInterfaceInjector() {
        return this.interfaceBindingValue;
    }

    public Injector<ExecutorService> getExecutorServiceInjector() {
        return this.executorServiceValue;
    }

    public Injector<Integer> getPortInjector() {
        return this.portValue;
    }

    public Injector<ModelController> getModelControllerInjector() {
        return this.modelControllerValue;
    }

    public InjectedValue<String> getTempDirInjector() {
        return this.tempDirValue;
    }
}

