/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.demos;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Queue;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.blocks.executor.ExecutionCompletionService;
import org.jgroups.blocks.executor.ExecutionRunner;
import org.jgroups.blocks.executor.ExecutionService;
import org.jgroups.jmx.JmxConfigurator;
import org.jgroups.util.Streamable;
import org.jgroups.util.Util;

public class ExecutionServiceDemo {
    protected String props;
    protected JChannel ch;
    protected ExecutionService execution_service;
    protected String name;
    protected ExecutionRunner runner;
    protected int size;
    protected boolean printValues;
    protected Random random;
    protected ExecutorService executor;
    protected Queue<Future<?>> queue;

    public ExecutionServiceDemo(String props, String name, int size) {
        this.props = props;
        this.name = name;
        this.queue = new ArrayDeque();
        this.executor = Executors.newCachedThreadPool(new ThreadFactory(){
            AtomicInteger poolNumber = new AtomicInteger();

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r, "Consumer-" + this.poolNumber.getAndIncrement());
                thread.setDaemon(true);
                return thread;
            }
        });
        this.size = size;
    }

    public static void main(String[] args) throws Exception {
        String props = null;
        String name = null;
        String size = "1000";
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-props")) {
                props = args[++i];
                continue;
            }
            if (args[i].equals("-name")) {
                name = args[++i];
                continue;
            }
            ExecutionServiceDemo.help();
            return;
        }
        ExecutionServiceDemo demo = new ExecutionServiceDemo(props, name, Integer.valueOf(size));
        demo.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        this.ch = new JChannel(this.props);
        if (this.name != null) {
            this.ch.setName(this.name);
        }
        this.execution_service = new ExecutionService(this.ch);
        this.runner = new ExecutionRunner(this.ch);
        this.ch.connect("executing-cluster");
        JmxConfigurator.registerChannel(this.ch, Util.getMBeanServer(), "execution-service", this.ch.getClusterName(), true);
        this.queue.add(this.executor.submit(this.runner));
        this.random = new Random();
        this.printValues = false;
        try {
            this.loop();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            Util.close((Channel)this.ch);
        }
    }

    protected void loop() throws Exception {
        String line;
        while (this.ch.isConnected() && !(line = Util.readStringFromStdin(": ")).startsWith("quit") && !line.startsWith("exit")) {
            if (line.startsWith("submit")) {
                Future finalValue;
                int randomNumbers = Integer.parseInt(line.substring("submit".length()).trim());
                byte[] numbers = new byte[randomNumbers];
                for (int i = 0; i < randomNumbers; ++i) {
                    numbers[i] = (byte)this.random.nextInt(256);
                }
                ExecutionCompletionService<byte[]> completion = new ExecutionCompletionService<byte[]>(this.execution_service);
                long beginDistributed = System.nanoTime();
                int chunks = numbers.length / this.size;
                for (int i = 0; i < chunks; ++i) {
                    completion.submit(new SortingByteCallable(numbers, this.size * i, this.size));
                }
                int futureNumber = chunks;
                int leftOver = numbers.length % this.size;
                if (leftOver != 0) {
                    completion.submit(new SortingByteCallable(numbers, numbers.length - leftOver, leftOver));
                    ++futureNumber;
                }
                if (futureNumber > 1) {
                    Future result = null;
                    while (true) {
                        result = completion.take();
                        if (--futureNumber < 1) break;
                        Future result2 = completion.take();
                        completion.submit(new SortingTwoByteCallable((byte[])result.get(), (byte[])result2.get()));
                    }
                    finalValue = result;
                } else {
                    finalValue = completion.take();
                }
                byte[] results = (byte[])finalValue.get();
                long totalDistributed = System.nanoTime() - beginDistributed;
                if (this.printValues) {
                    System.out.println("Original Numbers: " + Arrays.toString(numbers));
                    System.out.println("Sorted values: " + Arrays.toString(results));
                }
                System.out.println("Distributed Sort Took: " + Util.printTime(totalDistributed, TimeUnit.NANOSECONDS));
                long beginLocal = System.nanoTime();
                Arrays.sort(numbers);
                System.out.println("      Local Sort Took: " + Util.printTime(System.nanoTime() - beginLocal, TimeUnit.NANOSECONDS));
                continue;
            }
            if (line.startsWith("consumer")) {
                if (line.contains("start")) {
                    this.queue.add(this.executor.submit(this.runner));
                    System.out.println("Started Consumer - running " + this.queue.size() + " consumers");
                    continue;
                }
                if (line.contains("stop")) {
                    this.queue.remove().cancel(true);
                    System.out.println("Stopped Consumer - running " + this.queue.size() + " consumers");
                    continue;
                }
                System.out.println("Consumers Running Locally: " + this.queue.size());
                continue;
            }
            if (line.startsWith("size")) {
                String thresholdSize = line.substring("size".length()).trim();
                if (thresholdSize.length() > 0) {
                    int size;
                    this.size = size = Integer.parseInt(thresholdSize);
                    System.out.println("Changed sort threshold size to " + size);
                    continue;
                }
                System.out.println("Threshold Size: " + this.size);
                continue;
            }
            if (line.startsWith("print")) {
                this.printValues = !this.printValues;
                System.out.println("Print Arrays: " + this.printValues);
                continue;
            }
            if (line.startsWith("view")) {
                System.out.println("View: " + this.ch.getView());
                continue;
            }
            if (!line.startsWith("help")) continue;
            ExecutionServiceDemo.help();
        }
    }

    protected static void help() {
        System.out.println("\nExecutionServiceDemo [-props properties] [-name name]\nDefault Values:\n\nOne Consumer\nThreshold size: 1000\nPrint disabled\n\nValid commands:\n\nsubmit (amount of numbers to generate)\nconsumer (start) | (stop)\nsize (value)\nprint");
        System.out.println("\nExample:\nsubmit 2000000\nconsumer start\nconsumer stop\nsize 1000000\nprint");
    }

    public static class SortingTwoByteCallable
    implements Callable<byte[]>,
    Streamable {
        protected byte[] bytes1;
        protected byte[] bytes2;

        public SortingTwoByteCallable() {
        }

        public SortingTwoByteCallable(byte[] ints1, byte[] ints2) {
            this.bytes1 = ints1;
            this.bytes2 = ints2;
        }

        @Override
        public byte[] call() throws Exception {
            byte[] results = new byte[this.bytes1.length + this.bytes2.length];
            int i = 0;
            int j = 0;
            while (i < this.bytes1.length && j < this.bytes2.length) {
                if (this.bytes1[i] < this.bytes2[j]) {
                    results[i + j] = this.bytes1[i++];
                    continue;
                }
                results[i + j] = this.bytes2[j++];
            }
            if (i < this.bytes1.length) {
                System.arraycopy(this.bytes1, i, results, i + j, this.bytes1.length - i);
            } else if (j < this.bytes2.length) {
                System.arraycopy(this.bytes2, j, results, i + j, this.bytes2.length - j);
            }
            return results;
        }

        @Override
        public void writeTo(DataOutputStream out) throws IOException {
            out.writeInt(this.bytes1.length);
            out.write(this.bytes1);
            out.writeInt(this.bytes2.length);
            out.write(this.bytes2);
        }

        @Override
        public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
            int size = in.readInt();
            this.bytes1 = new byte[size];
            in.readFully(this.bytes1);
            size = in.readInt();
            this.bytes2 = new byte[size];
            in.readFully(this.bytes2);
        }
    }

    public static class SortingByteCallable
    implements Callable<byte[]>,
    Streamable {
        protected byte[] bytes;
        protected int offset = 0;
        protected int size = 0;

        public SortingByteCallable() {
        }

        public SortingByteCallable(byte[] bytes, int offset, int size) {
            this.bytes = bytes;
            this.offset = offset;
            this.size = size;
        }

        @Override
        public byte[] call() throws Exception {
            Arrays.sort(this.bytes);
            return this.bytes;
        }

        @Override
        public void writeTo(DataOutputStream out) throws IOException {
            out.writeInt(this.size);
            for (int i = 0; i < this.size; ++i) {
                out.writeByte(this.bytes[i + this.offset]);
            }
        }

        @Override
        public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
            int size = in.readInt();
            this.bytes = new byte[size];
            for (int i = 0; i < size; ++i) {
                this.bytes[i] = in.readByte();
            }
        }
    }
}

