/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.as.ee.component.InjectionTargetDescription;
import org.jboss.as.ee.component.ResourceInjection;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.value.Value;

class JndiInjectionPointStore {
    private final Map<String, List<JndiInjectedValue>> injectionPoints;
    private final Set<ServiceName> serviceNames = new HashSet<ServiceName>();

    public JndiInjectionPointStore(Map<String, List<JndiInjectedValue>> injectionPoints) {
        this.injectionPoints = new HashMap<String, List<JndiInjectedValue>>(injectionPoints);
    }

    public JndiInjectionPointStore(JndiInjectionPointStore parent) {
        this(parent.injectionPoints);
    }

    public JndiInjectionPointStore() {
        this.injectionPoints = new HashMap<String, List<JndiInjectedValue>>();
    }

    public void addInjectedValue(InjectionTargetDescription injectionTarget, Value<ManagedReferenceFactory> referenceFactory, ServiceName serviceName) {
        JndiInjectedValue value = new JndiInjectedValue(injectionTarget, referenceFactory, serviceName);
        String clazz = value.getInjectionTarget().getClassName();
        if (!this.injectionPoints.containsKey(clazz)) {
            this.injectionPoints.put(clazz, new ArrayList());
        }
        this.injectionPoints.get(clazz).add(value);
        if (value.getServiceName() != null) {
            this.serviceNames.add(value.getServiceName());
        }
    }

    public List<ResourceInjection> applyInjections(Class<?> clazz, DeploymentReflectionIndex deploymentReflectionIndex) {
        ArrayList<ResourceInjection> resourceInjections = new ArrayList<ResourceInjection>();
        for (Class<?> type = clazz; type != Object.class && type != null; type = type.getSuperclass()) {
            List<JndiInjectedValue> injectedValues = this.injectionPoints.get(type.getName());
            if (injectedValues == null) continue;
            for (JndiInjectedValue value : injectedValues) {
                resourceInjections.add(ResourceInjection.Factory.create(value.getInjectionTarget(), clazz, deploymentReflectionIndex, value.getReferenceFactory()));
            }
        }
        return resourceInjections;
    }

    public Set<ServiceName> getServiceNames() {
        return Collections.unmodifiableSet(this.serviceNames);
    }

    private class JndiInjectedValue {
        private final InjectionTargetDescription injectionTarget;
        private final Value<ManagedReferenceFactory> referenceFactory;
        private final ServiceName serviceName;

        public JndiInjectedValue(InjectionTargetDescription injectionTarget, Value<ManagedReferenceFactory> referenceFactory, ServiceName serviceName) {
            this.referenceFactory = referenceFactory;
            this.injectionTarget = injectionTarget;
            this.serviceName = serviceName;
        }

        public InjectionTargetDescription getInjectionTarget() {
            return this.injectionTarget;
        }

        public Value<ManagedReferenceFactory> getReferenceFactory() {
            return this.referenceFactory;
        }

        public ServiceName getServiceName() {
            return this.serviceName;
        }
    }
}

