/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.sun.net.httpserver;

import com.sun.net.httpserver.Authenticator;
import com.sun.net.httpserver.Filter;
import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.sun.net.httpserver.ExchangeImpl;

public class AuthFilter
extends Filter {
    private Authenticator authenticator;

    public AuthFilter(Authenticator authenticator) {
        this.authenticator = authenticator;
    }

    public String description() {
        return "Authentication filter";
    }

    public void setAuthenticator(Authenticator a) {
        this.authenticator = a;
    }

    public void consumeInput(HttpExchange t) throws IOException {
        InputStream i = t.getRequestBody();
        byte[] b = new byte[4096];
        while (i.read(b) != -1) {
        }
        i.close();
    }

    public void doFilter(HttpExchange t, Filter.Chain chain) throws IOException {
        if (this.authenticator != null) {
            Authenticator.Result r = this.authenticator.authenticate(t);
            if (r instanceof Authenticator.Success) {
                Authenticator.Success s = (Authenticator.Success)r;
                ExchangeImpl e = ExchangeImpl.get(t);
                e.setPrincipal(s.getPrincipal());
                chain.doFilter(t);
            } else if (r instanceof Authenticator.Retry) {
                Authenticator.Retry ry = (Authenticator.Retry)r;
                this.consumeInput(t);
                t.sendResponseHeaders(ry.getResponseCode(), -1L);
            } else if (r instanceof Authenticator.Failure) {
                Authenticator.Failure f = (Authenticator.Failure)r;
                this.consumeInput(t);
                t.sendResponseHeaders(f.getResponseCode(), -1L);
            }
        } else {
            chain.doFilter(t);
        }
    }
}

