/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.connectionmanager.pool;

import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.RetryableException;
import javax.security.auth.Subject;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.jca.common.JBossResourceException;
import org.jboss.jca.core.api.connectionmanager.pool.PoolConfiguration;
import org.jboss.jca.core.connectionmanager.listener.ConnectionListener;
import org.jboss.jca.core.connectionmanager.listener.ConnectionListenerFactory;
import org.jboss.jca.core.connectionmanager.pool.SubPoolContext;
import org.jboss.jca.core.connectionmanager.pool.api.Pool;
import org.jboss.jca.core.connectionmanager.pool.mcp.ManagedConnectionPool;
import org.jboss.jca.core.spi.transaction.TransactionIntegration;
import org.jboss.jca.core.spi.transaction.local.TransactionLocal;
import org.jboss.logging.Logger;

public abstract class AbstractPool
implements Pool {
    protected final Logger log = Logger.getLogger(this.getClass());
    private boolean trace = false;
    private final ConcurrentMap<Object, SubPoolContext> subPools = new ConcurrentHashMap<Object, SubPoolContext>();
    private final ManagedConnectionFactory mcf;
    private ConnectionListenerFactory clf;
    private final PoolConfiguration poolConfiguration;
    private final boolean noTxSeparatePools;
    private String poolName;

    protected AbstractPool(ManagedConnectionFactory mcf, PoolConfiguration pc, boolean noTxSeparatePools) {
        if (mcf == null) {
            throw new IllegalArgumentException("MCF is null");
        }
        if (pc == null) {
            throw new IllegalArgumentException("PoolConfiguration is null");
        }
        this.mcf = mcf;
        this.poolConfiguration = pc;
        this.noTxSeparatePools = noTxSeparatePools;
        this.trace = this.log.isTraceEnabled();
    }

    @Override
    public void setName(String poolName) {
        this.poolName = poolName;
    }

    public String getName() {
        return this.poolName;
    }

    protected abstract Object getKey(Subject var1, ConnectionRequestInfo var2, boolean var3) throws ResourceException;

    protected SubPoolContext getSubPool(Object key, Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        SubPoolContext newSubPoolContext;
        SubPoolContext subPoolContext = (SubPoolContext)this.subPools.get(key);
        if (subPoolContext == null && (subPoolContext = this.subPools.putIfAbsent(key, newSubPoolContext = new SubPoolContext(this.getTransactionIntegration(), this.mcf, this.clf, subject, cri, this.poolConfiguration, this, this.log))) == null) {
            subPoolContext = newSubPoolContext;
        }
        return subPoolContext;
    }

    protected TransactionIntegration getTransactionIntegration() {
        if (this.clf != null) {
            return this.clf.getTransactionIntegration();
        }
        return null;
    }

    protected TransactionManager getTransactionManager() {
        if (this.clf != null) {
            return this.clf.getTransactionManager();
        }
        return null;
    }

    @Override
    public void emptySubPool(ManagedConnectionPool pool) {
        if (pool != null) {
            Iterator itSubPoolContexts = this.subPools.values().iterator();
            SubPoolContext other = null;
            while (itSubPoolContexts.hasNext()) {
                other = (SubPoolContext)itSubPoolContexts.next();
                if (other.getSubPool() != pool || !pool.isEmpty()) continue;
                pool.shutdown();
                itSubPoolContexts.remove();
                break;
            }
        }
    }

    @Override
    public void flush() {
        Iterator itSubPoolContexts = this.subPools.values().iterator();
        SubPoolContext subPoolContext = null;
        while (itSubPoolContexts.hasNext()) {
            subPoolContext = (SubPoolContext)itSubPoolContexts.next();
            subPoolContext.getSubPool().flush();
        }
        this.subPools.clear();
    }

    @Override
    public ConnectionListener getConnection(Transaction trackByTransaction, Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        ConnectionListener cl = null;
        boolean separateNoTx = false;
        if (this.noTxSeparatePools) {
            separateNoTx = this.clf.isTransactional();
        }
        Object key = this.getKey(subject, cri, separateNoTx);
        SubPoolContext subPoolContext = this.getSubPool(key, subject, cri);
        ManagedConnectionPool imcp = subPoolContext.getSubPool();
        TransactionLocal trackByTx = subPoolContext.getTrackByTx();
        if (trackByTransaction == null || trackByTx == null) {
            cl = this.getSimpleConnection(subject, cri, subPoolContext);
        }
        if (cl == null) {
            cl = this.getTransactionOldConnection(trackByTx, trackByTransaction);
        }
        if (cl == null) {
            cl = this.getTransactionNewConnection(trackByTx, trackByTransaction, imcp, subject, cri);
        }
        return cl;
    }

    private ConnectionListener getSimpleConnection(Subject subject, ConnectionRequestInfo cri, SubPoolContext subPoolContext) throws ResourceException {
        ConnectionListener cl = null;
        ManagedConnectionPool imcp = null;
        try {
            imcp = subPoolContext.getSubPool();
            cl = imcp.getConnection(subject, cri);
            if (this.trace) {
                this.dump("Got connection from pool : " + cl);
            }
            return cl;
        }
        catch (ResourceException re) {
            if (re instanceof RetryableException) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Got a RetryableException - trying to reinitialize the pool");
                }
                if (!(imcp = subPoolContext.getSubPool()).isRunning()) {
                    imcp.reenable();
                }
                cl = imcp.getConnection(subject, cri);
                if (this.trace) {
                    this.dump("Got connection from pool (retried) " + cl);
                }
                return cl;
            }
            throw re;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ConnectionListener getTransactionOldConnection(TransactionLocal trackByTx, Transaction trackByTransaction) throws ResourceException {
        ConnectionListener cl = null;
        try {
            trackByTx.lock(trackByTransaction);
        }
        catch (Throwable t) {
            JBossResourceException.rethrowAsResourceException((String)("Unable to get connection from the pool for tx=" + trackByTransaction), (Throwable)t);
        }
        try {
            cl = (ConnectionListener)trackByTx.get(trackByTransaction);
            if (cl != null) {
                if (this.trace) {
                    this.dump("Previous connection tracked by transaction " + cl + " tx=" + trackByTransaction);
                }
                ConnectionListener connectionListener = cl;
                return connectionListener;
            }
        }
        finally {
            trackByTx.unlock(trackByTransaction);
        }
        return cl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ConnectionListener getTransactionNewConnection(TransactionLocal trackByTx, Transaction trackByTransaction, ManagedConnectionPool mcp, Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        ConnectionListener cl = null;
        cl = mcp.getConnection(subject, cri);
        if (this.trace) {
            this.dump("Got connection from pool tracked by transaction " + cl + " tx=" + trackByTransaction);
        }
        try {
            trackByTx.lock(trackByTransaction);
        }
        catch (Throwable t) {
            mcp.returnConnection(cl, false);
            if (this.trace) {
                this.dump("Had to return connection tracked by transaction " + cl + " tx=" + trackByTransaction + " error=" + t.getMessage());
            }
            JBossResourceException.rethrowAsResourceException((String)("Unable to get connection from the pool for tx=" + trackByTransaction), (Throwable)t);
        }
        try {
            ConnectionListener other = (ConnectionListener)trackByTx.get(trackByTransaction);
            if (other != null) {
                mcp.returnConnection(cl, false);
                if (this.trace) {
                    this.dump("Another thread already got a connection tracked by transaction " + other + " tx=" + trackByTransaction);
                }
                cl = other;
            }
            cl.setTrackByTx(true);
            trackByTx.set((Object)cl);
            if (this.trace) {
                this.dump("Using connection from pool tracked by transaction " + cl + " tx=" + trackByTransaction);
            }
        }
        finally {
            trackByTx.unlock(trackByTransaction);
        }
        return cl;
    }

    @Override
    public ManagedConnectionFactory getManagedConnectionFactory() {
        return this.mcf;
    }

    @Override
    public void returnConnection(ConnectionListener cl, boolean kill) throws ResourceException {
        cl.setTrackByTx(false);
        ManagedConnectionPool mcp = (ManagedConnectionPool)cl.getContext();
        mcp.returnConnection(cl, kill);
        if (this.trace) {
            this.dump("Returning connection to pool " + cl);
        }
    }

    @Override
    public void setConnectionListenerFactory(ConnectionListenerFactory clf) {
        this.clf = clf;
    }

    @Override
    public void shutdown() {
        this.flush();
    }

    private void dump(String info) {
        if (this.trace) {
            StringBuffer toLog = new StringBuffer(100);
            toLog.append(info);
            this.log.trace((Object)toLog);
        }
    }

    final ConcurrentMap<Object, SubPoolContext> getSubPools() {
        return this.subPools;
    }
}

