/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.connectionmanager.pool.mcp;

import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;
import javax.security.auth.Subject;
import org.jboss.jca.core.api.connectionmanager.pool.PoolConfiguration;
import org.jboss.jca.core.connectionmanager.listener.ConnectionListenerFactory;
import org.jboss.jca.core.connectionmanager.pool.SubPoolContext;
import org.jboss.jca.core.connectionmanager.pool.api.Pool;
import org.jboss.jca.core.connectionmanager.pool.mcp.ManagedConnectionPool;
import org.jboss.jca.core.connectionmanager.pool.mcp.SecurityActions;
import org.jboss.logging.Logger;

public class ManagedConnectionPoolFactory {
    private static final String DEFAULT_IMPLEMENTATION = "org.jboss.jca.core.connectionmanager.pool.mcp.SemaphoreArrayListManagedConnectionPool";
    private static Class<?> defaultImplementation;

    public ManagedConnectionPool create(ManagedConnectionFactory mcf, ConnectionListenerFactory clf, Subject subject, ConnectionRequestInfo cri, PoolConfiguration pc, Pool p, SubPoolContext spc, Logger log) throws Throwable {
        ManagedConnectionPool mcp = (ManagedConnectionPool)defaultImplementation.newInstance();
        return this.init(mcp, mcf, clf, subject, cri, pc, p, spc, log);
    }

    public ManagedConnectionPool create(String strategy, ManagedConnectionFactory mcf, ConnectionListenerFactory clf, Subject subject, ConnectionRequestInfo cri, PoolConfiguration pc, Pool p, SubPoolContext spc, Logger log) throws Throwable {
        Class<?> clz = Class.forName(strategy, true, ManagedConnectionPoolFactory.class.getClassLoader());
        ManagedConnectionPool mcp = (ManagedConnectionPool)clz.newInstance();
        return this.init(mcp, mcf, clf, subject, cri, pc, p, spc, log);
    }

    private ManagedConnectionPool init(ManagedConnectionPool mcp, ManagedConnectionFactory mcf, ConnectionListenerFactory clf, Subject subject, ConnectionRequestInfo cri, PoolConfiguration pc, Pool p, SubPoolContext spc, Logger log) {
        mcp.initialize(mcf, clf, subject, cri, pc, p, spc, log);
        return mcp;
    }

    static {
        String clz = SecurityActions.getSystemProperty("ironjacamar.mcp");
        clz = clz != null && !clz.trim().equals("") ? clz.trim() : DEFAULT_IMPLEMENTATION;
        try {
            defaultImplementation = Class.forName(clz, true, ManagedConnectionPoolFactory.class.getClassLoader());
        }
        catch (Throwable t) {
            throw new RuntimeException("Unable to load default managed connection pool implementation: " + clz);
        }
    }
}

