/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.connectionmanager.pool.mcp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.RetryableUnavailableException;
import javax.resource.spi.ValidatingManagedConnectionFactory;
import javax.security.auth.Subject;
import org.jboss.jca.common.JBossResourceException;
import org.jboss.jca.core.api.connectionmanager.pool.PoolConfiguration;
import org.jboss.jca.core.connectionmanager.listener.ConnectionListener;
import org.jboss.jca.core.connectionmanager.listener.ConnectionListenerFactory;
import org.jboss.jca.core.connectionmanager.listener.ConnectionState;
import org.jboss.jca.core.connectionmanager.pool.SubPoolContext;
import org.jboss.jca.core.connectionmanager.pool.api.Pool;
import org.jboss.jca.core.connectionmanager.pool.idle.IdleRemover;
import org.jboss.jca.core.connectionmanager.pool.mcp.ManagedConnectionPool;
import org.jboss.jca.core.connectionmanager.pool.mcp.PoolFiller;
import org.jboss.jca.core.connectionmanager.pool.validator.ConnectionValidator;
import org.jboss.logging.Logger;
import org.jboss.util.UnreachableStatementException;

public class SemaphoreArrayListManagedConnectionPool
implements ManagedConnectionPool {
    private Logger log;
    private boolean trace;
    private ManagedConnectionFactory mcf;
    private ConnectionListenerFactory clf;
    private Subject defaultSubject;
    private ConnectionRequestInfo defaultCri;
    private PoolConfiguration poolConfiguration;
    private Pool pool;
    private int maxSize;
    private ArrayList<ConnectionListener> cls;
    private Semaphore permits;
    private ConcurrentMap<ConnectionListener, ConnectionListener> clPermits = new ConcurrentHashMap<ConnectionListener, ConnectionListener>();
    private SubPoolContext subPool;
    private HashSet<ConnectionListener> checkedOut = new HashSet();
    private AtomicBoolean started = new AtomicBoolean(false);
    private AtomicBoolean shutdown = new AtomicBoolean(false);
    private volatile int maxUsedConnections = 0;

    @Override
    public void initialize(ManagedConnectionFactory mcf, ConnectionListenerFactory clf, Subject subject, ConnectionRequestInfo cri, PoolConfiguration pc, Pool p, SubPoolContext spc, Logger log) {
        this.mcf = mcf;
        this.clf = clf;
        this.defaultSubject = subject;
        this.defaultCri = cri;
        this.poolConfiguration = pc;
        this.maxSize = pc.getMaxSize();
        this.pool = p;
        this.subPool = spc;
        this.log = log;
        this.trace = log.isTraceEnabled();
        this.cls = new ArrayList(this.maxSize);
        this.permits = new Semaphore(this.maxSize, true);
        if (pc.isPrefill()) {
            PoolFiller.fillPool(this);
        }
        this.reenable();
    }

    @Override
    public SubPoolContext getSubPool() {
        return this.subPool;
    }

    @Override
    public boolean isRunning() {
        return !this.shutdown.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        ArrayList<ConnectionListener> arrayList = this.cls;
        synchronized (arrayList) {
            return this.cls.size() == 0 && this.checkedOut.size() == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isSize(int size) {
        ArrayList<ConnectionListener> arrayList = this.cls;
        synchronized (arrayList) {
            return this.cls.size() + this.checkedOut.size() >= size;
        }
    }

    @Override
    public void reenable() {
        if (this.poolConfiguration.getIdleTimeout() > 0L) {
            IdleRemover.registerPool(this, this.poolConfiguration.getIdleTimeout());
        }
        if (this.poolConfiguration.isBackgroundValidation() && this.poolConfiguration.getBackgroundValidationInterval() > 0L) {
            this.log.debug((Object)("Registering for background validation at interval " + this.poolConfiguration.getBackgroundValidationInterval()));
            ConnectionValidator.registerPool(this, this.poolConfiguration.getBackgroundValidationInterval());
        }
        this.shutdown.set(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectionListener getConnection(Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        subject = subject == null ? this.defaultSubject : subject;
        cri = cri == null ? this.defaultCri : cri;
        long startWait = System.currentTimeMillis();
        try {
            if (this.permits.tryAcquire(this.poolConfiguration.getBlockingTimeout(), TimeUnit.MILLISECONDS)) {
                ConnectionListener cl = null;
                do {
                    ArrayList<ConnectionListener> clsSize2;
                    ArrayList<ConnectionListener> arrayList = this.cls;
                    synchronized (arrayList) {
                        if (this.shutdown.get()) {
                            this.permits.release();
                            throw new RetryableUnavailableException("The pool has been shutdown");
                        }
                        int clsSize2 = this.cls.size();
                        if (clsSize2 > 0) {
                            cl = this.cls.remove(clsSize2 - 1);
                            this.checkedOut.add(cl);
                            int size = this.maxSize - this.permits.availablePermits();
                            if (size > this.maxUsedConnections) {
                                this.maxUsedConnections = size;
                            }
                        }
                    }
                    if (cl == null) continue;
                    try {
                        ManagedConnection matchedMC = this.mcf.matchManagedConnections(Collections.singleton(cl.getManagedConnection()), subject, cri);
                        if (matchedMC != null) {
                            if (this.trace) {
                                this.log.trace((Object)("supplying ManagedConnection from pool: " + cl));
                            }
                            this.clPermits.put(cl, cl);
                            return cl;
                        }
                        this.log.warn((Object)("Destroying connection that could not be successfully matched: " + cl));
                        clsSize2 = this.cls;
                        synchronized (clsSize2) {
                            this.checkedOut.remove(cl);
                        }
                        this.doDestroy(cl);
                        cl = null;
                    }
                    catch (Throwable t) {
                        this.log.warn((Object)("Throwable while trying to match ManagedConnection, destroying connection: " + cl), t);
                        clsSize2 = this.cls;
                        synchronized (clsSize2) {
                            this.checkedOut.remove(cl);
                        }
                        this.doDestroy(cl);
                        cl = null;
                    }
                    if (!this.poolConfiguration.isUseFastFail()) continue;
                    this.log.trace((Object)"Fast failing for connection attempt. No more attempts will be made to acquire connection from pool and a new connection will be created immeadiately");
                    break;
                } while (this.cls.size() > 0);
                try {
                    cl = this.createConnectionEventListener(subject, cri);
                    ArrayList<ConnectionListener> t = this.cls;
                    synchronized (t) {
                        this.checkedOut.add(cl);
                        int size = this.maxSize - this.permits.availablePermits();
                        if (size > this.maxUsedConnections) {
                            this.maxUsedConnections = size;
                        }
                    }
                    if (!this.started.getAndSet(true) && this.poolConfiguration.getMinSize() > 0) {
                        PoolFiller.fillPool(this);
                    }
                    if (this.trace) {
                        this.log.trace((Object)("supplying new ManagedConnection: " + cl));
                    }
                    this.clPermits.put(cl, cl);
                    return cl;
                }
                catch (Throwable t) {
                    this.log.warn((Object)("Throwable while attempting to get a new connection: " + cl), t);
                    ArrayList<ConnectionListener> arrayList = this.cls;
                    synchronized (arrayList) {
                        this.checkedOut.remove(cl);
                    }
                    this.permits.release();
                    JBossResourceException.rethrowAsResourceException((String)("Unexpected throwable while trying to create a connection: " + cl), (Throwable)t);
                    throw new UnreachableStatementException();
                }
            }
            throw new ResourceException("No ManagedConnections available within configured blocking timeout ( " + this.poolConfiguration.getBlockingTimeout() + " [ms] )");
        }
        catch (InterruptedException ie) {
            long end = System.currentTimeMillis() - startWait;
            throw new ResourceException("Interrupted while requesting permit! Waited " + end + " ms");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void returnConnection(ConnectionListener cl, boolean kill) {
        ArrayList<ConnectionListener> arrayList = this.cls;
        synchronized (arrayList) {
            if (cl.getState() == ConnectionState.DESTROYED) {
                if (this.trace) {
                    this.log.trace((Object)("ManagedConnection is being returned after it was destroyed" + cl));
                }
                if (this.clPermits.containsKey(cl)) {
                    this.clPermits.remove(cl);
                    this.permits.release();
                }
                return;
            }
        }
        if (this.trace) {
            this.log.trace((Object)("putting ManagedConnection back into pool kill=" + kill + " cl=" + cl));
        }
        try {
            cl.getManagedConnection().cleanup();
        }
        catch (ResourceException re) {
            this.log.warn((Object)("ResourceException cleaning up ManagedConnection: " + cl), (Throwable)re);
            kill = true;
        }
        arrayList = this.cls;
        synchronized (arrayList) {
            if (cl.getState() == ConnectionState.DESTROY || cl.getState() == ConnectionState.DESTROYED) {
                kill = true;
            }
            this.checkedOut.remove(cl);
            if (!kill && this.isSize(this.poolConfiguration.getMaxSize() + 1)) {
                this.log.warn((Object)("Destroying returned connection, maximum pool size exceeded " + cl));
                kill = true;
            }
            if (kill) {
                this.cls.remove(cl);
            } else {
                cl.used();
                if (!this.cls.contains(cl)) {
                    this.cls.add(cl);
                } else {
                    this.log.warn((Object)("Attempt to return connection twice (ignored): " + cl), new Throwable("STACKTRACE"));
                }
            }
            if (this.clPermits.containsKey(cl)) {
                this.clPermits.remove(cl);
                this.permits.release();
            }
        }
        if (kill) {
            if (this.trace) {
                this.log.trace((Object)("Destroying returned connection " + cl));
            }
            this.doDestroy(cl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        ConnectionListener cl;
        ArrayList<ConnectionListener> destroy = null;
        ArrayList<ConnectionListener> arrayList = this.cls;
        synchronized (arrayList) {
            if (this.trace) {
                this.log.trace((Object)("Flushing pool checkedOut=" + this.checkedOut + " inPool=" + this.cls));
            }
            for (ConnectionListener cl2 : this.checkedOut) {
                if (this.trace) {
                    this.log.trace((Object)("Flush marking checked out connection for destruction " + cl2));
                }
                cl2.setState(ConnectionState.DESTROY);
            }
            while (this.cls.size() > 0) {
                cl = this.cls.remove(0);
                if (destroy == null) {
                    destroy = new ArrayList<ConnectionListener>(1);
                }
                destroy.add(cl);
            }
        }
        if (destroy != null) {
            for (int i = 0; i < destroy.size(); ++i) {
                cl = (ConnectionListener)destroy.get(i);
                if (this.trace) {
                    this.log.trace((Object)("Destroying flushed connection " + cl));
                }
                this.doDestroy(cl);
            }
            if (!this.shutdown.get() && this.poolConfiguration.getMinSize() > 0) {
                PoolFiller.fillPool(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeIdleConnections() {
        ConnectionListener cl;
        ArrayList<ConnectionListener> destroy = null;
        long timeout = System.currentTimeMillis() - this.poolConfiguration.getIdleTimeout();
        while (true) {
            ArrayList<ConnectionListener> arrayList = this.cls;
            synchronized (arrayList) {
                if (this.cls.size() == 0) {
                    break;
                }
                cl = this.cls.get(0);
                if (cl.isTimedOut(timeout) && this.shouldRemove()) {
                    this.cls.remove(0);
                    if (destroy == null) {
                        destroy = new ArrayList<ConnectionListener>(1);
                    }
                } else {
                    break;
                }
                destroy.add(cl);
            }
        }
        if (destroy != null) {
            for (int i = 0; i < destroy.size(); ++i) {
                cl = (ConnectionListener)destroy.get(i);
                if (this.trace) {
                    this.log.trace((Object)("Destroying timedout connection " + cl));
                }
                this.doDestroy(cl);
            }
            if (!this.shutdown.get() && this.poolConfiguration.getMinSize() > 0) {
                PoolFiller.fillPool(this);
            }
            if (this.pool != null) {
                this.pool.emptySubPool(this);
            }
        }
    }

    @Override
    public void shutdown() {
        this.shutdown.set(true);
        IdleRemover.unregisterPool(this);
        ConnectionValidator.unregisterPool(this);
        this.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fillToMin() {
        while (true) {
            try {
                while (true) {
                    if (!this.permits.tryAcquire(this.poolConfiguration.getBlockingTimeout(), TimeUnit.MILLISECONDS)) {
                        continue;
                    }
                    try {
                        if (this.shutdown.get()) {
                            return;
                        }
                        if (this.isSize(this.poolConfiguration.getMinSize())) {
                            return;
                        }
                        try {
                            ConnectionListener cl = this.createConnectionEventListener(this.defaultSubject, this.defaultCri);
                            ArrayList<ConnectionListener> arrayList = this.cls;
                            synchronized (arrayList) {
                                if (this.trace) {
                                    this.log.trace((Object)("Filling pool cl=" + cl));
                                }
                                this.cls.add(cl);
                                continue;
                            }
                        }
                        catch (ResourceException re) {
                            this.log.warn((Object)"Unable to fill pool ", (Throwable)re);
                            this.permits.release();
                            return;
                        }
                    }
                    finally {
                        this.permits.release();
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException ignored) {
                this.log.trace((Object)"Interrupted while requesting permit in fillToMin");
                continue;
            }
            break;
        }
    }

    private ConnectionListener createConnectionEventListener(Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        ManagedConnection mc = this.mcf.createManagedConnection(subject, cri);
        try {
            return this.clf.createConnectionListener(mc, this);
        }
        catch (ResourceException re) {
            mc.destroy();
            throw re;
        }
    }

    private void doDestroy(ConnectionListener cl) {
        if (cl.getState() == ConnectionState.DESTROYED) {
            if (this.trace) {
                this.log.trace((Object)("ManagedConnection is already destroyed " + cl));
            }
            return;
        }
        cl.setState(ConnectionState.DESTROYED);
        try {
            cl.getManagedConnection().destroy();
        }
        catch (Throwable t) {
            this.log.debug((Object)("Exception destroying ManagedConnection " + cl), t);
        }
    }

    private boolean shouldRemove() {
        boolean remove = true;
        if (this.poolConfiguration.isStrictMin()) {
            remove = this.isSize(this.poolConfiguration.getMinSize() + 1);
            if (this.trace) {
                this.log.trace((Object)("StrictMin is active. Current connection will be removed is " + remove));
            }
        }
        return remove;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void validateConnections() throws Exception {
        if (this.trace) {
            this.log.trace((Object)("Attempting to  validate connections for pool " + this));
        }
        if (this.permits.tryAcquire(this.poolConfiguration.getBlockingTimeout(), TimeUnit.MILLISECONDS) == false) return;
        anyDestroyed = false;
        while (true) lbl-1000:
        // 6 sources

        {
            cl = null;
            destroyed = false;
            var4_4 = this.cls;
            synchronized (var4_4) {
                if (this.cls.size() == 0) {
                    return;
                }
                cl = this.removeForFrequencyCheck();
                ** if (cl != null) goto lbl16
            }
lbl15:
            // 1 sources

            return;
lbl16:
            // 1 sources

            try {
                candidateSet = Collections.singleton(cl.getManagedConnection());
                if (this.mcf instanceof ValidatingManagedConnectionFactory) {
                    vcf = (ValidatingManagedConnectionFactory)this.mcf;
                    if ((candidateSet = vcf.getInvalidConnections(candidateSet)) == null || candidateSet.size() <= 0 || cl.getState() == ConnectionState.DESTROY) ** GOTO lbl-1000
                    this.doDestroy(cl);
                    destroyed = true;
                    anyDestroyed = true;
                }
                this.log.warn((Object)"Warning: background validation was specified with a non compliant ManagedConnectionFactory interface.");
            }
            finally {
                if (destroyed) ** GOTO lbl-1000
                var4_4 = this.cls;
                synchronized (var4_4) {
                    this.returnForFrequencyCheck(cl);
                }
                continue;
            }
            break;
        }
        ** GOTO lbl-1000
        finally {
            this.permits.release();
            if (anyDestroyed && !this.shutdown.get() && this.poolConfiguration.getMinSize() > 0) {
                PoolFiller.fillPool(this);
            }
        }
    }

    private ConnectionListener removeForFrequencyCheck() {
        this.log.debug((Object)"Checking for connection within frequency");
        ConnectionListener cl2 = null;
        for (ConnectionListener cl2 : this.cls) {
            long lastCheck = cl2.getLastValidatedTime();
            if (System.currentTimeMillis() - lastCheck >= this.poolConfiguration.getBackgroundValidationInterval()) {
                this.cls.remove(cl2);
                break;
            }
            cl2 = null;
        }
        return cl2;
    }

    private void returnForFrequencyCheck(ConnectionListener cl) {
        this.log.debug((Object)"Returning for connection within frequency");
        cl.setLastValidatedTime(System.currentTimeMillis());
        this.cls.add(cl);
    }
}

