/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.recovery;

import java.lang.reflect.Method;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import org.jboss.jca.core.spi.recovery.RecoveryPlugin;
import org.jboss.logging.Logger;

public class DefaultRecoveryPlugin
implements RecoveryPlugin {
    private static Logger log = Logger.getLogger(DefaultRecoveryPlugin.class);

    public boolean isValid(Object c) throws ResourceException {
        if (c != null) {
            try {
                Method method = c.getClass().getMethod("isValid", Integer.TYPE);
                method.setAccessible(true);
                Boolean b = (Boolean)method.invoke(c, new Integer(5));
                return b;
            }
            catch (Throwable t) {
                log.debugf("No isValid(int) method defined on connection interface (%s)", (Object)c.getClass().getName());
            }
        }
        return false;
    }

    public void close(Object c) throws ResourceException {
        if (c != null) {
            if (c instanceof Connection) {
                try {
                    Connection cci = (Connection)c;
                    cci.close();
                }
                catch (ResourceException re) {
                    log.warn((Object)"Error during connection close", (Throwable)re);
                    throw new ResourceException("Error during connection close", (Throwable)re);
                }
            }
            try {
                Method method = c.getClass().getMethod("close", new Class[]{null});
                method.setAccessible(true);
                method.invoke(c, new Object[]{null});
            }
            catch (Throwable t) {
                log.debug((Object)"Error during connection close()", t);
                throw new ResourceException("Error during connection close()", t);
            }
        }
    }
}

