/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.tx.jbossts;

import javax.resource.ResourceException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.jboss.jca.core.api.connectionmanager.ConnectionManager;
import org.jboss.jca.core.api.connectionmanager.listener.ConnectionListener;
import org.jboss.jca.core.spi.transaction.local.LocalXAException;
import org.jboss.jca.core.spi.transaction.local.LocalXAResource;
import org.jboss.logging.Logger;

public class LocalXAResourceImpl
implements LocalXAResource {
    private static Logger log = Logger.getLogger(LocalXAResourceImpl.class);
    private ConnectionListener cl;
    private ConnectionManager connectionManager = null;
    private boolean warned = false;
    private Xid currentXid;

    public void setConnectionManager(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public void setConnectionListener(ConnectionListener cl) {
        this.cl = cl;
    }

    public void start(Xid xid, int flags) throws XAException {
        log.tracef("start(%s, %s)", (Object)xid, (Object)flags);
        if (this.currentXid != null && flags == 0) {
            throw new LocalXAException("Trying to start a new tx when old is not complete! old: " + this.currentXid + ", new " + xid + ", flags " + flags, -6);
        }
        if (this.currentXid == null && flags != 0) {
            throw new LocalXAException("Trying to start a new tx with wrong flags!  new " + xid + ", flags " + flags, -6);
        }
        if (this.currentXid == null) {
            try {
                this.cl.getManagedConnection().getLocalTransaction().begin();
            }
            catch (ResourceException re) {
                throw new LocalXAException("Error trying to start local tx: ", -3, (Throwable)re);
            }
            catch (Throwable t) {
                throw new LocalXAException("Throwable trying to start local transaction!", -3, t);
            }
            this.currentXid = xid;
        }
    }

    public void end(Xid xid, int flags) throws XAException {
        log.tracef("end(%s,%s)", (Object)xid, (Object)flags);
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        if (!xid.equals(this.currentXid)) {
            throw new LocalXAException("Wrong xid in commit: expected: " + this.currentXid + ", got: " + xid, -6);
        }
        this.currentXid = null;
        try {
            this.cl.getManagedConnection().getLocalTransaction().commit();
        }
        catch (ResourceException re) {
            this.connectionManager.returnManagedConnection(this.cl, true);
            throw new LocalXAException("Could not commit local tx", 100, (Throwable)re);
        }
    }

    public void forget(Xid xid) throws XAException {
        throw new LocalXAException("Forget not supported in local tx", -3);
    }

    public int getTransactionTimeout() throws XAException {
        return 0;
    }

    public boolean isSameRM(XAResource xaResource) throws XAException {
        return xaResource == this;
    }

    public int prepare(Xid xid) throws XAException {
        if (!this.warned) {
            log.warn((Object)"Prepare called on a local tx. Use of local transactions on a jta transaction with more than one branch may result in inconsistent data in some cases of failure.");
        }
        this.warned = true;
        return 0;
    }

    public Xid[] recover(int flag) throws XAException {
        throw new LocalXAException("No recover with local-tx only resource managers", -3);
    }

    public void rollback(Xid xid) throws XAException {
        if (!xid.equals(this.currentXid)) {
            throw new LocalXAException("Wrong xid in rollback: expected: " + this.currentXid + ", got: " + xid, -6);
        }
        this.currentXid = null;
        try {
            this.cl.getManagedConnection().getLocalTransaction().rollback();
        }
        catch (ResourceException re) {
            this.connectionManager.returnManagedConnection(this.cl, true);
            throw new LocalXAException("Could not rollback local tx", -3, (Throwable)re);
        }
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        return false;
    }
}

