/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.tx.jbossts;

import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.jboss.jca.core.spi.transaction.TransactionIntegration;
import org.jboss.jca.core.spi.transaction.local.TransactionLocalDelegate;
import org.jboss.tm.TransactionLocal;

public class TransactionLocalImpl
extends TransactionLocal
implements org.jboss.jca.core.spi.transaction.local.TransactionLocal {
    private static final Object NULL_VALUE = new Object();
    private final TransactionIntegration transactionIntegration;
    private final TransactionLocalDelegate delegate;

    public TransactionLocalImpl(TransactionIntegration ti) {
        super(ti.getTransactionManager());
        if (ti.getTransactionLocalDelegate() == null) {
            throw new IllegalArgumentException("Null transaction local delegate");
        }
        this.transactionIntegration = ti;
        this.delegate = ti.getTransactionLocalDelegate();
    }

    public void lock() throws InterruptedException {
        this.lock(this.getTransaction());
    }

    public void lock(Transaction transaction) throws InterruptedException {
        if (transaction == null) {
            return;
        }
        this.delegate.lock((org.jboss.jca.core.spi.transaction.local.TransactionLocal)this, transaction);
    }

    public void unlock() {
        this.unlock(this.getTransaction());
    }

    public void unlock(Transaction transaction) {
        if (transaction == null) {
            return;
        }
        this.delegate.unlock((org.jboss.jca.core.spi.transaction.local.TransactionLocal)this, transaction);
    }

    protected Object initialValue() {
        return null;
    }

    protected Object getValue(Transaction tx) {
        return this.delegate.getValue((org.jboss.jca.core.spi.transaction.local.TransactionLocal)this, tx);
    }

    protected void storeValue(Transaction tx, Object value) {
        this.delegate.storeValue((org.jboss.jca.core.spi.transaction.local.TransactionLocal)this, tx, value);
    }

    protected boolean containsValue(Transaction tx) {
        return this.delegate.containsValue((org.jboss.jca.core.spi.transaction.local.TransactionLocal)this, tx);
    }

    public Object get() {
        return this.get(this.getTransaction());
    }

    public Object get(Transaction transaction) {
        if (transaction == null) {
            return this.initialValue();
        }
        Object value = this.getValue(transaction);
        if (value == null) {
            value = this.initialValue();
            if (value == null) {
                value = NULL_VALUE;
            }
            try {
                this.storeValue(transaction, value);
            }
            catch (IllegalStateException e) {
                return this.initialValue();
            }
        }
        if (value == NULL_VALUE) {
            return null;
        }
        return value;
    }

    public void set(Object value) {
        this.set(this.getTransaction(), value);
    }

    public void set(Transaction transaction, Object value) {
        if (transaction == null) {
            throw new IllegalStateException("there is no transaction");
        }
        if (!this.containsValue(transaction)) {
            this.initialValue();
        }
        if (value == null) {
            value = NULL_VALUE;
        }
        this.storeValue(transaction, value);
    }

    public Transaction getTransaction() {
        if (this.transactionIntegration.getTransactionManager() == null) {
            throw new IllegalStateException("Null transaction manager");
        }
        try {
            return this.transactionIntegration.getTransactionManager().getTransaction();
        }
        catch (SystemException e) {
            throw new IllegalStateException("An error occured while getting the transaction associated with the current thread: " + (Object)((Object)e));
        }
    }
}

