/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.metadata;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.jboss.jca.common.api.metadata.ironjacamar.IronJacamar;
import org.jboss.jca.common.api.metadata.ra.Connector;
import org.jboss.jca.common.metadata.ironjacamar.IronJacamarParser;
import org.jboss.jca.common.metadata.ra.RaParser;
import org.jboss.logging.Logger;

public class MetadataFactory {
    private static Logger log = Logger.getLogger(MetadataFactory.class);

    public Connector getStandardMetaData(File root) throws Exception {
        Connector result = null;
        File metadataFile = new File(root, "/META-INF/ra.xml");
        if (metadataFile.exists()) {
            InputStream input = null;
            String url = metadataFile.getAbsolutePath();
            try {
                long start = System.currentTimeMillis();
                input = new FileInputStream(metadataFile);
                result = new RaParser().parse(input);
                log.debugf("Total parse for %s took %d ms", (Object)url, (Object)(System.currentTimeMillis() - start));
            }
            catch (Exception e) {
                log.errorf((Throwable)e, "Error during parsing: %s", (Object)url);
                throw e;
            }
            finally {
                if (input != null) {
                    input.close();
                }
            }
        } else {
            log.tracef("metadata file %s does not exist", (Object)metadataFile.toString());
        }
        return result;
    }

    public IronJacamar getIronJacamarMetaData(File root) throws Exception {
        IronJacamar result = null;
        File metadataFile = new File(root, "/META-INF/ironjacamar.xml");
        if (metadataFile.exists()) {
            InputStream input = null;
            String url = metadataFile.getAbsolutePath();
            try {
                long start = System.currentTimeMillis();
                input = new FileInputStream(metadataFile);
                result = new IronJacamarParser().parse(input);
                log.debugf("Total parse for %s took %d ms", (Object)url, (Object)(System.currentTimeMillis() - start));
                log.tracef("successufully deployed %s", (Object)result.toString());
            }
            catch (Exception e) {
                log.error((Object)("Error during parsing: " + url), (Throwable)e);
                throw e;
            }
            finally {
                if (input != null) {
                    input.close();
                }
            }
        }
        return result;
    }
}

