/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.context.base;

import java.lang.reflect.Method;
import java.util.concurrent.Future;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.xml.rpc.handler.MessageContext;
import org.jboss.ejb3.context.base.BaseInvocationContext;
import org.jboss.ejb3.context.spi.SessionBeanComponent;
import org.jboss.ejb3.context.spi.SessionContext;
import org.jboss.ejb3.context.spi.SessionInvocationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseSessionInvocationContext
extends BaseInvocationContext
implements SessionInvocationContext {
    private Class<?> invokedBusinessInterface;
    private MessageContext messageContext;
    private Future future;

    public BaseSessionInvocationContext(Class<?> invokedBusinessInterface, Method method, Object[] parameters) {
        super(method, parameters);
        this.invokedBusinessInterface = invokedBusinessInterface;
    }

    public <T> T getBusinessObject(Class<T> businessInterface) throws IllegalStateException {
        SessionContext ctx = this.getEJBContext();
        return (T)ctx.getComponent().getBusinessObject(ctx, businessInterface);
    }

    public SessionContext getEJBContext() {
        return (SessionContext)super.getEJBContext();
    }

    public EJBLocalObject getEJBLocalObject() throws IllegalStateException {
        SessionContext ctx = this.getEJBContext();
        return ctx.getComponent().getEJBLocalObject(ctx);
    }

    public EJBObject getEJBObject() throws IllegalStateException {
        SessionContext ctx = this.getEJBContext();
        return ctx.getComponent().getEJBObject(ctx);
    }

    public Class<?> getInvokedBusinessInterface() throws IllegalStateException {
        if (this.invokedBusinessInterface == null) {
            throw new IllegalStateException("No invoked business interface on " + this);
        }
        return this.invokedBusinessInterface;
    }

    public SessionBeanComponent getComponent() {
        return this.getEJBContext().getComponent();
    }

    public MessageContext getMessageContext() throws IllegalStateException {
        if (this.messageContext == null) {
            throw new IllegalStateException("No message context on " + this);
        }
        return this.messageContext;
    }

    public void setFuture(Future future) {
        this.future = future;
    }

    public void setMessageContext(MessageContext messageContext) {
        this.messageContext = messageContext;
    }

    public boolean wasCancelCalled() throws IllegalStateException {
        if (this.future == null) {
            throw new IllegalStateException("No asynchronous invocation in progress");
        }
        return this.future.isCancelled();
    }
}

