/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.control;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.tx.AbstractTransactionBoundaryCommand;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.TransactionalInvocationContextFlagsOverride;
import org.infinispan.context.impl.RemoteTxInvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.marshall.Marshallable;
import org.infinispan.marshall.exts.ReplicableCommandExternalizer;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.transaction.xa.RemoteTransaction;
import org.infinispan.util.Util;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Marshallable(externalizer=ReplicableCommandExternalizer.class, id=36)
public class LockControlCommand
extends AbstractTransactionBoundaryCommand
implements FlagAffectedCommand {
    private static Log log = LogFactory.getLog(LockControlCommand.class);
    public static final int COMMAND_ID = 3;
    private Set<Object> keys;
    private Object singleKey;
    private boolean implicit = false;
    private boolean unlock = false;
    private Set<Flag> flags;

    public LockControlCommand() {
    }

    public LockControlCommand(Collection<Object> keys, String cacheName, Set<Flag> flags) {
        this(keys, cacheName, flags, false);
    }

    public LockControlCommand(Collection<Object> keys, String cacheName, Set<Flag> flags, boolean implicit) {
        this.cacheName = cacheName;
        this.keys = null;
        this.singleKey = null;
        if (keys != null && !keys.isEmpty()) {
            if (keys.size() == 1) {
                Iterator<Object> i$ = keys.iterator();
                while (i$.hasNext()) {
                    Object k;
                    this.singleKey = k = i$.next();
                }
            } else {
                this.keys = new HashSet<Object>(keys);
            }
        }
        this.flags = flags;
        this.implicit = implicit;
    }

    public void attachGlobalTransaction(GlobalTransaction gtx) {
        this.globalTx = gtx;
    }

    public Set<Object> getKeys() {
        if (this.keys == null) {
            if (this.singleKey == null) {
                return Collections.emptySet();
            }
            return Collections.singleton(this.singleKey);
        }
        return this.keys;
    }

    public void replaceKey(Object oldKey, Object replacement) {
        if (this.singleKey != null && this.singleKey.equals(oldKey)) {
            this.singleKey = replacement;
        } else if (this.keys != null && this.keys.remove(oldKey)) {
            this.keys.add(replacement);
        }
    }

    public void replaceKeys(Map<Object, Object> replacements) {
        for (Map.Entry<Object, Object> e : replacements.entrySet()) {
            this.replaceKey(e.getKey(), e.getValue());
        }
    }

    public boolean multipleKeys() {
        return this.keys != null && this.keys.size() > 1;
    }

    public Object getSingleKey() {
        if (this.singleKey == null) {
            if (this.keys != null) {
                Iterator<Object> i$ = this.keys.iterator();
                if (i$.hasNext()) {
                    Object sk = i$.next();
                    return sk;
                }
                return null;
            }
            return null;
        }
        return this.singleKey;
    }

    public boolean isImplicit() {
        return this.implicit;
    }

    public boolean isExplicit() {
        return !this.isImplicit();
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitLockControlCommand((TxInvocationContext)ctx, this);
    }

    @Override
    public Object perform(InvocationContext ignored) throws Throwable {
        if (ignored != null) {
            throw new IllegalStateException("Expected null context!");
        }
        RemoteTxInvocationContext ctxt = this.icc.createRemoteTxInvocationContext();
        RemoteTransaction transaction = this.txTable.getRemoteTransaction(this.globalTx);
        if (transaction == null) {
            if (this.unlock) {
                if (log.isTraceEnabled()) {
                    log.trace("Unlock for non-existant transaction " + this.globalTx + ". Not doing anything.");
                }
                return null;
            }
            transaction = this.txTable.createRemoteTransaction(this.globalTx);
        }
        ctxt.setRemoteTransaction(transaction);
        TxInvocationContext ctx = ctxt;
        if (this.flags != null && !this.flags.isEmpty()) {
            ctx = new TransactionalInvocationContextFlagsOverride(ctxt, this.flags);
        }
        return this.invoker.invoke(ctx, this);
    }

    @Override
    public byte getCommandId() {
        return 3;
    }

    @Override
    public Object[] getParameters() {
        if (this.keys == null || this.keys.isEmpty()) {
            if (this.singleKey == null) {
                return new Object[]{this.globalTx, this.cacheName, this.unlock, (byte)1, this.flags};
            }
            return new Object[]{this.globalTx, this.cacheName, this.unlock, (byte)2, this.singleKey, this.flags};
        }
        return new Object[]{this.globalTx, this.cacheName, this.unlock, (byte)3, this.keys, this.flags};
    }

    @Override
    public void setParameters(int commandId, Object[] args) {
        if (commandId != 3) {
            throw new IllegalStateException("Unusupported command id:" + commandId);
        }
        this.globalTx = (GlobalTransaction)args[0];
        this.cacheName = (String)args[1];
        this.unlock = (Boolean)args[2];
        this.keys = null;
        this.singleKey = null;
        byte mode = (Byte)args[3];
        switch (mode) {
            case 1: {
                if (args.length != 5) break;
                this.flags = (Set)args[4];
                break;
            }
            case 2: {
                this.singleKey = args[4];
                if (args.length != 6) break;
                this.flags = (Set)args[5];
                break;
            }
            case 3: {
                this.keys = (Set)args[4];
                if (args.length != 6) break;
                this.flags = (Set)args[5];
            }
        }
    }

    public boolean isUnlock() {
        return this.unlock;
    }

    public void setUnlock(boolean unlock) {
        this.unlock = unlock;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LockControlCommand that = (LockControlCommand)o;
        if (!super.equals(that)) {
            return false;
        }
        return ((Object)this.keys).equals(that.keys) && Util.safeEquals(this.singleKey, that.singleKey) && this.unlock == that.unlock;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.keys != null ? ((Object)this.keys).hashCode() : 0);
        return 31 * result + (this.singleKey != null ? this.singleKey.hashCode() : 0);
    }

    @Override
    public String toString() {
        return "LockControlCommand{keys=" + this.keys + ", cacheName='" + this.cacheName + ", flags=" + this.flags + "', implicit=" + this.implicit + ", unlock=" + this.unlock + ", singleKey='" + this.singleKey + "'}";
    }

    @Override
    public Set<Flag> getFlags() {
        return this.flags;
    }

    @Override
    public void setFlags(Set<Flag> flags) {
        this.flags = flags;
    }
}

