/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.infinispan.CacheException;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.control.RehashControlCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.config.Configuration;
import org.infinispan.container.DataContainer;
import org.infinispan.distribution.DistributionManagerImpl;
import org.infinispan.distribution.PendingPreparesMap;
import org.infinispan.distribution.RehashTask;
import org.infinispan.distribution.TransactionLogMap;
import org.infinispan.distribution.TransactionLogger;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.ConsistentHashHelper;
import org.infinispan.remoting.rpc.ResponseMode;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.Util;
import org.infinispan.util.concurrent.NotifyingFutureImpl;

public class InvertedLeaveTask
extends RehashTask {
    private final DistributionManagerImpl distributionManager;
    private final List<Address> leaversHandled;
    private final List<Address> providers;
    private final List<Address> receivers;
    private final boolean isReceiver;
    private final boolean isSender;

    public InvertedLeaveTask(DistributionManagerImpl dmi, RpcManager rpcManager, Configuration conf, CommandsFactory commandsFactory, DataContainer dataContainer, List<Address> stateProviders, List<Address> stateReceivers, boolean isReceiver) {
        super(dmi, rpcManager, conf, commandsFactory, dataContainer);
        this.distributionManager = dmi;
        this.leaversHandled = new LinkedList<Address>(this.distributionManager.getLeavers());
        this.providers = stateProviders;
        this.receivers = stateReceivers;
        this.isReceiver = isReceiver;
        this.isSender = stateProviders.contains(this.self);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void performRehash() throws Exception {
        long start = System.currentTimeMillis();
        int replCount = this.configuration.getNumOwners();
        ConsistentHash newCH = this.distributionManager.getConsistentHash();
        ConsistentHash oldCH = ConsistentHashHelper.createConsistentHash(this.configuration, newCH.getCaches(), this.leaversHandled, this.distributionManager.topologyInfo);
        try {
            this.log.debug((Object)"Starting leave rehash[enabled=%s,isReceiver=%s,isSender=%s] on node %s", this.configuration.isRehashEnabled(), this.isReceiver, this.isSender, this.self);
            if (this.isReceiver) {
                this.distributionManager.getTransactionLogger().blockNewTransactions();
            }
            if (this.configuration.isRehashEnabled()) {
                if (this.isReceiver) {
                    this.providers.remove(this.self);
                    try {
                        RehashControlCommand cmd = this.cf.buildRehashControlCommand(RehashControlCommand.Type.PULL_STATE_LEAVE, this.self, null, oldCH, newCH, this.leaversHandled);
                        this.log.debug((Object)"I %s am pulling state from %s", this.self, this.providers);
                        HashSet<Future<Void>> stateRetrievalProcesses = new HashSet<Future<Void>>(this.providers.size());
                        for (Address address : this.providers) {
                            stateRetrievalProcesses.add(this.statePullExecutor.submit(new LeaveStateGrabber(address, (ReplicableCommand)cmd, newCH)));
                        }
                        this.log.trace("State retrieval being processed.");
                        for (Future future : stateRetrievalProcesses) {
                            future.get();
                        }
                        this.log.trace((Object)"State retrieval from %s completed.", this.providers);
                    }
                    catch (Throwable throwable) {
                        this.log.trace((Object)"Informing %s that state has been applied.", this.providers);
                        RehashControlCommand c = this.cf.buildRehashControlCommand(RehashControlCommand.Type.LEAVE_REHASH_END, this.self);
                        this.rpcManager.invokeRemotely(this.providers, c, ResponseMode.SYNCHRONOUS, this.configuration.getRehashRpcTimeout(), true);
                        throw throwable;
                    }
                    this.log.trace((Object)"Informing %s that state has been applied.", this.providers);
                    RehashControlCommand c = this.cf.buildRehashControlCommand(RehashControlCommand.Type.LEAVE_REHASH_END, this.self);
                    this.rpcManager.invokeRemotely(this.providers, c, ResponseMode.SYNCHRONOUS, this.configuration.getRehashRpcTimeout(), true);
                }
                if (this.isSender) {
                    HashSet<Address> recCopy = new HashSet<Address>(this.receivers);
                    recCopy.remove(this.self);
                    this.distributionManager.awaitLeaveRehashAcks(recCopy, this.configuration.getStateRetrievalTimeout());
                    this.processAndDrainTxLog(oldCH, newCH, replCount);
                    this.invalidateInvalidHolders(this.leaversHandled, oldCH, newCH);
                }
            }
        }
        catch (Exception e) {
            try {
                throw new CacheException("Unexpected exception", e);
            }
            catch (Throwable throwable) {
                for (Address addr : this.leaversHandled) {
                    this.distributionManager.markLeaverAsHandled(addr);
                }
                if (this.isReceiver) {
                    this.distributionManager.getTransactionLogger().unblockNewTransactions();
                }
                this.log.info((Object)"Completed leave rehash on node %s in %s - leavers now are %s", this.self, Util.prettyPrintTime(System.currentTimeMillis() - start), this.distributionManager.leavers);
                throw throwable;
            }
        }
        for (Address addr : this.leaversHandled) {
            this.distributionManager.markLeaverAsHandled(addr);
        }
        if (this.isReceiver) {
            this.distributionManager.getTransactionLogger().unblockNewTransactions();
        }
        this.log.info((Object)"Completed leave rehash on node %s in %s - leavers now are %s", this.self, Util.prettyPrintTime(System.currentTimeMillis() - start), this.distributionManager.leavers);
    }

    private void processAndDrainTxLog(ConsistentHash oldCH, ConsistentHash newCH, int replCount) {
        List<WriteCommand> c;
        int i = 0;
        TransactionLogger transactionLogger = this.distributionManager.getTransactionLogger();
        if (this.trace) {
            this.log.trace("Processing transaction log iteratively: " + transactionLogger);
        }
        while (transactionLogger.shouldDrainWithoutLock()) {
            if (this.trace) {
                this.log.trace((Object)"Processing transaction log, iteration %s", i++);
            }
            c = transactionLogger.drain();
            if (this.trace) {
                this.log.trace((Object)"Found %s modifications", c.size());
            }
            this.apply(oldCH, newCH, replCount, c);
        }
        if (this.trace) {
            this.log.trace("Processing transaction log: final drain and lock");
        }
        c = transactionLogger.drainAndLock(null);
        if (this.trace) {
            this.log.trace((Object)"Found %s modifications", c.size());
        }
        this.apply(oldCH, newCH, replCount, c);
        if (this.trace) {
            this.log.trace("Handling pending prepares");
        }
        PendingPreparesMap state = new PendingPreparesMap(Collections.unmodifiableList(this.distributionManager.getLeavers()), oldCH, newCH, replCount);
        Collection<PrepareCommand> pendingPrepares = transactionLogger.getPendingPrepares();
        if (this.trace) {
            this.log.trace((Object)"Found %s pending prepares", pendingPrepares.size());
        }
        for (PrepareCommand pc : pendingPrepares) {
            state.addState(pc);
        }
        if (this.trace) {
            this.log.trace((Object)"State map for pending prepares is %s", state.getState());
        }
        HashSet<NotifyingFutureImpl> pushFutures = new HashSet<NotifyingFutureImpl>();
        for (Map.Entry entry : state.getState().entrySet()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Pushing %s uncommitted prepares to %s", ((List)entry.getValue()).size(), entry.getKey());
            }
            RehashControlCommand push = this.cf.buildRehashControlCommandTxLogPendingPrepares(this.self, (List)entry.getValue());
            NotifyingFutureImpl f = new NotifyingFutureImpl(null);
            pushFutures.add(f);
            this.rpcManager.invokeRemotelyInFuture(Collections.singleton(entry.getKey()), push, true, f, this.configuration.getRehashRpcTimeout());
        }
        for (Future future : pushFutures) {
            try {
                future.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                this.log.error((Object)"Error pushing tx log", e);
            }
        }
        if (this.trace) {
            this.log.trace("Finished pushing pending prepares; unlocking and disabling transaction logging");
        }
        transactionLogger.unlockAndDisable(null);
    }

    private void apply(ConsistentHash oldCH, ConsistentHash newCH, int replCount, List<WriteCommand> wc) {
        TransactionLogMap state = new TransactionLogMap(Collections.unmodifiableList(this.distributionManager.getLeavers()), oldCH, newCH, replCount);
        for (WriteCommand c : wc) {
            state.addState(c);
        }
        if (this.trace) {
            this.log.trace((Object)"State map for modifications is %s", state.getState());
        }
        HashSet<NotifyingFutureImpl> pushFutures = new HashSet<NotifyingFutureImpl>();
        for (Map.Entry entry : state.getState().entrySet()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Pushing %s modifications to %s", ((List)entry.getValue()).size(), entry.getKey());
            }
            RehashControlCommand push = this.cf.buildRehashControlCommandTxLog(this.self, (List)entry.getValue());
            NotifyingFutureImpl f = new NotifyingFutureImpl(null);
            pushFutures.add(f);
            this.rpcManager.invokeRemotelyInFuture(Collections.singleton(entry.getKey()), push, true, f, this.configuration.getRehashRpcTimeout());
        }
        for (Future future : pushFutures) {
            try {
                future.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                this.log.error((Object)"Error pushing tx log", e);
            }
        }
    }

    protected final class LeaveStateGrabber
    extends RehashTask.StateGrabber {
        public LeaveStateGrabber(Address stateProvider, ReplicableCommand command, ConsistentHash newConsistentHash) {
            super(InvertedLeaveTask.this, stateProvider, command, newConsistentHash);
        }

        @Override
        protected boolean isForLeave() {
            return true;
        }
    }
}

