/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.infinispan.CacheException;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.control.RehashControlCommand;
import org.infinispan.config.Configuration;
import org.infinispan.container.DataContainer;
import org.infinispan.distribution.DistributionManagerImpl;
import org.infinispan.distribution.JoinTask;
import org.infinispan.distribution.ch.ConsistentHashHelper;
import org.infinispan.distribution.ch.TopologyInfo;
import org.infinispan.remoting.InboundInvocationHandler;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;

public class MergeTask
extends JoinTask {
    public MergeTask(RpcManager rpcManager, CommandsFactory commandsFactory, Configuration conf, DataContainer dataContainer, DistributionManagerImpl dmi, InboundInvocationHandler inboundInvocationHandler, List<Address> newView, List<List<Address>> mergedGroups) {
        super(rpcManager, commandsFactory, conf, dataContainer, dmi, inboundInvocationHandler);
        TopologyInfo ti = this.buildTopologyInfo(newView);
        this.chNew = ConsistentHashHelper.createConsistentHash(this.configuration, newView, ti);
        if (mergedGroups.size() < 2) {
            throw new IllegalArgumentException("Don't know how to handle a merge of " + mergedGroups.size() + " partitions!");
        }
        if (mergedGroups.size() > 2) {
            this.log.warn("Attempting to merge more than 2 partitions!  Inconsistencies may occur!  See https://issues.jboss.org/browse/ISPN-1001");
        }
        List<Address> a1 = mergedGroups.get(0);
        List<Address> a2 = mergedGroups.get(1);
        TopologyInfo oldTopologyInfo = this.distributionManager.getTopologyInfo();
        if (!a1.contains(this.self)) {
            this.chOld = ConsistentHashHelper.createConsistentHash(this.configuration, a1, oldTopologyInfo);
        } else if (!a2.contains(this.self)) {
            this.chOld = ConsistentHashHelper.createConsistentHash(this.configuration, a2, oldTopologyInfo);
        } else {
            throw new IllegalArgumentException("Neither of the merged partitions " + a1 + " and " + a2 + " contain " + this.self);
        }
        this.distributionManager.setTopologyInfo(ti);
    }

    private TopologyInfo buildTopologyInfo(List<Address> newView) {
        if (this.configuration.getGlobalConfiguration().hasTopologyInfo()) {
            TopologyInfo oldTI = this.distributionManager.getTopologyInfo();
            HashSet<Address> unknownAddresses = new HashSet<Address>();
            for (Address a : newView) {
                if (oldTI.containsInfoForNode(a)) continue;
                unknownAddresses.add(a);
            }
            if (!unknownAddresses.isEmpty()) {
                Collection moreTopologies = null;
                for (Address topologyProvider : unknownAddresses) {
                    Map<Address, Response> r = this.rpcManager.invokeRemotely(Collections.singleton(topologyProvider), (ReplicableCommand)this.cf.buildRehashControlCommand(RehashControlCommand.Type.FETCH_TOPOLOGY_INFO, this.self), true, true);
                    Response resp = r.get(topologyProvider);
                    if (!resp.isSuccessful() || !resp.isValid()) continue;
                    moreTopologies = (Collection)((SuccessfulResponse)resp).getResponseValue();
                    break;
                }
                if (moreTopologies == null) {
                    throw new CacheException("Unable to retrieve topology information for addresses " + unknownAddresses);
                }
                return new TopologyInfo(oldTI, moreTopologies);
            }
            return oldTI;
        }
        return null;
    }

    @Override
    protected void getPermissionToJoin() {
    }

    @Override
    protected void broadcastNewConsistentHash() {
    }

    @Override
    protected void signalJoinRehashEnd() {
    }
}

