/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.distribution.TransactionLogger;
import org.infinispan.remoting.transport.Address;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.concurrent.ReclosableLatch;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class TransactionLoggerImpl
implements TransactionLogger {
    volatile boolean enabled;
    volatile Address writeLockOwner = null;
    final ReclosableLatch modsLatch = new ReclosableLatch();
    final BlockingQueue<WriteCommand> commandQueue = new LinkedBlockingQueue<WriteCommand>();
    final Map<GlobalTransaction, PrepareCommand> uncommittedPrepares = new ConcurrentHashMap<GlobalTransaction, PrepareCommand>();
    private static final Log log = LogFactory.getLog(TransactionLoggerImpl.class);
    private static final boolean trace = log.isTraceEnabled();
    private static final int DRAIN_LOCK_THRESHOLD = 25;
    private static final int GROWTH_COUNT_THRESHOLD = 3;
    private int previousSize;
    private int growthCount;
    private final ReclosableLatch txBlockGate = new ReclosableLatch(true);
    private final CommandsFactory cf;

    public TransactionLoggerImpl(CommandsFactory cf) {
        this.cf = cf;
    }

    @Override
    public void enable() {
        this.modsLatch.open();
        this.enabled = true;
    }

    @Override
    public List<WriteCommand> drain() {
        LinkedList<WriteCommand> list = new LinkedList<WriteCommand>();
        this.commandQueue.drainTo(list);
        return list;
    }

    @Override
    public List<WriteCommand> drainAndLock(Address lockedFor) {
        if (this.writeLockOwner != null) {
            throw new IllegalStateException("This cannot happen - write lock already owned by " + this.writeLockOwner);
        }
        this.modsLatch.close();
        if (this.writeLockOwner != null) {
            throw new IllegalStateException("This cannot happen - write lock already owned by " + this.writeLockOwner);
        }
        this.writeLockOwner = lockedFor;
        return this.drain();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlockAndDisable(Address lockedFor) {
        boolean unlock = true;
        try {
            if (!lockedFor.equals(this.writeLockOwner)) {
                unlock = false;
                throw new IllegalMonitorStateException("Compare-and-set for owner " + lockedFor + " failed - was " + this.writeLockOwner);
            }
            this.enabled = false;
            this.uncommittedPrepares.clear();
            this.writeLockOwner = null;
        }
        catch (IllegalMonitorStateException imse) {
            log.warn((Object)"Unable to stop transaction logging!", imse);
        }
        finally {
            if (unlock) {
                this.modsLatch.open();
            }
        }
    }

    @Override
    public boolean logIfNeeded(WriteCommand command) {
        if (this.enabled) {
            this.waitForModsLatch();
            if (this.enabled) {
                try {
                    this.commandQueue.put(command);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public void logIfNeeded(PrepareCommand command) {
        if (this.enabled) {
            this.waitForModsLatch();
            if (this.enabled) {
                if (command.isOnePhaseCommit()) {
                    this.logModificationsInTransaction(command);
                } else {
                    this.uncommittedPrepares.put(command.getGlobalTransaction(), command);
                }
            }
        }
    }

    private void logModificationsInTransaction(PrepareCommand command) {
        this.logModifications(Arrays.asList(command.getModifications()));
    }

    private void logModifications(Collection<WriteCommand> mods) {
        for (WriteCommand wc : mods) {
            try {
                this.commandQueue.put(wc);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public void logModificationsIfNeeded(CommitCommand commit, TxInvocationContext context) {
        if (this.enabled) {
            GlobalTransaction gtx;
            this.waitForModsLatch();
            if (this.enabled && !this.uncommittedPrepares.containsKey(gtx = commit.getGlobalTransaction())) {
                this.uncommittedPrepares.put(gtx, this.cf.buildPrepareCommand(gtx, context.getModifications(), false));
            }
        }
    }

    @Override
    public void logIfNeeded(CommitCommand command, TxInvocationContext context) {
        if (this.enabled) {
            this.waitForModsLatch();
            if (this.enabled) {
                PrepareCommand pc = this.uncommittedPrepares.remove(command.getGlobalTransaction());
                if (pc == null) {
                    this.logModifications(context.getModifications());
                } else {
                    this.logModificationsInTransaction(pc);
                }
            }
        }
    }

    @Override
    public void logIfNeeded(RollbackCommand command) {
        if (this.enabled) {
            this.waitForModsLatch();
            if (this.enabled) {
                this.uncommittedPrepares.remove(command.getGlobalTransaction());
            }
        }
    }

    private void waitForModsLatch() {
        try {
            this.modsLatch.await();
        }
        catch (InterruptedException i) {
            Thread.currentThread().interrupt();
        }
    }

    private int size() {
        return this.enabled ? 0 : this.commandQueue.size();
    }

    @Override
    public boolean isEnabled() {
        try {
            this.txBlockGate.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return this.enabled;
    }

    @Override
    public boolean shouldDrainWithoutLock() {
        if (this.enabled) {
            boolean shouldLock;
            int sz = this.size();
            boolean bl = shouldLock = this.previousSize > 0 && this.growthCount > 3 || sz < 25;
            if (!shouldLock) {
                if (sz > this.previousSize && this.previousSize > 0) {
                    ++this.growthCount;
                }
                this.previousSize = sz;
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public Collection<PrepareCommand> getPendingPrepares() {
        HashSet<PrepareCommand> commands = new HashSet<PrepareCommand>(this.uncommittedPrepares.values());
        this.uncommittedPrepares.clear();
        return commands;
    }

    @Override
    public void blockNewTransactions() {
        this.txBlockGate.close();
    }

    @Override
    public void unblockNewTransactions() {
        this.txBlockGate.open();
    }

    public String toString() {
        return "TransactionLoggerImpl{commandQueue=" + this.commandQueue + ", uncommittedPrepares=" + this.uncommittedPrepares + '}';
    }
}

