/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Arrays;
import org.infinispan.marshall.Marshallable;
import org.infinispan.util.Util;

@Marshallable(externalizer=Externalizer.class, id=57)
public class ByteArrayKey
implements Serializable {
    private final byte[] data;

    public ByteArrayKey(byte[] data) {
        this.data = data;
    }

    public byte[] getData() {
        return this.data;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ByteArrayKey key = (ByteArrayKey)obj;
        return Arrays.equals(key.data, this.data);
    }

    public int hashCode() {
        return 41 + Arrays.hashCode(this.data);
    }

    public String toString() {
        return "ByteArrayKey" + "{" + "data=" + Util.printArray(this.data, true) + "}";
    }

    public static class Externalizer
    implements org.infinispan.marshall.Externalizer {
        @Override
        public void writeObject(ObjectOutput output, Object object) throws IOException {
            ByteArrayKey key = (ByteArrayKey)object;
            output.writeInt(key.data.length);
            output.write(key.data);
        }

        @Override
        public Object readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            byte[] data = new byte[input.readInt()];
            input.readFully(data);
            return new ByteArrayKey(data);
        }
    }
}

