/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.testenricher.jmx;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.inject.Inject;
import org.jboss.arquillian.api.DeploymentProvider;
import org.jboss.arquillian.protocol.jmx.ResourceCallbackHandler;
import org.jboss.arquillian.protocol.jmx.ResourceCallbackHandlerAssociation;
import org.jboss.arquillian.spi.Context;
import org.jboss.arquillian.spi.TestClass;
import org.jboss.arquillian.spi.TestEnricher;
import org.jboss.arquillian.testenricher.jmx.DeploymentProviderImpl;

public class JMXTestEnricher
implements TestEnricher {
    public void enrich(Context context, Object testCase) {
        Class<?> testClass = testCase.getClass();
        for (Field field : testClass.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Inject.class) || !field.getType().isAssignableFrom(DeploymentProvider.class)) continue;
            this.injectDeploymentProvider(context, testCase, field);
        }
    }

    public Object[] resolve(Context context, Method method) {
        return null;
    }

    private void injectDeploymentProvider(Context context, Object testCase, Field field) {
        try {
            TestClass testClass = new TestClass(testCase.getClass());
            field.set(testCase, this.getDeploymentProvider(context, testClass));
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException("Cannot inject DeploymentProvider", ex);
        }
    }

    private DeploymentProvider getDeploymentProvider(Context context, TestClass testClass) {
        ResourceCallbackHandler callbackHandler = ResourceCallbackHandlerAssociation.getCallbackHandler();
        return new DeploymentProviderImpl(testClass, callbackHandler);
    }
}

