/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.description;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.ejb.AccessTimeout;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.LockType;
import org.jboss.as.ejb3.component.MethodIntf;
import org.jboss.as.ejb3.component.session.SessionBeanComponentDescription;
import org.jboss.as.ejb3.component.singleton.SingletonComponentDescription;
import org.jboss.as.ejb3.component.stateful.StatefulComponentDescription;
import org.jboss.as.ejb3.component.stateless.StatelessComponentDescription;
import org.jboss.as.ejb3.deployment.EjbJarDescription;

public class EjbJarDescriptionMergingUtil {
    public static void merge(EjbJarDescription mergedResult, EjbJarDescription original, EjbJarDescription override, EjbJarDescription ejbModuleDescription) {
        Collection<SessionBeanComponentDescription> originalSessionBeans = original.getSessionBeans();
        if (originalSessionBeans.isEmpty()) {
            mergedResult.addSessionBeans(override.getSessionBeans());
        } else {
            Collection<SessionBeanComponentDescription> overrideSessionBeans = override.getSessionBeans();
            if (overrideSessionBeans.isEmpty()) {
                mergedResult.addSessionBeans(originalSessionBeans);
            } else {
                ArrayList<SessionBeanComponentDescription> mergedBeans = new ArrayList<SessionBeanComponentDescription>();
                EjbJarDescriptionMergingUtil.mergeSessionBeans(mergedBeans, originalSessionBeans, overrideSessionBeans, ejbModuleDescription);
                mergedResult.addSessionBeans(mergedBeans);
            }
        }
    }

    public static void mergeSessionBeans(Collection<SessionBeanComponentDescription> mergedResult, Collection<SessionBeanComponentDescription> original, Collection<SessionBeanComponentDescription> override, EjbJarDescription ejbModuleDescription) {
        if (original.isEmpty()) {
            mergedResult.addAll(override);
        } else if (override.isEmpty()) {
            mergedResult.addAll(original);
        } else {
            HashSet<String> commonBeans = new HashSet<String>();
            for (SessionBeanComponentDescription originalSessionBean : original) {
                SessionBeanComponentDescription overrideSessionBean = EjbJarDescriptionMergingUtil.findSessionBean(originalSessionBean.getEJBName(), override);
                if (overrideSessionBean == null) {
                    mergedResult.add(originalSessionBean);
                    continue;
                }
                SessionBeanComponentDescription.SessionBeanType sessionBeanType = originalSessionBean.getSessionBeanType();
                if (overrideSessionBean.getSessionBeanType() != sessionBeanType) {
                    throw new RuntimeException("Cannot mergeSessionBean two EJBs with the same name = " + originalSessionBean.getEJBName() + " but with different session bean types, type 1 - " + (Object)((Object)overrideSessionBean.getSessionBeanType()) + " type 2 - " + (Object)((Object)originalSessionBean.getSessionBeanType()));
                }
                commonBeans.add(originalSessionBean.getEJBName());
                SessionBeanComponentDescription mergedBean = EjbJarDescriptionMergingUtil.createNewSessionBean(originalSessionBean, ejbModuleDescription);
                switch (sessionBeanType) {
                    case STATELESS: {
                        EjbJarDescriptionMergingUtil.mergeStatelessBean((StatelessComponentDescription)mergedBean, (StatelessComponentDescription)originalSessionBean, (StatelessComponentDescription)overrideSessionBean);
                        break;
                    }
                    case STATEFUL: {
                        EjbJarDescriptionMergingUtil.mergeStatefulBean((StatefulComponentDescription)mergedBean, (StatefulComponentDescription)originalSessionBean, (StatefulComponentDescription)overrideSessionBean);
                        break;
                    }
                    case SINGLETON: {
                        EjbJarDescriptionMergingUtil.mergeSingletonBean((SingletonComponentDescription)mergedBean, (SingletonComponentDescription)originalSessionBean, (SingletonComponentDescription)overrideSessionBean);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unknown session bean type: " + (Object)((Object)sessionBeanType) + " for bean: " + originalSessionBean.getEJBName());
                    }
                }
                mergedResult.add(mergedBean);
            }
            for (SessionBeanComponentDescription overrideSessionBean : override) {
                if (commonBeans.contains(overrideSessionBean.getEJBName())) continue;
                mergedResult.add(overrideSessionBean);
            }
        }
    }

    public static void mergeSingletonBean(SingletonComponentDescription mergedSingleton, SingletonComponentDescription original, SingletonComponentDescription override) {
        EjbJarDescriptionMergingUtil.mergeSessionBean(mergedSingleton, original, override);
        if (override.isInitOnStartup()) {
            mergedSingleton.initOnStartup();
        }
    }

    public static void mergeStatefulBean(StatefulComponentDescription mergedStatefulBean, StatefulComponentDescription original, StatefulComponentDescription override) {
        EjbJarDescriptionMergingUtil.mergeSessionBean(mergedStatefulBean, original, override);
    }

    public static void mergeStatelessBean(StatelessComponentDescription mergedStatelessBean, StatelessComponentDescription original, StatelessComponentDescription override) {
        EjbJarDescriptionMergingUtil.mergeSessionBean(mergedStatelessBean, original, override);
    }

    private static void mergeSessionBean(SessionBeanComponentDescription mergedBean, SessionBeanComponentDescription original, SessionBeanComponentDescription override) {
        block21: {
            block20: {
                if (override.getMappedName() != null) {
                    mergedBean.setMappedName(override.getMappedName());
                } else {
                    mergedBean.setMappedName(original.getMappedName());
                }
                if (override.getTransactionManagementType() != null) {
                    mergedBean.setTransactionManagementType(override.getTransactionManagementType());
                } else if (original.getTransactionManagementType() != null) {
                    mergedBean.setTransactionManagementType(original.getTransactionManagementType());
                }
                ConcurrencyManagementType overrideConcurrencyMgmtType = override.getConcurrencyManagementType();
                if (overrideConcurrencyMgmtType != null) {
                    if (overrideConcurrencyMgmtType == ConcurrencyManagementType.BEAN) {
                        mergedBean.beanManagedConcurrency();
                    } else {
                        mergedBean.containerManagedConcurrency();
                    }
                } else {
                    ConcurrencyManagementType originalConcurrencyManagemenType = original.getConcurrencyManagementType();
                    if (originalConcurrencyManagemenType != null) {
                        if (originalConcurrencyManagemenType == ConcurrencyManagementType.BEAN) {
                            mergedBean.beanManagedConcurrency();
                        } else {
                            mergedBean.containerManagedConcurrency();
                        }
                    }
                }
                LockType overrideBeanLockType = override.getBeanLevelLockType();
                if (overrideBeanLockType != null) {
                    mergedBean.setBeanLevelLockType(overrideBeanLockType);
                } else {
                    LockType originalBeanLockType = original.getBeanLevelLockType();
                    if (originalBeanLockType != null) {
                        mergedBean.setBeanLevelLockType(originalBeanLockType);
                    }
                }
                AccessTimeout overrideAccessTimeout = override.getBeanLevelAccessTimeout();
                if (overrideAccessTimeout != null) {
                    mergedBean.setBeanLevelAccessTimeout(overrideAccessTimeout);
                } else {
                    AccessTimeout originalAccessTimeout = original.getBeanLevelAccessTimeout();
                    if (originalAccessTimeout != null) {
                        mergedBean.setBeanLevelAccessTimeout(originalAccessTimeout);
                    }
                }
                Set overrideViews = override.getViewClassNames();
                if (overrideViews == null || overrideViews.isEmpty()) break block20;
                for (String view : overrideViews) {
                    MethodIntf viewType = override.getMethodIntf(view);
                    EjbJarDescriptionMergingUtil.addView(mergedBean, view, viewType);
                }
                break block21;
            }
            Set originalViews = original.getViewClassNames();
            if (originalViews == null) break block21;
            for (String view : originalViews) {
                MethodIntf viewType = original.getMethodIntf(view);
                EjbJarDescriptionMergingUtil.addView(mergedBean, view, viewType);
            }
        }
    }

    private static SessionBeanComponentDescription findSessionBean(String ejbName, Collection<SessionBeanComponentDescription> sessionBeans) {
        if (sessionBeans == null || sessionBeans.isEmpty()) {
            return null;
        }
        for (SessionBeanComponentDescription sessionBean : sessionBeans) {
            if (!sessionBean.getEJBName().equals(ejbName)) continue;
            return sessionBean;
        }
        return null;
    }

    private static SessionBeanComponentDescription createNewSessionBean(SessionBeanComponentDescription source, EjbJarDescription ejbModuleDescription) {
        SessionBeanComponentDescription.SessionBeanType sessionBeanType = source.getSessionBeanType();
        switch (sessionBeanType) {
            case STATELESS: {
                return new StatelessComponentDescription(source.getComponentName(), source.getComponentClassName(), ejbModuleDescription);
            }
            case STATEFUL: {
                return new StatefulComponentDescription(source.getComponentName(), source.getComponentClassName(), ejbModuleDescription);
            }
            case SINGLETON: {
                return new SingletonComponentDescription(source.getComponentName(), source.getComponentClassName(), ejbModuleDescription);
            }
        }
        throw new IllegalArgumentException("Unknown session bean type: " + (Object)((Object)sessionBeanType) + " for bean " + source.getEJBName());
    }

    private static void addView(SessionBeanComponentDescription sessionBean, String viewClassName, MethodIntf viewType) {
        switch (viewType) {
            case LOCAL: {
                if (sessionBean.getEJBClassName().equals(viewClassName)) {
                    sessionBean.addNoInterfaceView();
                } else {
                    sessionBean.addLocalBusinessInterfaceViews(Collections.singleton(viewClassName));
                }
                return;
            }
            case REMOTE: {
                sessionBean.addRemoteBusinessInterfaceViews(Collections.singleton(viewClassName));
                return;
            }
        }
    }
}

