/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.stateful;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Map;
import javax.ejb.EJBException;
import org.jboss.as.ee.component.AbstractComponentInstance;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentInstance;
import org.jboss.as.ejb3.component.session.SessionBeanComponent;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponentConfiguration;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponentInstance;
import org.jboss.ejb3.cache.Cache;
import org.jboss.ejb3.cache.NoPassivationCache;
import org.jboss.ejb3.cache.StatefulObjectFactory;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactoryContext;

public class StatefulSessionComponent
extends SessionBeanComponent {
    private Cache<StatefulSessionComponentInstance> cache = new NoPassivationCache();

    protected StatefulSessionComponent(StatefulSessionComponentConfiguration configuration) {
        super(configuration);
        this.cache.setStatefulObjectFactory((StatefulObjectFactory)new StatefulObjectFactory<StatefulSessionComponentInstance>(){

            public StatefulSessionComponentInstance createInstance() {
                return (StatefulSessionComponentInstance)StatefulSessionComponent.this.createInstance();
            }

            public void destroyInstance(StatefulSessionComponentInstance instance) {
                StatefulSessionComponent.this.destroyInstance((ComponentInstance)instance);
            }
        });
    }

    @Override
    public Interceptor createClientInterceptor(Class<?> view) {
        Serializable sessionId = this.createSession();
        return this.createClientInterceptor(view, sessionId);
    }

    @Override
    public Interceptor createClientInterceptor(final Class<?> view, final Serializable sessionId) {
        return new Interceptor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object processInvocation(InterceptorContext context) throws Exception {
                Method method = context.getMethod();
                if (StatefulSessionComponent.this.getComponentClass().equals(view) && !StatefulSessionComponent.this.isInvocationAllowed(method)) {
                    throw new EJBException("Cannot invoke method " + method + " on nointerface view of bean " + StatefulSessionComponent.this.getComponentName());
                }
                context.putPrivateData(Component.class, (Object)StatefulSessionComponent.this);
                context.putPrivateData(Serializable.class, (Object)sessionId);
                try {
                    if (StatefulSessionComponent.this.isAsynchronous(method)) {
                        Object object = StatefulSessionComponent.this.invokeAsynchronous(method, context);
                        return object;
                    }
                    Object object = context.proceed();
                    return object;
                }
                finally {
                    context.putPrivateData(Component.class, null);
                    context.putPrivateData(Serializable.class, null);
                }
            }
        };
    }

    public Serializable createSession() {
        return ((StatefulSessionComponentInstance)this.getCache().create()).getId();
    }

    protected Cache<StatefulSessionComponentInstance> getCache() {
        return this.cache;
    }

    protected AbstractComponentInstance constructComponentInstance(Object instance, InterceptorFactoryContext context) {
        return new StatefulSessionComponentInstance(this, instance, context);
    }

    @Override
    public Object invoke(Serializable sessionId, Map<String, Object> contextData, Class<?> invokedBusinessInterface, Method beanMethod, Object[] args) throws Exception {
        if (sessionId == null) {
            throw new IllegalArgumentException("Session is mandatory on Stateful " + (Object)((Object)this));
        }
        if (invokedBusinessInterface != null) {
            throw new UnsupportedOperationException("invokedBusinessInterface != null");
        }
        InterceptorContext context = new InterceptorContext();
        context.putPrivateData(Component.class, (Object)this);
        context.putPrivateData(Serializable.class, (Object)sessionId);
        context.setContextData(contextData);
        context.setMethod(beanMethod);
        context.setParameters(args);
        return this.getComponentInterceptor().processInvocation(context);
    }
}

