/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors;

import java.util.List;
import javax.ejb.Singleton;
import javax.ejb.Stateful;
import javax.ejb.Stateless;
import org.jboss.as.ee.component.AbstractComponentDescription;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.ejb3.component.session.SessionBeanComponentDescription;
import org.jboss.as.ejb3.component.singleton.SingletonComponentDescription;
import org.jboss.as.ejb3.component.stateful.StatefulComponentDescription;
import org.jboss.as.ejb3.component.stateless.StatelessComponentDescription;
import org.jboss.as.ejb3.deployment.EjbDeploymentAttachmentKeys;
import org.jboss.as.ejb3.deployment.EjbDeploymentMarker;
import org.jboss.as.ejb3.deployment.EjbJarDescription;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.logging.Logger;

public final class EjbAnnotationProcessor
implements DeploymentUnitProcessor {
    private static final Logger logger = Logger.getLogger(EjbAnnotationProcessor.class);
    private static final DotName STATELESS_ANNOTATION = DotName.createSimple((String)Stateless.class.getName());
    private static final DotName STATEFUL_ANNOTATION = DotName.createSimple((String)Stateful.class.getName());
    private static final DotName SINGLETON_ANNOTATION = DotName.createSimple((String)Singleton.class.getName());

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        List sbAnnotations;
        List sfsbAnnotations;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (DeploymentTypeMarker.isType((DeploymentType)DeploymentType.EAR, (DeploymentUnit)deploymentUnit)) {
            return;
        }
        CompositeIndex compositeIndex = (CompositeIndex)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.COMPOSITE_ANNOTATION_INDEX);
        if (compositeIndex == null) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Skipping EJB annotation processing since no composite annotation index found in unit: " + deploymentUnit));
            }
            return;
        }
        List slsbAnnotations = compositeIndex.getAnnotations(STATELESS_ANNOTATION);
        if (!slsbAnnotations.isEmpty()) {
            this.processSessionBeans(deploymentUnit, slsbAnnotations, SessionBeanType.STATELESS);
            EjbDeploymentMarker.mark(deploymentUnit);
        }
        if (!(sfsbAnnotations = compositeIndex.getAnnotations(STATEFUL_ANNOTATION)).isEmpty()) {
            this.processSessionBeans(deploymentUnit, sfsbAnnotations, SessionBeanType.STATEFUL);
            EjbDeploymentMarker.mark(deploymentUnit);
        }
        if (!(sbAnnotations = compositeIndex.getAnnotations(SINGLETON_ANNOTATION)).isEmpty()) {
            this.processSessionBeans(deploymentUnit, sbAnnotations, SessionBeanType.SINGLETON);
            EjbDeploymentMarker.mark(deploymentUnit);
        }
    }

    private void processSessionBeans(DeploymentUnit deploymentUnit, List<AnnotationInstance> sessionBeanAnnotations, SessionBeanType sessionBeanType) {
        EEModuleDescription moduleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        EjbJarDescription ejbJarDescription = (EjbJarDescription)deploymentUnit.getAttachment(EjbDeploymentAttachmentKeys.EJB_JAR_DESCRIPTION);
        if (ejbJarDescription == null) {
            ejbJarDescription = new EjbJarDescription(moduleDescription);
            deploymentUnit.putAttachment(EjbDeploymentAttachmentKeys.EJB_JAR_DESCRIPTION, (Object)ejbJarDescription);
        }
        for (AnnotationInstance sessionBeanAnnotation : sessionBeanAnnotations) {
            AnnotationTarget target = sessionBeanAnnotation.target();
            if (!(target instanceof ClassInfo)) {
                logger.warn((Object)(sessionBeanAnnotation.name() + " annotation is expected to be only on classes. " + target + " is not a class"));
                continue;
            }
            ClassInfo sessionBeanClassInfo = (ClassInfo)target;
            String beanClassName = sessionBeanClassInfo.name().toString();
            String ejbName = sessionBeanClassInfo.name().local();
            AnnotationValue nameValue = sessionBeanAnnotation.value("name");
            String beanName = nameValue == null || nameValue.asString().isEmpty() ? ejbName : nameValue.asString();
            SessionBeanComponentDescription sessionBeanDescription = null;
            switch (sessionBeanType) {
                case STATELESS: {
                    sessionBeanDescription = new StatelessComponentDescription(beanName, beanClassName, ejbJarDescription);
                    break;
                }
                case STATEFUL: {
                    sessionBeanDescription = new StatefulComponentDescription(beanName, beanClassName, ejbJarDescription);
                    break;
                }
                case SINGLETON: {
                    sessionBeanDescription = new SingletonComponentDescription(beanName, beanClassName, ejbJarDescription);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown session bean type: " + (Object)((Object)sessionBeanType));
                }
            }
            if (ejbJarDescription.getEEModuleDescription().getComponentByName(sessionBeanDescription.getComponentName()) != null) continue;
            ejbJarDescription.getEEModuleDescription().addComponent((AbstractComponentDescription)sessionBeanDescription);
        }
    }

    public void undeploy(DeploymentUnit context) {
    }

    private static enum SessionBeanType {
        STATELESS,
        STATEFUL,
        SINGLETON;

    }
}

