/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.testenricher.resource;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.logging.Logger;
import javax.annotation.Resource;
import javax.naming.InitialContext;
import org.jboss.arquillian.spi.Context;
import org.jboss.arquillian.spi.TestEnricher;
import org.jboss.arquillian.testenricher.resource.SecurityActions;

public class ResourceInjectionEnricher
implements TestEnricher {
    private static final String RESOURCE_LOOKUP_PREFIX = "java:/comp/env";
    private static final String ANNOTATION_NAME = "javax.annotation.Resource";
    private static final Logger log = Logger.getLogger(ResourceInjectionEnricher.class.getName());

    public void enrich(Context context, Object testCase) {
        if (SecurityActions.isClassPresent(ANNOTATION_NAME)) {
            this.injectClass(testCase);
        }
    }

    public Object[] resolve(Context context, Method method) {
        return new Object[method.getParameterTypes().length];
    }

    protected void injectClass(Object testCase) {
        try {
            Object resource;
            Class<?> resourceAnnotation = SecurityActions.getThreadContextClassLoader().loadClass(ANNOTATION_NAME);
            List<Field> annotatedFields = SecurityActions.getFieldsWithAnnotation(testCase.getClass(), resourceAnnotation);
            for (Field field : annotatedFields) {
                Object currentValue;
                if (!this.shouldInject(field, currentValue = field.get(testCase))) continue;
                resource = this.lookup(this.getResourceName(field));
                field.set(testCase, resource);
            }
            List<Method> methods = SecurityActions.getMethodsWithAnnotation(testCase.getClass(), resourceAnnotation);
            for (Method method : methods) {
                if (method.getParameterTypes().length != 1) {
                    throw new RuntimeException("@Resource only allowed on single argument methods");
                }
                if (!method.getName().startsWith("set")) {
                    throw new RuntimeException("@Resource only allowed on 'set' methods");
                }
                resource = this.lookup(this.getResourceName(method.getAnnotation(Resource.class)));
                method.invoke(testCase, resource);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not inject members", e);
        }
    }

    private boolean shouldInject(Field field, Object currentValue) {
        Class<?> type = field.getType();
        if (type.isPrimitive()) {
            if (this.isPrimitiveNull(currentValue)) {
                log.fine("Primitive field " + field.getName() + " has been detected to have the default primitive value, " + "can not determine if it has already been injected. Re-injecting field.");
                return true;
            }
        } else if (currentValue == null) {
            return true;
        }
        return false;
    }

    private boolean isPrimitiveNull(Object currentValue) {
        String stringValue = String.valueOf(currentValue);
        if ("0".equals(stringValue) || "0.0".equals(stringValue) || "false".equals(stringValue)) {
            return true;
        }
        return Character.class.isInstance(currentValue) && ((Character)Character.class.cast(currentValue)).charValue() == '\u0000';
    }

    protected Object lookup(String jndiName) throws Exception {
        InitialContext context = new InitialContext();
        return context.lookup(jndiName);
    }

    protected String getResourceName(Field field) {
        Resource resource = field.getAnnotation(Resource.class);
        String resourceName = this.getResourceName(resource);
        if (resourceName != null) {
            return resourceName;
        }
        String propertyName = field.getName();
        String className = field.getDeclaringClass().getName();
        return "java:/comp/env/" + className + "/" + propertyName;
    }

    protected String getResourceName(Resource resource) {
        String mappedName = resource.mappedName();
        if (!mappedName.equals("")) {
            return mappedName;
        }
        String name = resource.name();
        if (!name.equals("")) {
            return "java:/comp/env/" + name;
        }
        return null;
    }
}

