/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.inject;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.jboss.msc.inject.InjectionException;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.inject.InjectorLogger;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.ThreadLocalValue;
import org.jboss.msc.value.Value;
import org.jboss.msc.value.Values;

public final class MethodInjector<T>
implements Injector<T> {
    private final Method method;
    private final Value<?> injectedValue;
    private final Value<?> targetValue;
    private final List<? extends Value<?>> parameterList;

    @Deprecated
    public MethodInjector(Value<Method> methodValue, Value<?> targetValue, Value<?> injectedValue, List<? extends Value<?>> parameterList) {
        this(methodValue.getValue(), targetValue, injectedValue, parameterList);
    }

    public MethodInjector(Method method, Value<?> targetValue, Value<?> injectedValue, List<? extends Value<?>> parameterList) {
        if (method == null) {
            throw new IllegalArgumentException("method is null");
        }
        if (targetValue == null) {
            throw new IllegalArgumentException("targetValue is null");
        }
        if (injectedValue == null) {
            throw new IllegalArgumentException("injectedValue is null");
        }
        if (parameterList == null) {
            throw new IllegalArgumentException("parameterList is null");
        }
        ArrayList list = new ArrayList(parameterList);
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            Value value = (Value)list.get(i);
            if (value != null) continue;
            throw new IllegalArgumentException("parameter value at index " + i + " is null");
        }
        this.method = method;
        this.injectedValue = injectedValue;
        this.targetValue = targetValue;
        this.parameterList = parameterList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void inject(T value) throws InjectionException {
        ThreadLocalValue<Object> injectedValue = Values.injectedValue();
        ThreadLocalValue<Object> tlsThisValue = Values.thisValue();
        Value<?> thisValue = this.targetValue;
        Value<Object> oldInjectedValue = injectedValue.getAndSetValue(new ImmediateValue<T>(value));
        try {
            Value<Object> oldThis = tlsThisValue.getAndSetValue(thisValue);
            try {
                this.method.invoke(thisValue.getValue(), Values.getValues(this.parameterList));
            }
            catch (InvocationTargetException e) {
                try {
                    throw e.getCause();
                }
                catch (InjectionException e2) {
                    throw e2;
                }
                catch (Throwable throwable) {
                    throw new InjectionException("Injection failed", e);
                }
            }
            catch (Exception e) {
                throw new InjectionException("Injection failed", e);
            }
            finally {
                tlsThisValue.setValue(oldThis);
            }
        }
        finally {
            injectedValue.setValue(oldInjectedValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uninject() {
        ThreadLocalValue<Object> injectedValue = Values.injectedValue();
        ThreadLocalValue<Object> thisValue = Values.thisValue();
        Value<Object> oldTarget = injectedValue.getAndSetValue(this.injectedValue);
        try {
            Value<Object> oldThis = thisValue.getAndSetValue(this.targetValue);
            try {
                this.method.invoke(this.targetValue.getValue(), Values.getValues(this.parameterList));
                thisValue.setValue(oldThis);
            }
            catch (Throwable t) {
                try {
                    InjectorLogger.INSTANCE.uninjectFailed(t, this.method);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    thisValue.setValue(oldThis);
                }
            }
        }
        finally {
            injectedValue.setValue(oldTarget);
        }
    }
}

