/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.service;

import org.jboss.msc.service.Dependency;
import org.jboss.msc.service.Dependent;
import org.jboss.msc.service.ServiceControllerImpl;
import org.jboss.msc.service.ServiceName;

class OptionalDependency
implements Dependency,
Dependent {
    private boolean dependencyUnavailable = false;
    private final Dependency optionalDependency;
    private DependencyState dependencyState;
    private boolean notifyTransitiveDependencyUnavailable;
    private Dependent dependent;
    private boolean demandedByDependent;
    boolean forwardNotifications;
    private boolean dependentStartedNotified = false;

    OptionalDependency(Dependency optionalDependency) {
        this.optionalDependency = optionalDependency;
        this.dependencyState = DependencyState.AVAILABLE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDependent(Dependent dependent) {
        DependencyState currentDependencyState;
        boolean notifyDependent;
        assert (!Thread.holdsLock(this));
        assert (!Thread.holdsLock(dependent));
        this.optionalDependency.addDependent(this);
        OptionalDependency optionalDependency = this;
        synchronized (optionalDependency) {
            if (this.dependent != null) {
                throw new IllegalStateException("Optional dependent is already set");
            }
            this.dependent = dependent;
            this.forwardNotifications = this.dependencyState.compareTo(DependencyState.AVAILABLE) >= 0;
            notifyDependent = this.forwardNotifications;
            currentDependencyState = this.dependencyState;
        }
        if (notifyDependent) {
            switch (currentDependencyState) {
                case FAILED: {
                    dependent.dependencyFailed();
                    break;
                }
                case UP: {
                    dependent.immediateDependencyUp();
                }
            }
            if (this.notifyTransitiveDependencyUnavailable) {
                dependent.transitiveDependencyUnavailable();
            }
        } else {
            dependent.immediateDependencyUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDependent(Dependent dependent) {
        assert (!Thread.holdsLock(this));
        assert (!Thread.holdsLock(dependent));
        OptionalDependency optionalDependency = this;
        synchronized (optionalDependency) {
            dependent = null;
            this.forwardNotifications = false;
        }
        this.optionalDependency.removeDependent(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDemand() {
        boolean notifyOptionalDependency;
        assert (!Thread.holdsLock(this));
        OptionalDependency optionalDependency = this;
        synchronized (optionalDependency) {
            this.demandedByDependent = true;
            notifyOptionalDependency = this.forwardNotifications;
        }
        if (notifyOptionalDependency) {
            this.optionalDependency.addDemand();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDemand() {
        boolean startNotifying;
        boolean notifyOptionalDependency;
        boolean transitiveDependencyUnavailable;
        DependencyState currentDependencyState;
        assert (!Thread.holdsLock(this));
        OptionalDependency optionalDependency = this;
        synchronized (optionalDependency) {
            this.demandedByDependent = false;
            currentDependencyState = this.dependencyState;
            transitiveDependencyUnavailable = this.notifyTransitiveDependencyUnavailable;
            if (this.forwardNotifications) {
                notifyOptionalDependency = true;
                startNotifying = false;
            } else {
                notifyOptionalDependency = false;
                this.forwardNotifications = this.dependencyState.compareTo(DependencyState.AVAILABLE) >= 0;
                startNotifying = this.forwardNotifications;
            }
        }
        if (startNotifying) {
            switch (currentDependencyState) {
                case AVAILABLE: {
                    this.dependent.immediateDependencyDown();
                    break;
                }
                case FAILED: {
                    this.dependent.dependencyFailed();
                }
            }
            if (transitiveDependencyUnavailable) {
                this.dependent.transitiveDependencyUnavailable();
            }
            if (this.demandedByDependent) {
                this.optionalDependency.addDemand();
            }
        } else if (notifyOptionalDependency) {
            this.optionalDependency.removeDemand();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dependentStarted() {
        boolean notifyOptionalDependency;
        assert (!Thread.holdsLock(this));
        OptionalDependency optionalDependency = this;
        synchronized (optionalDependency) {
            this.dependentStartedNotified = notifyOptionalDependency = this.forwardNotifications;
        }
        if (notifyOptionalDependency) {
            this.optionalDependency.dependentStarted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dependentStopped() {
        boolean notifyOptionalDependency;
        assert (!Thread.holdsLock(this));
        OptionalDependency optionalDependency = this;
        synchronized (optionalDependency) {
            notifyOptionalDependency = this.forwardNotifications && this.dependentStartedNotified;
            this.dependentStartedNotified = false;
        }
        if (notifyOptionalDependency) {
            this.optionalDependency.dependentStopped();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValue() throws IllegalStateException {
        boolean retrieveValue;
        assert (!Thread.holdsLock(this));
        OptionalDependency optionalDependency = this;
        synchronized (optionalDependency) {
            retrieveValue = this.forwardNotifications;
        }
        return retrieveValue ? this.optionalDependency.getValue() : null;
    }

    @Override
    public ServiceName getName() {
        return this.optionalDependency.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void immediateDependencyAvailable(ServiceName dependencyName) {
        boolean notifyOptionalDependent;
        assert (!Thread.holdsLock(this));
        OptionalDependency optionalDependency = this;
        synchronized (optionalDependency) {
            this.dependencyState = DependencyState.AVAILABLE;
            notifyOptionalDependent = !this.demandedByDependent && this.dependent != null;
            this.forwardNotifications = notifyOptionalDependent;
        }
        if (notifyOptionalDependent) {
            this.dependent.immediateDependencyDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void immediateDependencyUnavailable(ServiceName dependencyName) {
        boolean demandNotified;
        boolean currentDependencyUnavailable;
        boolean notificationsForwarded;
        DependencyState currentDependencyState;
        assert (!Thread.holdsLock(this));
        OptionalDependency optionalDependency = this;
        synchronized (optionalDependency) {
            currentDependencyState = this.dependencyState;
            notificationsForwarded = this.forwardNotifications;
            currentDependencyUnavailable = this.dependencyUnavailable;
            this.forwardNotifications = false;
            this.dependencyState = DependencyState.UNAVAILABLE;
            demandNotified = this.demandedByDependent;
        }
        if (notificationsForwarded) {
            switch (currentDependencyState) {
                case FAILED: {
                    this.dependent.dependencyFailureCleared();
                }
                case AVAILABLE: {
                    this.dependent.immediateDependencyUp();
                }
            }
            if (currentDependencyUnavailable) {
                this.dependent.transitiveDependencyAvailable();
            }
            if (demandNotified) {
                this.optionalDependency.removeDemand();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void immediateDependencyUp() {
        boolean notifyOptionalDependent;
        assert (!Thread.holdsLock(this));
        OptionalDependency optionalDependency = this;
        synchronized (optionalDependency) {
            this.dependencyState = DependencyState.UP;
            notifyOptionalDependent = this.forwardNotifications;
        }
        if (notifyOptionalDependent) {
            this.dependent.immediateDependencyUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void immediateDependencyDown() {
        boolean notifyOptionalDependent;
        assert (!Thread.holdsLock(this));
        OptionalDependency optionalDependency = this;
        synchronized (optionalDependency) {
            this.dependencyState = DependencyState.AVAILABLE;
            notifyOptionalDependent = this.forwardNotifications;
        }
        if (notifyOptionalDependent) {
            this.dependent.immediateDependencyDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dependencyFailed() {
        boolean notifyOptionalDependent;
        assert (!Thread.holdsLock(this));
        OptionalDependency optionalDependency = this;
        synchronized (optionalDependency) {
            this.dependencyState = DependencyState.FAILED;
            notifyOptionalDependent = this.forwardNotifications;
        }
        if (notifyOptionalDependent) {
            this.dependent.dependencyFailed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dependencyFailureCleared() {
        boolean notifyOptionalDependent;
        assert (!Thread.holdsLock(this));
        OptionalDependency optionalDependency = this;
        synchronized (optionalDependency) {
            this.dependencyState = DependencyState.AVAILABLE;
            notifyOptionalDependent = this.forwardNotifications;
        }
        if (notifyOptionalDependent) {
            this.dependent.dependencyFailureCleared();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transitiveDependencyAvailable() {
        boolean notifyOptionalDependent;
        assert (!Thread.holdsLock(this));
        OptionalDependency optionalDependency = this;
        synchronized (optionalDependency) {
            notifyOptionalDependent = this.forwardNotifications;
            this.notifyTransitiveDependencyUnavailable = false;
            this.dependencyUnavailable = false;
        }
        if (notifyOptionalDependent) {
            this.dependent.transitiveDependencyAvailable();
        }
    }

    @Override
    public ServiceControllerImpl<?> getController() {
        return this.dependent.getController();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transitiveDependencyUnavailable() {
        boolean notifyOptionalDependent;
        assert (!Thread.holdsLock(this));
        OptionalDependency optionalDependency = this;
        synchronized (optionalDependency) {
            notifyOptionalDependent = this.forwardNotifications;
            this.notifyTransitiveDependencyUnavailable = !notifyOptionalDependent;
            this.dependencyUnavailable = true;
        }
        if (notifyOptionalDependent) {
            this.dependent.transitiveDependencyUnavailable();
        }
    }

    private static enum DependencyState {
        UNAVAILABLE,
        AVAILABLE,
        FAILED,
        UP;

    }
}

