/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.value;

import java.lang.reflect.Method;
import java.util.List;
import org.jboss.msc.value.ErrorMessage;
import org.jboss.msc.value.Value;

@Deprecated
public final class LookupMethodValue
implements Value<Method> {
    private final Value<Class<?>> target;
    private final String methodName;
    private final List<? extends Value<Class<?>>> parameterTypes;
    private final int paramCount;

    public LookupMethodValue(Value<Class<?>> target, String methodName, List<? extends Value<Class<?>>> parameterTypes) {
        if (target == null) {
            throw new IllegalArgumentException("target is null");
        }
        if (methodName == null) {
            throw new IllegalArgumentException("methodName is null");
        }
        if (parameterTypes == null) {
            throw new IllegalArgumentException("parameterTypes is null");
        }
        this.target = target;
        this.methodName = methodName;
        this.parameterTypes = parameterTypes;
        this.paramCount = parameterTypes.size();
    }

    public LookupMethodValue(Value<Class<?>> target, String methodName, int paramCount) {
        if (target == null) {
            throw new IllegalArgumentException("target is null");
        }
        if (methodName == null) {
            throw new IllegalArgumentException("methodName is null");
        }
        this.target = target;
        this.methodName = methodName;
        this.parameterTypes = null;
        this.paramCount = paramCount;
    }

    @Override
    public Method getValue() throws IllegalStateException {
        Class<?> targetClass = this.target.getValue();
        List<Value<Class<?>>> parameterTypes = this.parameterTypes;
        String methodName = this.methodName;
        if (parameterTypes != null) {
            Class[] types = new Class[parameterTypes.size()];
            int i = 0;
            for (Value<Class<?>> type : parameterTypes) {
                types[i++] = type.getValue();
            }
            try {
                return targetClass.getMethod(methodName, types);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException(ErrorMessage.noSuchMethod(targetClass, methodName, parameterTypes));
            }
        }
        int paramCount = this.paramCount;
        for (Method method : targetClass.getMethods()) {
            if (!method.getName().equals(methodName) || method.getParameterTypes().length != paramCount) continue;
            return method;
        }
        throw new IllegalStateException("No such method '" + methodName + "' found on " + targetClass);
    }
}

