/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli;

import java.util.List;
import java.util.Set;
import jline.Completor;
import org.jboss.as.cli.operation.OperationRequestCompleter;

public class CommandCompleter
implements Completor {
    private final OperationRequestCompleter opCompleter;
    private final Set<String> commands;

    public CommandCompleter(Set<String> commands, OperationRequestCompleter opCompleter) {
        if (commands == null) {
            throw new IllegalArgumentException("Set of commands can't be null.");
        }
        this.commands = commands;
        this.opCompleter = opCompleter;
    }

    public int complete(String buffer, int cursor, List candidates) {
        if (buffer.isEmpty()) {
            candidates.addAll(this.commands);
            return 0;
        }
        char firstChar = buffer.charAt(0);
        if (firstChar == '.' || firstChar == ':' || firstChar == '/') {
            return -1;
        }
        if (buffer.startsWith("cd ") || buffer.startsWith("cn ")) {
            String opBuffer = buffer.substring(3);
            int result = this.opCompleter.complete(opBuffer, cursor, candidates);
            if (result >= 0) {
                return result + 3;
            }
            return result;
        }
        for (String command : this.commands) {
            if (!command.startsWith(buffer)) continue;
            candidates.add(command);
        }
        return 0;
    }
}

