/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import jline.Completor;
import jline.ConsoleReader;
import org.jboss.as.cli.CommandCompleter;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandHandler;
import org.jboss.as.cli.SecurityActions;
import org.jboss.as.cli.handlers.ConnectHandler;
import org.jboss.as.cli.handlers.HelpHandler;
import org.jboss.as.cli.handlers.OperationRequestHandler;
import org.jboss.as.cli.handlers.PrefixHandler;
import org.jboss.as.cli.handlers.QuitHandler;
import org.jboss.as.cli.operation.OperationCandidatesProvider;
import org.jboss.as.cli.operation.OperationRequestAddress;
import org.jboss.as.cli.operation.OperationRequestCompleter;
import org.jboss.as.cli.operation.OperationRequestParser;
import org.jboss.as.cli.operation.PrefixFormatter;
import org.jboss.as.cli.operation.impl.DefaultOperationCandidatesProvider;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestAddress;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestParser;
import org.jboss.as.cli.operation.impl.DefaultPrefixFormatter;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.protocol.StreamUtils;

public class CommandLineMain {
    private static final Map<String, CommandHandler> handlers = new HashMap<String, CommandHandler>();
    private static final CommandHandler operationHandler;

    private static void registerHandler(CommandHandler handler, String ... names) {
        for (String name : names) {
            CommandHandler previous = handlers.put(name, handler);
            if (previous == null) continue;
            throw new IllegalStateException("Duplicate command name '" + name + "'. Handlers: " + previous + ", " + handler);
        }
    }

    public static void main(String[] args) throws Exception {
        ConsoleReader console = new ConsoleReader();
        console.setUseHistory(true);
        final CommandContextImpl cmdCtx = new CommandContextImpl(console);
        SecurityActions.addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                StreamUtils.safeClose((Closeable)cmdCtx.client);
                cmdCtx.log("closed");
            }
        }));
        OperationRequestCompleter opCompleter = new OperationRequestCompleter(cmdCtx);
        console.addCompletor((Completor)new CommandCompleter(handlers.keySet(), opCompleter));
        console.addCompletor((Completor)opCompleter);
        cmdCtx.log("You are disconnected at the moment. Type 'connect' to connect to the server or 'help' for the list of supported commands.");
        while (!cmdCtx.terminate) {
            String line = console.readLine("[" + cmdCtx.getPrefixFormatter().format(cmdCtx.getPrefix()) + "] ");
            if (line.isEmpty()) continue;
            if (CommandLineMain.isOperation(line)) {
                String opReq = line.startsWith("./") ? line.substring(2) : line;
                cmdCtx.cmdArgs = opReq;
                operationHandler.handle(cmdCtx);
                continue;
            }
            String cmd = line.toLowerCase();
            cmdCtx.cmdArgs = null;
            for (int i = 0; i < cmd.length(); ++i) {
                if (!Character.isWhitespace(cmd.charAt(i))) continue;
                cmdCtx.cmdArgs = cmd.substring(i + 1).trim();
                cmd = cmd.substring(0, i);
            }
            CommandHandler handler = handlers.get(cmd);
            if (handler != null) {
                handler.handle(cmdCtx);
                continue;
            }
            cmdCtx.log("Unexpected command '" + line + "'. Type 'help' for the list of supported commands.");
        }
        StreamUtils.safeClose((Closeable)cmdCtx.client);
    }

    private static boolean isOperation(String line) {
        char firstChar = line.charAt(0);
        return firstChar == '.' || firstChar == ':' || firstChar == '/' || line.startsWith("..") || line.startsWith(".type");
    }

    static {
        CommandLineMain.registerHandler(new HelpHandler(), "help", "h");
        CommandLineMain.registerHandler(new QuitHandler(), "quit", "q");
        CommandLineMain.registerHandler(new ConnectHandler(), "connect");
        CommandLineMain.registerHandler(new PrefixHandler(), "cd", "cn");
        operationHandler = new OperationRequestHandler();
    }

    private static class CommandContextImpl
    implements CommandContext {
        private ConsoleReader console;
        private boolean terminate;
        private String cmdArgs;
        private ModelControllerClient client;
        private Map<String, Object> map = new HashMap<String, Object>();
        private final OperationRequestParser parser = new DefaultOperationRequestParser();
        private final OperationRequestAddress prefix = new DefaultOperationRequestAddress();
        private final PrefixFormatter prefixFormatter = new DefaultPrefixFormatter();
        private final OperationCandidatesProvider operationCandidatesProvider;

        private CommandContextImpl(ConsoleReader console) {
            this.console = console;
            this.operationCandidatesProvider = new DefaultOperationCandidatesProvider(this);
        }

        @Override
        public String getCommandArguments() {
            return this.cmdArgs;
        }

        @Override
        public void terminateSession() {
            this.terminate = true;
        }

        @Override
        public void log(String message) {
            try {
                this.console.printString(message);
                this.console.printNewline();
            }
            catch (IOException e) {
                System.err.println("Failed to print '" + message + "' to the console: " + e.getLocalizedMessage());
            }
        }

        @Override
        public void set(String key, Object value) {
            this.map.put(key, value);
        }

        @Override
        public Object get(String key) {
            return this.map.get(key);
        }

        @Override
        public ModelControllerClient getModelControllerClient() {
            return this.client;
        }

        @Override
        public void setModelControllerClient(ModelControllerClient client) {
            this.client = client;
        }

        @Override
        public OperationRequestParser getOperationRequestParser() {
            return this.parser;
        }

        @Override
        public OperationRequestAddress getPrefix() {
            return this.prefix;
        }

        @Override
        public PrefixFormatter getPrefixFormatter() {
            return this.prefixFormatter;
        }

        @Override
        public OperationCandidatesProvider getOperationCandidatesProvider() {
            return this.operationCandidatesProvider;
        }
    }
}

