/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers.jms;

import java.util.Collections;
import java.util.List;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.handlers.BatchModeCommandHandler;
import org.jboss.as.cli.impl.ArgumentWithValue;
import org.jboss.as.cli.impl.DefaultCompleter;
import org.jboss.as.cli.operation.OperationFormatException;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestBuilder;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;

public class JmsCFRemoveHandler
extends BatchModeCommandHandler {
    private final ArgumentWithValue profile = new ArgumentWithValue(this, new DefaultCompleter(new DefaultCompleter.CandidatesProvider(){

        @Override
        public List<String> getAllCandidates(CommandContext ctx) {
            return Util.getNodeNames(ctx.getModelControllerClient(), null, "profile");
        }
    }), "--profile"){

        @Override
        public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
            if (!ctx.isDomainMode()) {
                return false;
            }
            return super.canAppearNext(ctx);
        }
    };
    private final ArgumentWithValue name = new ArgumentWithValue(this, new DefaultCompleter(new DefaultCompleter.CandidatesProvider(){

        @Override
        public List<String> getAllCandidates(CommandContext ctx) {
            String profileArg;
            ModelControllerClient client = ctx.getModelControllerClient();
            if (client == null) {
                return Collections.emptyList();
            }
            if (!ctx.isDomainMode()) {
                profileArg = null;
            } else {
                profileArg = JmsCFRemoveHandler.this.profile.getValue(ctx.getParsedArguments());
                if (profileArg == null) {
                    return Collections.emptyList();
                }
            }
            return Util.getJmsResources(ctx.getModelControllerClient(), profileArg, "connection-factory");
        }
    }), 0, "--name"){

        @Override
        public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
            if (ctx.isDomainMode() && !JmsCFRemoveHandler.this.profile.isPresent(ctx.getParsedArguments())) {
                return false;
            }
            return super.canAppearNext(ctx);
        }
    };

    public JmsCFRemoveHandler() {
        super("jms-cf-remove", true);
    }

    @Override
    public ModelNode buildRequest(CommandContext ctx) throws CommandFormatException {
        String name = this.name.getValue(ctx.getParsedArguments(), true);
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        if (ctx.isDomainMode()) {
            String profile = this.profile.getValue(ctx.getParsedArguments());
            if (profile == null) {
                throw new OperationFormatException("Required argument --profile is missing.");
            }
            builder.addNode("profile", profile);
        }
        builder.addNode("subsystem", "messaging");
        builder.addNode("connection-factory", name);
        builder.setOperationName("remove");
        return builder.buildRequest();
    }
}

